/*
 * (C) Finite State Machine Labs Inc. 2000 business@fsmlabs.com
 *
 * Released under the terms of GPL 2.
 * Open RTLinux makes use of a patented process described in
 * US Patent 5,995,745. Use of this process is governed
 * by the Open RTLinux Patent License which can be obtained from
 * www.fsmlabs.com/PATENT or by sending email to
 * licensequestions@fsmlabs.com
 */

/*
 * This is a hack to get NR_IRQS on the PowerPC since it depends on
 * the configured machine and processor type as well as having __KERNEL__
 * defined.  Other architectures (alpha, mips) may need this one day as well.
 * -- Cort
 */
#define __KERNEL__
#include <linux/autoconf.h>
#include <asm/irq.h>
#undef __KERNEL__

#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <rtlinux_signal.h>
/*#include <sys/mman.h>*//* sys/mman.h has old and wrong values -- Cort */
#include <asm/mman.h>
#include <stdio.h>

long PssEnableInt(unsigned long intnum)
{
	return 0;
}

long PssDisableInt(unsigned long intnum)
{
	return 0;
}

long PssSetIntHandler(unsigned long intnum, void *handler)
{
	struct rtlinux_sigaction sig, oldsig;

	sig.sa_handler = handler;
	sig.sa_flags = RTLINUX_SA_RESETHAND;

	if (rtlinux_sigaction(intnum, &sig, &oldsig))
		return -1;
	return 0;
}
