/* $Id: ppc-stub.c,v 1.6 1999/08/12 22:18:11 cort Exp $
 * ppc-stub.c:  KGDB support for the Linux kernel.
 *
 * RTLinux Debugger modifications are written by Michael Barabanov
 * (baraban@fsmlabs.com) and are
 * Copyright (C) 2000, Finite State Machine Labs Inc.
 *
 * adapted from arch/sparc/kernel/sparc-stub.c for the PowerPC
 * some stuff borrowed from Paul Mackerras' xmon
 * Copyright (C) 1998 Michael AK Tesch (tesch@cs.wisc.edu)
 *
 * Modifications to run under Linux
 * Copyright (C) 1995 David S. Miller (davem@caip.rutgers.edu)
 *
 * This file originally came from the gdb sources, and the
 * copyright notices have been retained below.
 */

/****************************************************************************

		THIS SOFTWARE IS NOT COPYRIGHTED

   HP offers the following for use in the public domain.  HP makes no
   warranty with regard to the software or its performance and the
   user accepts the software "AS IS" with all faults.

   HP DISCLAIMS ANY WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD
   TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO THE WARRANTIES
   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

****************************************************************************/

/****************************************************************************
 *  Header: remcom.c,v 1.34 91/03/09 12:29:49 glenne Exp $
 *
 *  Module name: remcom.c $
 *  Revision: 1.34 $
 *  Date: 91/03/09 12:29:49 $
 *  Contributor:     Lake Stevens Instrument Division$
 *
 *  Description:     low level support for gdb debugger. $
 *
 *  Considerations:  only works on target hardware $
 *
 *  Written by:      Glenn Engel $
 *  ModuleState:     Experimental $
 *
 *  NOTES:           See Below $
 *
 *  Modified for SPARC by Stu Grossman, Cygnus Support.
 *
 *  This code has been extensively tested on the Fujitsu SPARClite demo board.
 *
 *  To enable debugger support, two things need to happen.  One, a
 *  call to set_debug_traps() is necessary in order to allow any breakpoints
 *  or error conditions to be properly intercepted and reported to gdb.
 *  Two, a breakpoint needs to be generated to begin communication.  This
 *  is most easily accomplished by a call to breakpoint().  Breakpoint()
 *  simulates a breakpoint by executing a trap #1.
 *
 *************
 *
 *    The following gdb commands are supported:
 *
 * command          function                               Return value
 *
 *    g             return the value of the CPU registers  hex data or ENN
 *    G             set the value of the CPU registers     OK or ENN
 *    qOffsets      Get section offsets.  Reply is Text=xxx;Data=yyy;Bss=zzz
 *
 *    mAA..AA,LLLL  Read LLLL bytes at address AA..AA      hex data or ENN
 *    MAA..AA,LLLL: Write LLLL bytes at address AA.AA      OK or ENN
 *
 *    c             Resume at current address              SNN   ( signal NN)
 *    cAA..AA       Continue at address AA..AA             SNN
 *
 *    s             Step one instruction                   SNN
 *    sAA..AA       Step one instruction from AA..AA       SNN
 *
 *    k             kill
 *
 *    ?             What was the last sigval ?             SNN   (signal NN)
 *
 *    bBB..BB	    Set baud rate to BB..BB		   OK or BNN, then sets
 *							   baud rate
 *
 * All commands and responses are sent with a packet which includes a
 * checksum.  A packet consists of
 *
 * $<packet info>#<checksum>.
 *
 * where
 * <packet info> :: <characters representing the command or response>
 * <checksum>    :: <two hex digits computed as modulo 256 sum of <packetinfo>>
 *
 * When a packet is received, it is first acknowledged with either '+' or '-'.
 * '+' indicates a successful transfer.  '-' indicates a failed transfer.
 *
 * Example:
 *
 * Host:                  Reply:
 * $m0,10#2a               +$00010203040506070809101112131415#42
 *
 ****************************************************************************/

#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>

#include <asm/system.h>
#include <asm/signal.h>
#include <asm/pgtable.h>
#include <asm/ptrace.h>
#include <linux/signal.h>

/* RTLinux support */
#define __NO_VERSION__
#include <linux/module.h>

#include <rtl_sync.h>


#include <rtl_sched.h>


#define strtoul simple_strtoul

#include <psc.h>


#define rtl_running_linux() (pthread_self() == &LOCAL_SCHED->rtl_linux_task)

int rtl_debug_initialized = 0;


/* end of RTLinux support */

static void (*debugger_fault_handler)(struct pt_regs *regs) = 0;
static void kgdb_fault_handler(struct pt_regs *regs);

static int handle_exception (struct pt_regs *regs);

extern int putDebugChar(int);   /* write a single character      */
extern int getDebugChar(void);   /* read and return a single char */

#define BPCODE 0x7d821008
#define STR_BPCODE "7d821008"
/*
 * BUFMAX defines the maximum number of characters in inbound/outbound buffers
 * at least NUMREGBYTES*2 are needed for register packets
 */
#define BUFMAX 2048
static char remcomInBuffer[BUFMAX];
static char remcomOutBuffer[BUFMAX];

static int kgdb_active = 0;
static u_int fault_jmp_buf[100];
static int kdebug;

static const char hexchars[]="0123456789abcdef";

/* Place where we save old trap entries for restoration - sparc*/
/* struct tt_entry kgdb_savettable[256]; */
/* typedef void (*trapfunc_t)(void); */

#if 0
/* Install an exception handler for kgdb */
static void exceptionHandler(int tnum, unsigned int *tfunc)
{
	/* We are dorking with a live trap table, all irqs off */
}
#endif

int
kgdb_setjmp(long *buf)
{
	asm ("mflr 0; stw 0,0(%0);"
	     "stw 1,4(%0); stw 2,8(%0);"
	     "mfcr 0; stw 0,12(%0);"
	     "stmw 13,16(%0)"
	     : : "r" (buf));
	/* XXX should save fp regs as well */
	return 0;
}
void
kgdb_longjmp(long *buf, int val)
{
	if (val == 0)
		val = 1;
	asm ("lmw 13,16(%0);"
	     "lwz 0,12(%0); mtcrf 0x38,0;"
	     "lwz 0,0(%0); lwz 1,4(%0); lwz 2,8(%0);"
	     "mtlr 0; mr 3,%1"
	     : : "r" (buf), "r" (val));
}
/* Convert ch from a hex digit to an int */
static int
hex(unsigned char ch)
{
	if (ch >= 'a' && ch <= 'f')
		return ch-'a'+10;
	if (ch >= '0' && ch <= '9')
		return ch-'0';
	if (ch >= 'A' && ch <= 'F')
		return ch-'A'+10;
	return -1;
}

/* Convert the memory pointed to by mem into hex, placing result in buf.
 * Return a pointer to the last char put in buf (null), in case of mem fault,
 * return 0.
 */
static unsigned char *
mem2hex(char *mem, char *buf, int count)
{
	unsigned char ch;

	if (kgdb_setjmp((long*)fault_jmp_buf) == 0) {
		debugger_fault_handler = kgdb_fault_handler;
		while (count-- > 0) {
			ch = *mem++;
			*buf++ = hexchars[ch >> 4];
			*buf++ = hexchars[ch & 0xf];
		}
	} else {
		/* error condition */
	}
	debugger_fault_handler = 0;
	*buf = 0;
	return buf;
}

/* convert the hex array pointed to by buf into binary to be placed in mem
 * return a pointer to the character AFTER the last byte written.
*/
static char *
hex2mem(char *buf, char *mem, int count)
{
	int i;
	unsigned char ch;

	if (kgdb_setjmp((long*)fault_jmp_buf) == 0) {
		debugger_fault_handler = kgdb_fault_handler;
		for (i=0; i<count; i++) {
			ch = hex(*buf++) << 4;
			ch |= hex(*buf++);
			*mem++ = ch;
		}
		flush_icache_range((int)mem, (int)mem+count);
	} else {
		/* error condition */
	}
	debugger_fault_handler = 0;
	return mem;
}

/*
 * While we find nice hex chars, build an int.
 * Return number of chars processed.
 */
static int
hexToInt(char **ptr, int *intValue)
{
	int numChars = 0;
	int hexValue;

	*intValue = 0;

	if (kgdb_setjmp((long*)fault_jmp_buf) == 0) {
		debugger_fault_handler = kgdb_fault_handler;
		while (**ptr) {
			hexValue = hex(**ptr);
			if (hexValue < 0)
				break;

			*intValue = (*intValue << 4) | hexValue;
			numChars ++;

			(*ptr)++;
		}
	} else {
	     /* error condition */
	}
	debugger_fault_handler = 0;

	return (numChars);
}

/* scan for the sequence $<data>#<checksum>     */
static void
getpacket(char *buffer)
{
	unsigned char checksum;
	unsigned char xmitcsum;
	int i;
	int count;
	unsigned char ch;

	do {
		/* wait around for the start character, ignore all other
		 * characters */
		while ((ch = (getDebugChar() & 0x7f)) != '$') ;

		checksum = 0;
		xmitcsum = -1;

		count = 0;

		/* now, read until a # or end of buffer is found */
		while (count < BUFMAX) {
			ch = getDebugChar() & 0x7f;
			if (ch == '#')
				break;
			checksum = checksum + ch;
			buffer[count] = ch;
			count = count + 1;
		}

		if (count >= BUFMAX)
			continue;

		buffer[count] = 0;

		if (ch == '#') {
			xmitcsum = hex(getDebugChar() & 0x7f) << 4;
			xmitcsum |= hex(getDebugChar() & 0x7f);
			if (checksum != xmitcsum)
				putDebugChar('-');	/* failed checksum */
			else {
				putDebugChar('+'); /* successful transfer */
				/* if a sequence char is present, reply the ID */
				if (buffer[2] == ':') {
					putDebugChar(buffer[0]);
					putDebugChar(buffer[1]);
					/* remove sequence chars from buffer */
					count = strlen(buffer);
					for (i=3; i <= count; i++)
						buffer[i-3] = buffer[i];
				}
			}
		}
	} while (checksum != xmitcsum);
}

/* send the packet in buffer.  */
static void putpacket(unsigned char *buffer)
{
	unsigned char checksum;
	int count;
	unsigned char ch, recv;

	/*  $<packet info>#<checksum>. */
	do {
		putDebugChar('$');
		checksum = 0;
		count = 0;

		while ((ch = buffer[count])) {
			putDebugChar(ch);
			checksum += ch;
			count += 1;
		}

		putDebugChar('#');
		putDebugChar(hexchars[checksum >> 4]);
		putDebugChar(hexchars[checksum & 0xf]);
		recv = getDebugChar();
	} while ((recv & 0x7f) != '+');
}

static void kgdb_flush_cache_all(void)
{
	flush_instruction_cache();
}

static inline int get_msr(void)
{
	int msr;
	asm volatile("mfmsr %0" : "=r" (msr):);
	return msr;
}

static inline void set_msr(int msr)
{
	asm volatile("mtmsr %0" : : "r" (msr));
}

/* Set up exception handlers for tracing and breakpoints
 * [could be called kgdb_init()]
 */

#include "rtl_ex.c"

int rtl_debug_exception(int vector, struct pt_regs *regs, int error_code)
{
	return handle_exception(regs);
}

int set_debug_traps(void)
{
#if 0
	unsigned char c;

	save_and_cli(flags);

	/* In case GDB is started before us, ack any packets (presumably
	 * "$?#xx") sitting there.
	 *
	 * I've found this code causes more problems than it solves,
	 * so that's why it's commented out.  GDB seems to work fine
	 * now starting either before or after the kernel   -bwb
	 */

	while((c = getDebugChar()) != '$');
	while((c = getDebugChar()) != '#');
	c = getDebugChar(); /* eat first csum byte */
	c = getDebugChar(); /* eat second csum byte */
	putDebugChar('+'); /* ack it */
#endif
	rtl_request_traps(&rtl_debug_exception);

	rtl_debug_initialized = 1;
	return 0;
}

void unset_debug_traps(void)
{
	rtl_request_traps(0);
	rtl_debug_initialized = 0;
}

/* more RTLinux support */
#define CONFIG_RTL_DEBUGGER_THREADS
#define CONFIG_RTL_DEBUGGER_Z_PROTOCOL
#define CONFIG_RTL_DEBUG_BP_HACK

static spinlock_t bp_lock = SPIN_LOCK_UNLOCKED;

#define RTL_MAX_BP 1024
static struct bp_cache_entry {
	char *mem;
	unsigned long val;
	struct bp_cache_entry *next;
} bp_cache [RTL_MAX_BP];

static struct bp_cache_entry *cache_start = 0;

int insert_bp(char *mem)
{
	int i;
	struct bp_cache_entry *e;
	unsigned int old;
	char buf[10];

	if (!mem2hex(mem, buf, 4)) {
		return EINVAL; /* memory error */
	}

	if (!hex2mem(STR_BPCODE, mem, 4)) {
		return EINVAL;
	}

	old = strtoul(buf, 0, 16);

	for (e = cache_start; e; e = e->next) {
		if (e->mem == mem) {
			return EINVAL; /* already there */
		}
	}
	for (i = 0; i < RTL_MAX_BP; i++) {
		if (bp_cache[i].mem == 0) {
			break;
		}
	}
	if (i == RTL_MAX_BP) {
		return EINVAL; /* no space */
	}
	bp_cache[i] . val = old;
	bp_cache[i] . mem = mem;
	bp_cache[i] . next = cache_start;
	cache_start = &bp_cache[i];
	debugpr("inserted %x, old contents = %x\n", mem, old);

	return 0;
}

int search_bp (char *mem)
{
	struct bp_cache_entry *e = cache_start;
	struct bp_cache_entry *f = 0;
	spin_lock (&bp_lock);
	if (!e) {
		spin_unlock (&bp_lock);
		return EINVAL;
	}
	if (e->mem == mem) {
		f = e;
	} else {
		for (; e->next; e = e->next) {
			if (e->next->mem == mem) {
				f = e->next;
				break;
			}
		}
	}
	if (!f) {
		spin_unlock (&bp_lock);
		return EINVAL;
	}

	spin_unlock (&bp_lock);
	return 0;
}

int remove_bp (char *mem)
{
	struct bp_cache_entry *e = cache_start;
	struct bp_cache_entry *f = 0;
	char buf[10];
	if (!e) {
		return EINVAL;
	}
	if (e->mem == mem) {
		cache_start = e->next;
		f = e;
	} else {
		for (; e->next; e = e->next) {
			if (e->next->mem == mem) {
				f = e->next;
				e->next = f->next;
				break;
			}
		}
	}
	if (!f) {
		return EINVAL;
	}

	sprintf(buf, "%08x", (unsigned) f->val);
	hex2mem(buf, f->mem, 4);
	debugpr("removed %x, restored %s (real) %x\n", f->mem, buf, *((unsigned long *) (f->mem)));
	
	kgdb_flush_cache_all();
	flush_icache_range((unsigned) f->mem, (unsigned)( f->mem)+4);
	return 0;
}

static int send_exception_info = 0;
struct module *mod;
static void kgdb_fault_handler(struct pt_regs *regs)
{
	kgdb_longjmp((long*)fault_jmp_buf, 1);
}


/* Convert the SPARC hardware trap type code to a unix signal number. */
/*
 * This table contains the mapping between PowerPC hardware trap types, and
 * signals, which are primarily what GDB understands.
 */
static struct hard_trap_info
{
	unsigned int tt;		/* Trap type code for powerpc */
	unsigned char signo;		/* Signal that we map this trap into */
} hard_trap_info[] = {
	{ 0x200, SIGSEGV },			/* machine check */
	{ 0x300, SIGSEGV },			/* address error (store) */
	{ 0x400, SIGBUS },			/* instruction bus error */
	{ 0x500, SIGINT },			/* interrupt */
	{ 0x600, SIGBUS },			/* alingment */
	{ 0x700, SIGTRAP },			/* breakpoint trap */
	{ 0x800, SIGFPE },			/* fpu unavail */
	{ 0x900, SIGALRM },			/* decrementer */
	{ 0xa00, SIGILL },			/* reserved */
	{ 0xb00, SIGILL },			/* reserved */
	{ 0xc00, SIGCHLD },			/* syscall */
	{ 0xd00, SIGTRAP },			/* single-step/watch */
	{ 0xe00, SIGFPE },			/* fp assist */
	{ 0, 0}				/* Must be last */
};

static int computeSignal(unsigned int tt)
{
	struct hard_trap_info *ht;

	for (ht = hard_trap_info; ht->tt && ht->signo; ht++)
		if (ht->tt == tt)
			return ht->signo;

	return SIGHUP;         /* default for things we don't know about */
}

#define PC_REGNUM 64
#define SP_REGNUM 1

  
/*
 * This function does all command processing for interfacing to gdb.
 */
static int
handle_exception (struct pt_regs *regs)
{
	int signo;
	int addr;
	int length;
	char *ptr;
/* 	unsigned long nip = regs->nip; */
	unsigned int msr;
	int exceptionVector = regs->trap;

  unsigned long flags;
#ifdef CONFIG_RTL_DEBUGGER_THREADS
  pthread_t current_thread = pthread_self();
#endif

  if (user_mode(regs) && !(rtl_is_psc_active())) {
    return(0);
  }
  	if (debugger_fault_handler) {
		debugger_fault_handler(regs);
	}

	if (debugger_fault_handler) {
		debugger_fault_handler(regs);
		panic("kgdb longjump failed!\n");
	}

	rtl_hard_savef_and_cli(flags);

#ifdef KGDB_DEBUG
	printk("kgdb: entering handle_exception; trap [0x%x]\n",
	       (unsigned int)regs->trap);
#endif

	msr = get_msr();
	signo = computeSignal(exceptionVector);

	if (rtl_running_linux() && exceptionVector != 0x700  && exceptionVector != 0xd00) {
		rtl_hard_restore_flags(flags) ;
		return 0; /* let linux handle it's own faults */
	}

	/*   debugpr("exception: %x\n", exceptionVector); */
	debugpr("exception: %x regs->nip=%x regs->msr=%x msr=%x MSR_EE=%x\n",
			exceptionVector, regs->nip, regs->msr, msr, MSR_EE);

	/* can't trace with interrupts disabled or in Linux mode */
	if (exceptionVector == 0xd00 && (!(regs->msr & MSR_EE) || rtl_running_linux())) {
		regs->msr &= ~MSR_SE; /* clear trace bit */
		debugpr("can't single step");
		kgdb_flush_cache_all();
		set_msr(msr);
		rtl_hard_restore_flags(flags) ;
		return(1) ;
	}

	if (exceptionVector == 0x700) {
		/* disable breakpoints if they're hit with interrupts disabled or in Linux mode */
		if ((!(regs->msr & MSR_EE) || rtl_running_linux())) {
			spin_lock (&bp_lock);
			if (remove_bp (((char *) regs->nip))) {
				debugpr("advancing");
				regs->nip += 4; /* there's no cached breakpoint, so nothing to retry */
			}
			spin_unlock (&bp_lock);
			debugpr("can't breakpoint");
			regs->msr |= MSR_SE;
			kgdb_flush_cache_all();
			set_msr(msr);
			rtl_hard_restore_flags(flags) ;
			return(1) ;
		}
		if (*((unsigned long *)regs->nip) == BPCODE && search_bp((char *)regs->nip)) {
			/* Skip over breakpoint trap insn */
			regs->nip += 4;
		}
	}


  /* ok, here we know pthread_self() is an RT-thread */
  pthread_cleanup_push (&rtl_exit_debugger, 0);
  rtl_enter_debugger(exceptionVector, (void *) regs->nip);

  /* reply to host that an exception has occurred */
  set_bit(0, &send_exception_info);

	while (1) {
	    remcomOutBuffer[0] = 0;
	    if (test_and_clear_bit(0, &send_exception_info)) {
		strcpy(remcomInBuffer, "?");
	    } else {
		    getpacket(remcomInBuffer);
	    }

	    switch (remcomInBuffer[0]) {
		case 'q' : 
			if (!strcmp(remcomInBuffer, "qOffsets") && text && data && bss && !rtl_is_psc_active()) {
				sprintf(remcomOutBuffer, "Text=%x;Data=%x;Bss=%x",
				(unsigned )text, (unsigned )data, (unsigned )bss);
			}
#ifdef CONFIG_RTL_DEBUGGER_THREADS
	 if (!strcmp(remcomInBuffer, "qC")) {
		 sprintf(remcomOutBuffer, "QC%x", (unsigned )(pthread_self()));
	 } else if (!strncmp(remcomInBuffer, "qL", 2)) {
		 /* we assume we have a limit of 31 threads -- to fit in one packet */
		 char packethead[17];
		 pthread_t task;
		 int ntasks = 0;
		 int i;

		 strcpy(remcomOutBuffer, remcomInBuffer);

		for (i = 0; i < rtl_num_cpus(); i++) {
			 int cpu_id = cpu_logical_map (i);
			 schedule_t *s = &rtl_sched [cpu_id];

			 spin_lock (&s->rtl_tasks_lock);
			 task = s->rtl_tasks;
			 while (task != &s->rtl_linux_task && ntasks < 31) {
				 sprintf((remcomOutBuffer) + strlen(remcomOutBuffer),
						 "00000000%08x", (unsigned) task);
				 task = task->next;
				 ntasks++;
			 }
			 spin_unlock (&s->rtl_tasks_lock);
		}
		sprintf(packethead, "qM%02x%01x", ntasks, 1 /* done */);
		memcpy(remcomOutBuffer, packethead, strlen(packethead));
	 }
#endif
	 break;
#ifdef CONFIG_RTL_DEBUGGER_THREADS
      case 'H': if (/* remcomInBuffer[1] == 'c' ||*/ remcomInBuffer[1] == 'g') {
		       if (remcomInBuffer[2] == '-') {
			current_thread = (pthread_t) -strtoul(remcomInBuffer + 3, 0, 16);
		       } else  {
			current_thread = (pthread_t) strtoul(remcomInBuffer + 2, 0, 16);
		       }
			strcpy(remcomOutBuffer, "OK");
		}
		break;

      case 'T':{
		       pthread_t thread;
		       if (remcomInBuffer[1] == '-') {
			thread = (pthread_t) -strtoul(remcomInBuffer + 2, 0, 16);
		       } else  {
			thread = (pthread_t) strtoul(remcomInBuffer + 1, 0, 16);
		       }
		       if (!pthread_kill(thread, 0)) {
			       strcpy(remcomOutBuffer, "OK");
		       } else {
			       strcpy(remcomOutBuffer, "ERROR");
		       }

		}
		break;
#endif
#ifdef CONFIG_RTL_DEBUGGER_Z_PROTOCOL
      case 'Z': case 'z' :
		{
			int type = remcomInBuffer[1] - '0';
			unsigned address = strtoul(remcomInBuffer + 3, 0, 16);
			int res;
			if (type != 0) {
				strcpy(remcomOutBuffer, "ERROR");
				break;
			}
			spin_lock (&bp_lock);
			if (remcomInBuffer[0] == 'Z') {
				res = insert_bp((char *)address);
			} else {
				remove_bp((char *)address);
				res = 0;
			}
			spin_unlock (&bp_lock);
			if (res) {
				strcpy(remcomOutBuffer, "ERROR");
			} else {
				strcpy(remcomOutBuffer, "OK");
			}

		}
		break;
#endif
      case '?' :
#ifdef CONFIG_RTL_DEBUGGER_THREADS
		sprintf(remcomOutBuffer, "T%02xthread:%x;", signo, (unsigned) pthread_self());

#else
		remcomOutBuffer[0] = 'S';
                   remcomOutBuffer[1] =  hexchars[signo >> 4];
                   remcomOutBuffer[2] =  hexchars[signo % 16];
                   remcomOutBuffer[3] = 0;
#endif
                 break;
		case 'd':
			/* toggle debug flag */
			kdebug ^= 1;
			break;

		case 'g':	/* return the value of the CPU registers.
				 * some of them are non-PowerPC names :(
				 * they are stored in gdb like:
				 * struct {
				 *     u32 gpr[32];
				 *     f64 fpr[32];
				 *     u32 pc, ps, cnd, lr; (ps=msr)
				 *     u32 cnt, xer, mq;
				 * }
				 */
		{
			int i;
			struct pt_regs *t_regs = regs;
#ifdef CONFIG_RTL_DEBUGGER_THREADS
			struct pt_regs r = *regs;
			if (current_thread != pthread_self()) {
				t_regs = &r;
/*				rtl_printf("thread %x\n", current_thread);
				rtl_printf("stack=%x\n", current_thread->stack);
				for (i=0; i < 10; i++) {
					rtl_printf("%d: %#x    ", i, *(current_thread->stack + i));
				}
				rtl_printf("\n"); */
				for(i=0; i<32; i++) {
					t_regs->gpr[i] = *(current_thread->stack + 5 + i);
/* 					rtl_printf("%d: %#x    ", i, t_regs->gpr[i]); */
				}
				t_regs->msr = *(current_thread->stack + 0);
				t_regs->nip = *(current_thread->stack + 4);
			}
#endif
			ptr = remcomOutBuffer;
			/* General Purpose Regs */
			ptr = mem2hex((char *)t_regs, ptr, 32 * 4);
			/* Floating Point Regs - FIXME */
			/*ptr = mem2hex((char *), ptr, 32 * 8);*/
			for(i=0; i<(32*8*2); i++) { /* 2chars/byte */
				ptr[i] = '0';
			}
			ptr += 32*8*2;
			/* pc, msr, cr, lr, ctr, xer, (mq is unused) */
/* 			ptr = mem2hex((char *)&nip, ptr, 4); */
			ptr = mem2hex((char *)&t_regs->nip, ptr, 4);
			ptr = mem2hex((char *)&t_regs->msr, ptr, 4);
			ptr = mem2hex((char *)&t_regs->ccr, ptr, 4);
			ptr = mem2hex((char *)&t_regs->link, ptr, 4);
			ptr = mem2hex((char *)&t_regs->ctr, ptr, 4);
			ptr = mem2hex((char *)&t_regs->xer, ptr, 4);
		}
			break;

		case 'G':   /* set the value of the CPU registers */
		{
			ptr = &remcomInBuffer[1];

			/*
			 * If the stack pointer has moved, you should pray.
			 * (cause only god can help you).
			 */

			/* General Purpose Regs */
			hex2mem(ptr, (char *)regs, 32 * 4);

			/* Floating Point Regs - FIXME?? */
			/*ptr = hex2mem(ptr, ??, 32 * 8);*/
			ptr += 32*8*2;

			/* pc, msr, cr, lr, ctr, xer, (mq is unused) */
			ptr = hex2mem(ptr, (char *)&regs->nip, 4);
			ptr = hex2mem(ptr, (char *)&regs->msr, 4);
			ptr = hex2mem(ptr, (char *)&regs->ccr, 4);
			ptr = hex2mem(ptr, (char *)&regs->link, 4);
			ptr = hex2mem(ptr, (char *)&regs->ctr, 4);
			ptr = hex2mem(ptr, (char *)&regs->xer, 4);

			strcpy(remcomOutBuffer,"OK");
		}
			break;

		case 'm':	/* mAA..AA,LLLL  Read LLLL bytes at address AA..AA */
				/* Try to read %x,%x.  */

			ptr = &remcomInBuffer[1];

			if (hexToInt(&ptr, &addr)
			    && *ptr++ == ','
			    && hexToInt(&ptr, &length))	{
				if (mem2hex((char *)addr, remcomOutBuffer,length))
					break;
				strcpy (remcomOutBuffer, "E03");
			} else {
				strcpy(remcomOutBuffer,"E01");
			}
			break;

		case 'M': /* MAA..AA,LLLL: Write LLLL bytes at address AA.AA return OK */
			/* Try to read '%x,%x:'.  */

			ptr = &remcomInBuffer[1];

			if (hexToInt(&ptr, &addr)
			    && *ptr++ == ','
			    && hexToInt(&ptr, &length)
			    && *ptr++ == ':') {
#ifdef CONFIG_RTL_DEBUG_BP_HACK
				debugpr("addr=%x, length=%x, ptr=%s\n", addr,length, ptr);
				if (length == 4) { /* maybe breakpoint stuff */
					if (!strncmp(ptr, STR_BPCODE, strlen(STR_BPCODE))) {
						spin_lock (&bp_lock);
						insert_bp((char *)addr);
						spin_unlock (&bp_lock);
					} else {
						spin_lock (&bp_lock);
						remove_bp((char *)addr);
						spin_unlock (&bp_lock);
					}
				}
#endif

				if (hex2mem(ptr, (char *)addr, length)) {
					strcpy(remcomOutBuffer, "OK");
				} else {
					strcpy(remcomOutBuffer, "E03");
				}
				flush_icache_range(addr, addr+length);
			} else {
				strcpy(remcomOutBuffer, "E02");
			}
			break;


		case 'k':    /* kill the program, actually just continue */
		case 'c':    /* cAA..AA  Continue; address AA..AA optional */
			/* try to read optional parameter, pc unchanged if no parm */

			ptr = &remcomInBuffer[1];
			if (hexToInt(&ptr, &addr)) {
				regs->nip = addr;
			}

/* Need to flush the instruction cache here, as we may have deposited a
 * breakpoint, and the icache probably has no way of knowing that a data ref to
 * some location may have changed something that is in the instruction cache.
 */
			kgdb_flush_cache_all();
			regs->msr &= ~MSR_SE;
			set_msr(msr);
			kgdb_active = 0;
			goto cleanup;

		case 's':
			kgdb_flush_cache_all();
			regs->msr |= MSR_SE;
#if 0
			set_msr(msr | MSR_SE);
#endif
			kgdb_active = 0;
			goto cleanup;

		case 'r':		/* Reset (if user process..exit ???)*/
			panic("kgdb reset.");
			break;
		}			/* switch */
		if (remcomOutBuffer[0] && kdebug) {
			printk("remcomInBuffer: %s\n", remcomInBuffer);
			printk("remcomOutBuffer: %s\n", remcomOutBuffer);
		}
		/* reply to the request */
		putpacket(remcomOutBuffer);
	} /* while(1) */
cleanup: pthread_cleanup_pop(1);
  rtl_hard_restore_flags(flags) ;
  debugpr("cleanup");
  return(1) ;
}


/* Output string in GDB O-packet format if GDB has connected. If nothing
   output, returns 0 (caller must then handle output). */
/*
int
kgdb_output_string (const char* s, unsigned int count)
{
	char buffer[512];

        if (!kgdb_started)
            return 0;

	count = (count <= (sizeof(buffer) / 2 - 2)) 
		? count : (sizeof(buffer) / 2 - 2);

	buffer[0] = 'O';
	mem2hex (s, &buffer[1], count);
	putpacket(buffer);

        return 1;
 }
 */

#ifndef CONFIG_8xx

/* I don't know why other platforms don't need this.  The function for
 * the 8xx is found in arch/ppc/8xx_io/uart.c.  -- Dan
 */
void
kgdb_map_scc(void)
{
}
#endif
