/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

public abstract class Buffer {
    int capacity;
    int limit;
    int position;
    public int arrayOffset;

    Buffer() {
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int n) {
        if (n < 0 || n > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = n;
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int n) {
        if (n < 0 || n > this.capacity) {
            throw new IllegalArgumentException();
        }
        if (this.position > n) {
            this.position = n;
        }
        this.limit = n;
        return this;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    final int checkIndex(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

