/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiprof.timeline;

import com.mentorgen.tools.profile.Controller;
import java.io.IOException;
import net.sourceforge.jiprof.timeline.Action;
import net.sourceforge.jiprof.timeline.ActionRecord;
import net.sourceforge.jiprof.timeline.TextOutput;
import net.sourceforge.jiprof.timeline.TimeLine;
import net.sourceforge.jiprof.timeline.TimeRecord;

public class TimeLineProfiler
implements Runnable {
    public static TimeLine _timeLine;
    static long _startTime;

    public static void initProfiler() {
        System.err.println("TimeLineProfiler: starting");
        Runtime.getRuntime().addShutdownHook(new Thread(new TimeLineProfiler()));
        _timeLine = new TimeLine();
        _startTime = Controller._timeResoltion == Controller.TimeResolution.ns ? System.nanoTime() : System.currentTimeMillis();
    }

    public static void start(String string, String string2) {
        TimeLineProfiler.createActionRecord(string, string2, Action.START);
    }

    public static void end(String string, String string2) {
        TimeLineProfiler.createActionRecord(string, string2, Action.STOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createActionRecord(String string, String string2, Action action) {
        long l = Thread.currentThread().getId();
        ActionRecord actionRecord = new ActionRecord(string, string2, action, l);
        long l2 = Controller._timeResoltion == Controller.TimeResolution.ns ? System.nanoTime() : System.currentTimeMillis();
        TimeLine timeLine = _timeLine;
        synchronized (timeLine) {
            TimeRecord timeRecord = null;
            if (_timeLine.size() > 0) {
                timeRecord = (TimeRecord)_timeLine.getLast();
            }
            if (timeRecord == null || timeRecord._pointInTime != l2) {
                timeRecord = new TimeRecord(l2);
                _timeLine.add(timeRecord);
            }
            timeRecord._actionRecordList.add(actionRecord);
        }
    }

    public static void alloc(String string) {
        TimeLineProfiler.createActionRecord(string, "", Action.ALLOC);
    }

    public static void beginWait(String string, String string2) {
        TimeLineProfiler.createActionRecord(string, string2, Action.BEGIN_WAIT);
    }

    public static void endWait(String string, String string2) {
        TimeLineProfiler.createActionRecord(string, string2, Action.END_WAIT);
    }

    public static void unwind(String string, String string2, String string3) {
        TimeLineProfiler.createActionRecord(string, string2, Action.EXCEPTION);
    }

    @Override
    public void run() {
        try {
            TextOutput.dump();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

