/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new SimpleScriptContext();

    public AbstractScriptEngine() {
    }

    public AbstractScriptEngine(Bindings bindings) {
        this.context.setBindings(bindings, 100);
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public void setContext(ScriptContext context) {
        this.context = context;
    }

    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    public Object get(String key) {
        return this.context.getBindings(100).get(key);
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        this.context.getBindings(100).put(key, value);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    public Object eval(String script, Bindings bindings) throws ScriptException {
        return this.eval(script, this.getScriptContext(bindings));
    }

    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader, this.getScriptContext(bindings));
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        SimpleScriptContext result = new SimpleScriptContext();
        if (bindings != null) {
            result.setBindings(bindings, 100);
        }
        if (this.context.getBindings(200) != null) {
            result.setBindings(this.context.getBindings(200), 200);
        }
        result.setReader(this.context.getReader());
        result.setWriter(this.context.getWriter());
        result.setErrorWriter(this.context.getErrorWriter());
        return result;
    }
}

