/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicInstanceMethod;
import org.dynalang.mop.beans.DynamicMethod;
import org.dynalang.mop.beans.OverloadedDynamicMethod;
import org.dynalang.mop.beans.SimpleDynamicMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassMetaobjectProtocol {
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
    private final Map<String, DynamicMethod> methods = new HashMap<String, DynamicMethod>();
    private final Collection<String> names;

    ClassMetaobjectProtocol(Class clazz, boolean methodsEnumerable) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        Map<MethodSignature, Method> accessibleMethods = ClassMetaobjectProtocol.discoverAccessibleMethods(clazz);
        PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propDescs.length; ++i) {
            Method writeMethod;
            PropertyDescriptor descriptor = propDescs[i];
            Method readMethod = descriptor.getReadMethod();
            if (readMethod != null) {
                descriptor.setReadMethod(ClassMetaobjectProtocol.getAccessibleMethod(readMethod, accessibleMethods));
            }
            if ((writeMethod = descriptor.getWriteMethod()) != null) {
                descriptor.setWriteMethod(ClassMetaobjectProtocol.getAccessibleMethod(writeMethod, accessibleMethods));
            }
            if (descriptor.getReadMethod() == null && descriptor.getWriteMethod() == null) continue;
            this.properties.put(descriptor.getName(), descriptor);
        }
        MethodDescriptor[] methodDescs = beanInfo.getMethodDescriptors();
        for (int i = 0; i < methodDescs.length; ++i) {
            MethodDescriptor descriptor = methodDescs[i];
            Method method = ClassMetaobjectProtocol.getAccessibleMethod(descriptor.getMethod(), accessibleMethods);
            if (method == null) continue;
            String name = descriptor.getName();
            DynamicMethod dynaMethod = this.methods.get(name);
            if (dynaMethod == null) {
                this.methods.put(name, new SimpleDynamicMethod(method));
                continue;
            }
            if (dynaMethod instanceof SimpleDynamicMethod) {
                OverloadedDynamicMethod<Method> odm = new OverloadedDynamicMethod<Method>(name);
                odm.addMember(((SimpleDynamicMethod)dynaMethod).getMethod());
                odm.addMember(method);
                this.methods.put(name, odm);
                continue;
            }
            if (!(dynaMethod instanceof OverloadedDynamicMethod)) continue;
            ((OverloadedDynamicMethod)dynaMethod).addMember(method);
        }
        if (methodsEnumerable) {
            HashSet<String> cnames = new HashSet<String>(this.properties.size() + this.methods.size() * 4 / 3, 0.75f);
            cnames.addAll(this.properties.keySet());
            cnames.addAll(this.methods.keySet());
            ArrayList lnames = new ArrayList(cnames);
            Collections.sort(lnames);
            lnames.trimToSize();
            this.names = Collections.unmodifiableCollection(lnames);
        } else {
            this.names = Collections.emptySet();
        }
    }

    Object call(Object target, Object callableId, CallProtocol callProtocol, Object[] args) {
        String name = String.valueOf(callableId);
        DynamicMethod dynaMethod = this.methods.get(name);
        if (dynaMethod == null) {
            return BaseMetaobjectProtocol.Results.noAuthority;
        }
        return dynaMethod.call(target, args, callProtocol);
    }

    Object get(Object target, long propertyId) {
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    Object get(Object target, Object propertyId) {
        String name = String.valueOf(propertyId);
        PropertyDescriptor desc = this.properties.get(name);
        if (desc == null) {
            DynamicMethod dynaMethod = this.methods.get(name);
            if (dynaMethod == null) {
                return BaseMetaobjectProtocol.Results.noAuthority;
            }
            return new DynamicInstanceMethod(target, dynaMethod);
        }
        Method method = desc.getReadMethod();
        if (method == null) {
            return BaseMetaobjectProtocol.Results.notReadable;
        }
        try {
            return method.invoke(target, (Object[])null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    Boolean has(Object target, long propertyId) {
        return null;
    }

    Boolean has(Object target, Object propertyId) {
        String name = String.valueOf(propertyId);
        if (this.properties.containsKey(name) || this.methods.containsKey(name)) {
            return Boolean.TRUE;
        }
        return null;
    }

    Iterator<? extends Object> getPropertyIds(Object target) {
        return this.names.iterator();
    }

    BaseMetaobjectProtocol.Results put(Object target, long propertyId, Object value, CallProtocol callProtocol) {
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    BaseMetaobjectProtocol.Results put(Object target, Object propertyId, Object value, CallProtocol callProtocol) {
        PropertyDescriptor desc = this.properties.get(String.valueOf(propertyId));
        if (desc == null) {
            return BaseMetaobjectProtocol.Results.noAuthority;
        }
        Method writeMethod = desc.getWriteMethod();
        if (writeMethod == null) {
            return BaseMetaobjectProtocol.Results.notWritable;
        }
        try {
            Class<?> propType = desc.getPropertyType();
            if (propType == null) {
                return BaseMetaobjectProtocol.Results.notWritable;
            }
            if ((value = callProtocol.representAs(value, propType)) == BaseMetaobjectProtocol.Results.noAuthority || value == BaseMetaobjectProtocol.Results.noRepresentation) {
                return BaseMetaobjectProtocol.Results.noRepresentation;
            }
            writeMethod.invoke(target, value);
            return BaseMetaobjectProtocol.Results.ok;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static Map<MethodSignature, Method> discoverAccessibleMethods(Class clazz) {
        HashMap<MethodSignature, Method> map = new HashMap<MethodSignature, Method>();
        ClassMetaobjectProtocol.discoverAccessibleMethods(clazz, map);
        return map;
    }

    private static void discoverAccessibleMethods(Class clazz, Map<MethodSignature, Method> map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    MethodSignature sig = new MethodSignature(method);
                    map.put(sig, method);
                }
                return;
            }
            catch (SecurityException e) {
                System.err.println("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.");
                e.printStackTrace();
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassMetaobjectProtocol.discoverAccessibleMethods(interfaces[i], map);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            ClassMetaobjectProtocol.discoverAccessibleMethods(superclass, map);
        }
    }

    private static Method getAccessibleMethod(Method m, Map<MethodSignature, Method> accessibles) {
        return m == null ? null : accessibles.get(new MethodSignature(m));
    }

    private static final class MethodSignature {
        private final String name;
        private final Class[] args;

        private MethodSignature(String name, Class[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ Arrays.hashCode(this.args);
        }
    }
}

