#! /bin/sh
# check script for Zutils - Utilities dealing with compressed files
# Copyright (C) 2009-2016 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
ZCAT="${objdir}"/zcat
ZCMP="${objdir}"/zcmp
ZDIFF="${objdir}"/zdiff
ZGREP="${objdir}"/zgrep
ZEGREP="${objdir}"/zegrep
ZFGREP="${objdir}"/zfgrep
ZTEST="${objdir}"/ztest
ZUPDATE="${objdir}"/zupdate
compressors="bzip2 gzip lzip"
extensions="bz2 gz lz"
compressor_needed() { echo "${compressors} are needed to run tests" ; exit 1 ; }
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${ZUPDATE}" ] || [ ! -x "${ZUPDATE}" ] ; then
	echo "${ZUPDATE}: cannot execute"
	exit 1
fi

if [ -e "${ZUPDATE}" ] 2> /dev/null ; then true
else
	echo "$0: a POSIX shell is required to run the tests"
	echo "Try bash -c \"$0 $1 $2\""
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp || framework_failure

for i in ${compressors}; do
	cat "${testdir}"/test.txt > in || framework_failure
	$i in || compressor_needed
done

cat "${testdir}"/test.txt > in || framework_failure
cat "${testdir}"/test.txt.tar > in.tar || framework_failure
printf "01234567890" > pin.tar || framework_failure
cat in.tar in.tar in.tar in.tar >> pin.tar || framework_failure
cat in > -in- || framework_failure
cat in.lz > -in-.lz || framework_failure
cat in.lz > lz_only.lz || framework_failure
cat in in in in in in > in6 || framework_failure
fail=0

printf "testing    zcat-%s..." "$2"

for i in ${extensions}; do
	"${ZCAT}" -N in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
	"${ZCAT}" -N --format=un in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
	"${ZCAT}" -N --force-format=$i in.$i > copy || fail=1
	cmp in copy || fail=1
	printf .
	"${ZCAT}" -N in.$i | dd bs=1000 count=1 > copy 2> /dev/null || fail=1
	dd if=in bs=1000 count=1 2> /dev/null | cmp - copy || fail=1
	printf .
done

"${ZCAT}" -N < in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N < in.gz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N < in.bz2 > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N < in.lz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N -O lz - - < in.lz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N --lz='lzip -q' < in.lz > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N in > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N lz_only > copy || fail=1
cmp in copy || fail=1
printf .
"${ZCAT}" -N in in.gz in.bz2 in.lz -- -in- -in-.lz > copy || fail=1
cmp in6 copy || fail=1
printf .
"${ZCAT}" -Nq --format=, in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --format=,lz in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --format=gz,,lz in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --format=lz,, in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --format=nc in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --lz='-lzip -q' in.lz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -N --force-format=gz in.bz2 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -N --force-format=bz2 in.lz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -Nq --force-format=lz in.gz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCAT}" -N --bad-option 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting    zcmp-%s..." "$2"

for i in ${extensions}; do
	"${ZCMP}" -N in.$i || fail=1
	printf .
	"${ZCMP}" -N in in.$i || fail=1
	printf .
	"${ZCMP}" -N -i 100 -n 500 in6 in.$i || fail=1
	printf .
	"${ZCMP}" -N in in.$i --force-format=,$i || fail=1
	printf .
	"${ZCMP}" -N in.$i in || fail=1
	printf .
	"${ZCMP}" -N -i 1000:1000 -n 50 in.$i in6 || fail=1
	printf .
	"${ZCMP}" -N in.$i in --force-format=$i || fail=1
	printf .
done

"${ZCMP}" -Nq in in6
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -N -n 0 in in6 || fail=1
"${ZCMP}" -N -n 100 in in6 || fail=1
"${ZCMP}" -N -n 1000 in in6 || fail=1
"${ZCMP}" -N -n 10000 in in6 || fail=1
printf .
"${ZCMP}" -Nq in.tar pin.tar
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -Nq -i 0,11 in.tar pin.tar
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -N -i 0,11 -n 0 in.tar pin.tar || fail=1
"${ZCMP}" -N -i 0,11 -n 100 in.tar pin.tar || fail=1
"${ZCMP}" -N -i 0,11 -n 1000 in.tar pin.tar || fail=1
"${ZCMP}" -N -i 0,11 -n 10000 in.tar pin.tar || fail=1
printf .
"${ZCMP}" -N - || fail=1
printf .
"${ZCMP}" -N in in || fail=1
printf .
"${ZCMP}" -N in || fail=1
printf .
"${ZCMP}" -N in.lz in.gz || fail=1
printf .
"${ZCMP}" -N --lz='lzip -q' in.lz in.gz || fail=1
printf .
"${ZCMP}" -N in.gz -- -in-.lz || fail=1
printf .
"${ZCMP}" -N -- -in-.lz in.gz || fail=1
printf .
"${ZCMP}" -N in -- -in-.lz || fail=1
printf .
"${ZCMP}" -N -- -in- in.lz || fail=1
printf .
"${ZCMP}" -N in.lz -- -in- || fail=1
printf .
"${ZCMP}" -N -- -in-.lz in || fail=1
printf .
"${ZCMP}" -N -- -in- in || fail=1
printf .
"${ZCMP}" -N in -- -in- || fail=1
printf .
"${ZCMP}" -N lz_only.lz < in || fail=1
printf .
"${ZCMP}" -N in.lz - < in || fail=1
printf .
"${ZCMP}" -N - in.lz < in || fail=1
printf .
"${ZCMP}" -N in - < in.lz || fail=1
printf .
"${ZCMP}" -N - in < in.lz || fail=1
printf .
"${ZCMP}" -N -q --force-format=lz in.lz
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -Nq --force-format=lz in.gz in.lz
r=$?
if [ $r = 1 ] || [ $r = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -Nq -n -1 in in
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZCMP}" -N --bad-option in in 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting   zdiff-%s..." "$2"

for i in ${extensions}; do
	"${ZDIFF}" -N in.$i > /dev/null || fail=1
	printf .
	"${ZDIFF}" -N in in.$i > /dev/null || fail=1
	printf .
	"${ZDIFF}" -N --force-format=,$i in in.$i > /dev/null || fail=1
	printf .
	"${ZDIFF}" -N in.$i in > /dev/null || fail=1
	printf .
	"${ZDIFF}" -N --force-format=$i, in.$i in > /dev/null || fail=1
	printf .
done

"${ZDIFF}" -N in in6 > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N in.tar pin.tar > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N - || fail=1
printf .
"${ZDIFF}" -N in in || fail=1
printf .
"${ZDIFF}" -N in || fail=1
printf .
"${ZDIFF}" -N --format=gz,bz2 in || fail=1
printf .
"${ZDIFF}" -N --format=gz in || fail=1
printf .
"${ZDIFF}" -N in.lz in.gz > /dev/null || fail=1
printf .
"${ZDIFF}" -N --lz='lzip -q' in.lz in.gz > /dev/null || fail=1
printf .
"${ZDIFF}" -N in.gz -- -in-.lz > /dev/null || fail=1
printf .
"${ZDIFF}" -N -- -in-.lz in.gz > /dev/null || fail=1
printf .
"${ZDIFF}" -N in -- -in-.lz > /dev/null || fail=1
printf .
"${ZDIFF}" -N -- -in- in.lz > /dev/null || fail=1
printf .
"${ZDIFF}" -N in.lz -- -in- > /dev/null || fail=1
printf .
"${ZDIFF}" -N -- -in-.lz in > /dev/null || fail=1
printf .
"${ZDIFF}" -N -- -in- in > /dev/null || fail=1
printf .
"${ZDIFF}" -N in -- -in- > /dev/null || fail=1
printf .
"${ZDIFF}" -N lz_only.lz < in > /dev/null || fail=1
printf .
"${ZDIFF}" -N in.lz - < in > /dev/null || fail=1
printf .
"${ZDIFF}" -N - in.lz < in > /dev/null || fail=1
printf .
"${ZDIFF}" -N in - < in.lz > /dev/null || fail=1
printf .
"${ZDIFF}" -N - in < in.lz > /dev/null || fail=1
printf .
"${ZDIFF}" -N --bz2='-bzip2' in.bz2 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N -q --force-format=bz2 in.bz2 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N -q --force-format=,lz in.lz in.bz2 > /dev/null 2>&1
r=$?
if [ $r = 1 ] || [ $r = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N --bad-option 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi

mkdir tmp2
cat in > tmp2/a || framework_failure
cat in.lz > tmp2/a.lz || framework_failure
"${ZDIFF}" -N --format=bz2 tmp2/a < /dev/null > /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N --format=gz tmp2/a < /dev/null > /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N --format=lz tmp2/a.lz < /dev/null > /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N --format=lz tmp2/a < /dev/null
if [ $? = 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZDIFF}" -N --format=un tmp2/a.lz < /dev/null
if [ $? = 0 ] ; then printf . ; else printf - ; fail=1 ; fi
rm -r tmp2 || framework_failure


printf "\ntesting   zgrep-%s..." "$2"

for i in ${extensions}; do
	"${ZGREP}" -N "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -N "GNU" < in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -N -l "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -N -L "GNU" in.$i || fail=1
	printf .
	"${ZGREP}" -N --force-format=$i "GNU" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -N -v "nx_pattern" in.$i > /dev/null || fail=1
	printf .
	"${ZGREP}" -N "nx_pattern" in.$i
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" -N -l "nx_pattern" in.$i
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" -N -L "nx_pattern" in.$i > /dev/null
	if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZGREP}" -N --force-format=$i "GNU" in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
done

"${ZGREP}" -N pin.tar -e "GNU" > /dev/null || fail=1
printf .
"${ZGREP}" -N "GNU" < pin.tar > /dev/null || fail=1
printf .
"${ZGREP}" -N -r "GNU" . > /dev/null || fail=1
printf .
"${ZGREP}" -N "nx_pattern" -r . in > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N -e "GNU" in > /dev/null || fail=1
printf .
"${ZGREP}" -N "GNU" < in > /dev/null || fail=1
printf .
"${ZGREP}" -N -O lz "nx_pattern" - - < in.lz > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N -e "-free" --lz='lzip -q' < in.lz > /dev/null || fail=1
printf .
"${ZGREP}" -N -- "-free" -in- > /dev/null || fail=1
printf .
"${ZGREP}" -N -q -- "-free" nx_file -in-.lz
if [ $? = 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N "GNU" in in.gz in.bz2 in.lz -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" -N -l "GNU" in in.gz in.bz2 in.lz -- -in- > /dev/null || fail=1
printf .
"${ZGREP}" -N -L "GNU" in in.gz in.bz2 in.lz -- -in- || fail=1
printf .
"${ZGREP}" -N -l "nx_pattern" in in.gz in.bz2 in.lz -- -in-
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N -L "nx_pattern" in in.gz in.bz2 in.lz -- -in- > /dev/null
if [ $? != 0 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N --bad-option 2> /dev/null
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N "GNU" -s nx_file
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZGREP}" -N -q
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi

"${ZEGREP}" -N "GNU" in > /dev/null || fail=1
printf .
"${ZFGREP}" -N "GNU" in > /dev/null || fail=1
printf .


printf "\ntesting   ztest-%s..." "$2"

for i in ${extensions}; do
	"${ZTEST}" -N --force-format=$i < in.$i || fail=1
	printf .
	"${ZTEST}" -N --force-format=$i < in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
	"${ZTEST}" -N --force-format=$i in 2> /dev/null
	if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
done

"${ZTEST}" -N in in.gz in.bz2 in.lz -- -in- || fail=1
printf .
"${ZTEST}" -N < in.gz || fail=1
printf .
"${ZTEST}" -N < in.bz2 || fail=1
printf .
"${ZTEST}" -N < in.lz || fail=1
printf .
"${ZTEST}" -N - in.gz - < in.lz || fail=1
printf .
"${ZTEST}" -N --lz='lzip -q' < in.lz || fail=1
printf .
"${ZTEST}" -N -r . || fail=1
printf .
"${ZTEST}" -Nq < in
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
dd if=in.lz bs=1000 count=1 2> /dev/null | "${ZTEST}" -N -q
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZTEST}" -Nq --force-format=lz in.bz2
if [ $? = 2 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZTEST}" -N --lz='lzip --bad-option' in.lz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZTEST}" -N --bad-option 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi


printf "\ntesting zupdate-%s..." "$2"

cat in.bz2 > a.bz2 || framework_failure
cat in.gz > a.gz || framework_failure
"${ZUPDATE}" -Nq --bz2=bad_command a.bz2
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -N --bz2='bzip2 --bad-option' a.bz2 > /dev/null 2>&1
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -Nq --gz=bad_command a.gz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -N --gz='gzip --bad-option' a.gz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -Nq --lz=bad_command a.gz
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -N --lz='lzip --bad-option' a.gz 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi
"${ZUPDATE}" -N --bad-option 2> /dev/null
if [ $? = 1 ] ; then printf . ; else printf - ; fail=1 ; fi

cat in.lz in.lz > a.lz || framework_failure
"${ZUPDATE}" -Nq -f a.bz2 a.gz
if [ $? = 1 ] && [ -e a.bz2 ] && [ -e a.gz ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

"${ZUPDATE}" -N a.bz2
if [ $? = 0 ] && [ ! -e a.bz2 ] && [ -e a.gz ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure
"${ZUPDATE}" -N a.gz
if [ $? = 0 ] && [ ! -e a.bz2 ] && [ ! -e a.gz ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

cat in.bz2 > a.bz2 || framework_failure
cat in.gz > a.gz || framework_failure
"${ZUPDATE}" -Nq a.bz2 a.gz
if [ $? = 1 ] && [ ! -e a.bz2 ] && [ -e a.gz ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

cat in.bz2 > a.bz2 || framework_failure
cat in.gz > a.gz || framework_failure
"${ZUPDATE}" -N -f -k a.bz2 a.gz
if [ $? = 0 ] && [ -e a.bz2 ] && [ -e a.gz ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

cat in.bz2 > a.bz2 || framework_failure
cat in.gz > a.gz || framework_failure
"${ZUPDATE}" -N -f a.bz2 a.gz
if [ $? = 0 ] && [ ! -e a.bz2 ] && [ ! -e a.gz ] &&
   [ ! -e a ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

cat in.bz2 > a.bz2 || framework_failure
"${ZUPDATE}" -N -1 -q a.bz2
if [ $? = 0 ] && [ ! -e a.bz2 ] && [ -e a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f a.lz || framework_failure

mkdir tmp2
mkdir tmp2/tmp3
cat in.bz2 > tmp2/tmp3/a.bz2 || framework_failure
cat in.gz > tmp2/tmp3/a.gz || framework_failure
"${ZUPDATE}" -N -r --format=gz tmp2
if [ $? = 0 ] && [ -e tmp2/tmp3/a.bz2 ] && [ ! -e tmp2/tmp3/a.gz ] &&
   [ -e tmp2/tmp3/a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -f tmp2/tmp3/a.lz || framework_failure
"${ZUPDATE}" -N -r --format=bz2 tmp2
if [ $? = 0 ] && [ ! -e tmp2/tmp3/a.bz2 ] && [ ! -e tmp2/tmp3/a.gz ] &&
   [ -e tmp2/tmp3/a.lz ] ; then printf .
else printf - ; fail=1
fi
rm -r tmp2 || framework_failure

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
