/* cttables.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Routines for Content-Type lookup from tables
 */

//To stop multiple inclusions.
#ifndef SRC_CTTABLES_H
#define SRC_CTTABLES_H

#include "strtables.h"

// public
typedef struct {
	t_st_strtable *cttype;    	// private
	t_st_strtable *ctcontenttype;	// private
	int subtype_add_x_prefix;	// private
} t_ct_cttable;

extern t_ct_cttable *ct_create (int subtype_add_x_prefix);
extern void ct_destroy (t_ct_cttable *ct_cttable);
extern void ct_insert (t_ct_cttable *ct_cttable, const char *ctcontenttype);
extern int ct_check_if_matches (const t_ct_cttable *ct_cttable, const char *ctcontenttype);

#endif

