/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectTimeoutException;
import Ice.ConnectionRefusedException;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SocketConnection;

final class Connector {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private String _url;

    public Transceiver connect(int n) {
        Object object;
        String string;
        if (this._traceLevels.network >= 2) {
            string = "trying to establish tcp connection to " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, string);
        }
        string = null;
        try {
            if (n >= 0) {
                object = new ConnectThread(this._url);
                ((Thread)object).start();
                string = (SocketConnection)((ConnectThread)object).getConnection(n == 0 ? 1 : n);
                if (string == null) {
                    throw new ConnectTimeoutException();
                }
            } else {
                string = (SocketConnection)javax.microedition.io.Connector.open((String)this._url, (int)3, (boolean)true);
            }
            string.setSocketOption((byte)0, 0);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            if (string != null) {
                try {
                    string.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ConnectFailedException connectFailedException = Network.connectionRefused((IOException)((Object)connectionNotFoundException)) ? new ConnectionRefusedException() : new ConnectFailedException();
            connectFailedException.initCause(connectionNotFoundException);
            throw connectFailedException;
        }
        catch (IOException iOException) {
            if (string != null) {
                try {
                    string.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        catch (RuntimeException runtimeException) {
            if (string != null) {
                try {
                    string.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw runtimeException;
        }
        if (this._traceLevels.network >= 1) {
            object = "tcp connection established\n" + Network.toString((SocketConnection)string);
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        return new Transceiver(this._instance, (Connection)string);
    }

    public String toString() {
        return this._url;
    }

    Connector(Instance instance, String string, int n) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._url = "socket://" + string + ':' + n;
    }

    private static class ConnectThread
    extends Thread {
        private String _url;
        private IOException _ex;
        private Connection _connection;

        ConnectThread(String string) {
            this._url = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Connection connection = javax.microedition.io.Connector.open((String)this._url, (int)3, (boolean)true);
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._connection = connection;
                    this.notifyAll();
                }
            }
            catch (IOException iOException) {
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._ex = iOException;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection getConnection(int n) throws IOException {
            Connection connection = null;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this._connection == null && this._ex == null) {
                    try {
                        this.wait(n);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
                connection = this._connection;
                this._connection = null;
            }
            return connection;
        }
    }
}

