/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Communicator;
import Ice.Logger;
import Ice.PluginInitializationException;
import Ice.Properties;
import Ice.SecurityException;
import Ice.StringHolder;
import Ice.Util;
import IceInternal.Network;
import IceInternal.ProtocolPluginFacade;
import IceSSL.CertificateVerifier;
import IceSSL.ConnectionInfo;
import IceSSL.EndpointFactoryI;
import IceSSL.TrustManager;
import IceSSL.X509KeyManagerI;
import IceSSL.X509TrustManagerI;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class Instance {
    private Logger _logger;
    private ProtocolPluginFacade _facade;
    private int _securityTraceLevel;
    private String _securityTraceCategory;
    private boolean _initialized;
    private SSLContext _context;
    private String _defaultDir;
    private CipherExpression[] _ciphers;
    private boolean _allCiphers;
    private boolean _noCiphers;
    private String[] _protocols;
    private boolean _checkCertName;
    private int _verifyDepthMax;
    private CertificateVerifier _verifier;
    private TrustManager _trustManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    Instance(Communicator communicator) {
        this._logger = communicator.getLogger();
        this._facade = Util.getProtocolPluginFacade(communicator);
        this._securityTraceLevel = communicator.getProperties().getPropertyAsIntWithDefault("IceSSL.Trace.Security", 0);
        this._securityTraceCategory = "Security";
        this._initialized = false;
        this._trustManager = new TrustManager(communicator);
        this._facade.addEndpointFactory(new EndpointFactoryI(this));
    }

    void initialize() {
        String protocols;
        if (this._initialized) {
            return;
        }
        String prefix = "IceSSL.";
        Properties properties = this.communicator().getProperties();
        String ciphers = properties.getProperty("IceSSL.Ciphers");
        if (ciphers.length() > 0) {
            this.parseCiphers(ciphers);
        }
        if ((protocols = properties.getProperty("IceSSL.Protocols")).length() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            String[] arr = protocols.split("[ \t,]+");
            for (int i = 0; i < arr.length; ++i) {
                String s = arr[i].toLowerCase();
                if (s.equals("ssl3") || s.equals("sslv3")) {
                    l.add("SSLv3");
                    continue;
                }
                if (s.equals("tls") || s.equals("tls1") || s.equals("tlsv1")) {
                    l.add("TLSv1");
                    continue;
                }
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unrecognized protocol `" + arr[i] + "'";
                throw e;
            }
            this._protocols = new String[l.size()];
            l.toArray(this._protocols);
        }
        this._checkCertName = properties.getPropertyAsIntWithDefault("IceSSL.CheckCertName", 0) > 0;
        this._verifyDepthMax = properties.getPropertyAsIntWithDefault("IceSSL.VerifyDepthMax", 2);
        if (this._context == null) {
            try {
                this._defaultDir = properties.getProperty("IceSSL.DefaultDir");
                SecureRandom rand = new SecureRandom();
                String seedFiles = properties.getProperty("IceSSL.Random");
                if (seedFiles.length() > 0) {
                    byte[] seed = null;
                    int start = 0;
                    String[] arr = seedFiles.split(File.pathSeparator);
                    for (int i = 0; i < arr.length; ++i) {
                        StringHolder seedFile = new StringHolder(arr[i]);
                        if (!this.checkPath(seedFile, false)) {
                            PluginInitializationException e = new PluginInitializationException();
                            e.reason = "IceSSL: random seed file not found:\n" + arr[i];
                            throw e;
                        }
                        File f = new File(seedFile.value);
                        int num = (int)f.length();
                        if (seed == null) {
                            seed = new byte[num];
                        } else {
                            byte[] tmp = new byte[seed.length + num];
                            System.arraycopy(seed, 0, tmp, 0, seed.length);
                            start = seed.length;
                            seed = tmp;
                        }
                        try {
                            FileInputStream in = new FileInputStream(f);
                            in.read(seed, start, num);
                            in.close();
                            continue;
                        }
                        catch (IOException ex) {
                            PluginInitializationException e = new PluginInitializationException();
                            e.reason = "IceSSL: error while reading random seed file:\n" + arr[i];
                            e.initCause(ex);
                            throw e;
                        }
                    }
                    rand.setSeed(seed);
                }
                rand.nextInt();
                StringHolder keystorePath = new StringHolder(properties.getProperty("IceSSL.Keystore"));
                String password = properties.getProperty("IceSSL.Password");
                String keystorePassword = properties.getProperty("IceSSL.KeystorePassword");
                String defaultType = KeyStore.getDefaultType();
                String keystoreType = properties.getPropertyWithDefault("IceSSL.KeystoreType", defaultType);
                String alias = properties.getProperty("IceSSL.Alias");
                StringHolder truststorePath = new StringHolder(properties.getProperty("IceSSL.Truststore"));
                String truststorePassword = properties.getProperty("IceSSL.TruststorePassword");
                String truststoreType = properties.getPropertyWithDefault("IceSSL.TruststoreType", KeyStore.getDefaultType());
                KeyManager[] keyManagers = null;
                if (keystorePath.value.length() > 0) {
                    if (!this.checkPath(keystorePath, false)) {
                        PluginInitializationException e = new PluginInitializationException();
                        e.reason = "IceSSL: keystore file not found:\n" + keystorePath.value;
                        throw e;
                    }
                    KeyStore keys = KeyStore.getInstance(keystoreType);
                    try {
                        char[] passwordChars = null;
                        if (keystorePassword.length() > 0) {
                            passwordChars = keystorePassword.toCharArray();
                        }
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(keystorePath.value));
                        keys.load(bis, passwordChars);
                    }
                    catch (IOException ex) {
                        PluginInitializationException e = new PluginInitializationException();
                        e.reason = "IceSSL: unable to load keystore:\n" + keystorePath.value;
                        e.initCause(ex);
                        throw e;
                    }
                    String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                    kmf.init(keys, password.toCharArray());
                    keyManagers = kmf.getKeyManagers();
                    if (alias.length() > 0) {
                        if (!keys.isKeyEntry(alias)) {
                            PluginInitializationException e = new PluginInitializationException();
                            e.reason = "IceSSL: keystore does not contain an entry with alias `" + alias + "'";
                            throw e;
                        }
                        for (int i = 0; i < keyManagers.length; ++i) {
                            keyManagers[i] = new X509KeyManagerI((X509KeyManager)keyManagers[i], alias);
                        }
                    }
                }
                javax.net.ssl.TrustManager[] trustManagers = null;
                if (truststorePath.value.length() > 0) {
                    if (!this.checkPath(truststorePath, false)) {
                        PluginInitializationException e = new PluginInitializationException();
                        e.reason = "IceSSL: truststore file not found:\n" + truststorePath.value;
                        throw e;
                    }
                    KeyStore ts = KeyStore.getInstance(truststoreType);
                    try {
                        char[] passwordChars = null;
                        if (truststorePassword.length() > 0) {
                            passwordChars = truststorePassword.toCharArray();
                        }
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(truststorePath.value));
                        ts.load(bis, passwordChars);
                    }
                    catch (IOException ex) {
                        PluginInitializationException e = new PluginInitializationException();
                        e.reason = "IceSSL: unable to load truststore:\n" + truststorePath.value;
                        e.initCause(ex);
                        throw e;
                    }
                    String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                    tmf.init(ts);
                    trustManagers = tmf.getTrustManagers();
                }
                if (trustManagers == null) {
                    trustManagers = new javax.net.ssl.TrustManager[]{new X509TrustManagerI(null)};
                } else {
                    for (int i = 0; i < trustManagers.length; ++i) {
                        trustManagers[i] = new X509TrustManagerI((X509TrustManager)trustManagers[i]);
                    }
                }
                this._context = SSLContext.getInstance("SSL");
                this._context.init(keyManagers, trustManagers, rand);
            }
            catch (GeneralSecurityException ex) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unable to initialize context";
                e.initCause(ex);
                throw e;
            }
        }
        this._initialized = true;
    }

    void context(SSLContext context) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is already initialized";
            throw ex;
        }
        this._context = context;
    }

    SSLContext context() {
        return this._context;
    }

    void setCertificateVerifier(CertificateVerifier verifier) {
        this._verifier = verifier;
    }

    Communicator communicator() {
        return this._facade.getCommunicator();
    }

    String defaultHost() {
        return this._facade.getDefaultHost();
    }

    int networkTraceLevel() {
        return this._facade.getNetworkTraceLevel();
    }

    String networkTraceCategory() {
        return this._facade.getNetworkTraceCategory();
    }

    int securityTraceLevel() {
        return this._securityTraceLevel;
    }

    String securityTraceCategory() {
        return this._securityTraceCategory;
    }

    boolean initialized() {
        return this._initialized;
    }

    String[] filterCiphers(String[] supportedCiphers, String[] defaultCiphers) {
        int i;
        LinkedList<String> result = new LinkedList<String>();
        if (this._allCiphers) {
            for (i = 0; i < supportedCiphers.length; ++i) {
                result.add(supportedCiphers[i]);
            }
        } else if (!this._noCiphers) {
            for (i = 0; i < defaultCiphers.length; ++i) {
                result.add(defaultCiphers[i]);
            }
        }
        if (this._ciphers != null) {
            for (i = 0; i < this._ciphers.length; ++i) {
                CipherExpression ce = this._ciphers[i];
                if (ce.not) {
                    Iterator e = result.iterator();
                    while (e.hasNext()) {
                        String cipher = (String)e.next();
                        if (ce.cipher != null) {
                            if (!ce.cipher.equals(cipher)) continue;
                            e.remove();
                            continue;
                        }
                        if (!$assertionsDisabled && ce.re == null) {
                            throw new AssertionError();
                        }
                        Matcher m = ce.re.matcher(cipher);
                        if (!m.find()) continue;
                        e.remove();
                    }
                    continue;
                }
                if (ce.cipher != null) {
                    result.add(0, ce.cipher);
                    continue;
                }
                if (!$assertionsDisabled && ce.re == null) {
                    throw new AssertionError();
                }
                for (int j = 0; j < supportedCiphers.length; ++j) {
                    Matcher m = ce.re.matcher(supportedCiphers[j]);
                    if (!m.find()) continue;
                    result.add(0, supportedCiphers[j]);
                }
            }
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    String[] protocols() {
        return this._protocols;
    }

    void traceConnection(SSLSocket fd, boolean incoming) {
        SSLSession session = fd.getSession();
        String msg = "SSL summary for " + (incoming ? "incoming" : "outgoing") + " connection\n" + "cipher = " + session.getCipherSuite() + "\n" + "protocol = " + session.getProtocol() + "\n" + Network.fdToString(fd);
        this._logger.trace(this._securityTraceCategory, msg);
    }

    void verifyPeer(ConnectionInfo info, SSLSocket fd, String address, boolean incoming) {
        SecurityException ex;
        String msg;
        block25: {
            if (this._verifyDepthMax > 0 && info.certs != null && info.certs.length > this._verifyDepthMax) {
                String msg2 = (incoming ? "incoming" : "outgoing") + " connection rejected:\n" + "length of peer's certificate chain (" + info.certs.length + ") exceeds maximum of " + this._verifyDepthMax + "\n" + Network.fdToString(fd);
                if (this._securityTraceLevel >= 1) {
                    this._logger.trace(this._securityTraceCategory, msg2);
                }
                SecurityException ex2 = new SecurityException();
                ex2.reason = msg2;
                throw ex2;
            }
            if (info.certs != null) {
                try {
                    Collection<List<?>> subjectAltNames = ((X509Certificate)info.certs[0]).getSubjectAlternativeNames();
                    ArrayList<String> ipAddresses = new ArrayList<String>();
                    ArrayList<String> dnsNames = new ArrayList<String>();
                    if (subjectAltNames != null) {
                        Iterator<List<?>> i = subjectAltNames.iterator();
                        while (i.hasNext()) {
                            List<?> l = i.next();
                            if (!$assertionsDisabled && l.isEmpty()) {
                                throw new AssertionError();
                            }
                            Integer n = (Integer)l.get(0);
                            if (n == 7) {
                                ipAddresses.add((String)l.get(1));
                                continue;
                            }
                            if (n != 2) continue;
                            dnsNames.add(((String)l.get(1)).toLowerCase());
                        }
                    }
                    if (address.length() > 0) {
                        boolean certNameOK = ipAddresses.contains(address);
                        if (!certNameOK) {
                            certNameOK = dnsNames.contains(address.toLowerCase());
                        }
                        if (!certNameOK && (this._checkCertName || this._securityTraceLevel >= 1 && this._verifier == null)) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("IceSSL: ");
                            if (!this._checkCertName) {
                                sb.append("ignoring ");
                            }
                            sb.append("certificate validation failure:\npeer certificate does not contain `" + address + "' in its subjectAltName extension");
                            if (!dnsNames.isEmpty()) {
                                sb.append("\nDNS names found in certificate: ");
                                for (int j = 0; j < dnsNames.size(); ++j) {
                                    if (j > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(dnsNames.get(j).toString());
                                }
                            }
                            if (!ipAddresses.isEmpty()) {
                                sb.append("\nIP addresses found in certificate: ");
                                for (int j = 0; j < ipAddresses.size(); ++j) {
                                    if (j > 0) {
                                        sb.append(", ");
                                    }
                                    sb.append(ipAddresses.get(j).toString());
                                }
                            }
                            if (this._securityTraceLevel >= 1) {
                                this._logger.trace(this._securityTraceCategory, sb.toString());
                            }
                            if (this._checkCertName) {
                                SecurityException ex3 = new SecurityException();
                                ex3.reason = sb.toString();
                                throw ex3;
                            }
                        }
                    }
                }
                catch (CertificateParsingException ex4) {
                    if ($assertionsDisabled) break block25;
                    throw new AssertionError();
                }
            }
        }
        if (!this._trustManager.verify(info)) {
            msg = (incoming ? "incoming" : "outgoing") + " connection rejected by trust manager\n" + Network.fdToString(fd);
            if (this._securityTraceLevel >= 1) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
        if (this._verifier != null && !this._verifier.verify(info)) {
            msg = (incoming ? "incoming" : "outgoing") + " connection rejected by certificate verifier\n" + Network.fdToString(fd);
            if (this._securityTraceLevel > 0) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
    }

    private void parseCiphers(String ciphers) {
        ArrayList<CipherExpression> cipherList = new ArrayList<CipherExpression>();
        String[] expr = ciphers.split("[ \t]+");
        for (int i = 0; i < expr.length; ++i) {
            PluginInitializationException ex;
            if (expr[i].equals("ALL")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `ALL' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._allCiphers = true;
                continue;
            }
            if (expr[i].equals("NONE")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `NONE' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._noCiphers = true;
                continue;
            }
            CipherExpression ce = new CipherExpression();
            String exp = expr[i];
            if (exp.charAt(0) == '!') {
                ce.not = true;
                if (exp.length() > 1) {
                    exp = exp.substring(1);
                } else {
                    PluginInitializationException ex2 = new PluginInitializationException();
                    ex2.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex2;
                }
            }
            if (exp.charAt(0) == '(') {
                if (!exp.endsWith(")")) {
                    PluginInitializationException ex3 = new PluginInitializationException();
                    ex3.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex3;
                }
                try {
                    ce.re = Pattern.compile(exp.substring(1, exp.length() - 2));
                }
                catch (PatternSyntaxException ex4) {
                    PluginInitializationException e = new PluginInitializationException();
                    e.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    e.initCause(ex4);
                    throw e;
                }
            } else {
                ce.cipher = exp;
            }
            cipherList.add(ce);
        }
        this._ciphers = new CipherExpression[cipherList.size()];
        cipherList.toArray(this._ciphers);
    }

    private boolean checkPath(StringHolder path, boolean dir) {
        String s;
        File f = new File(path.value);
        if (f.exists()) {
            return dir ? f.isDirectory() : f.isFile();
        }
        if (this._defaultDir.length() > 0 && (f = new File(s = this._defaultDir + File.separator + path.value)).exists() && (!dir && f.isFile() || dir && f.isDirectory())) {
            path.value = s;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Instance.class.desiredAssertionStatus();
    }

    private static class CipherExpression {
        boolean not;
        String cipher;
        Pattern re;

        private CipherExpression() {
        }
    }
}

