/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.ListTreeNode;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPopupMenu;

class PropertySets
extends ListTreeNode
implements PropertySetParent {
    private Map _descriptors;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map copyDescriptors(Map descriptors) {
        HashMap copy = new HashMap();
        Iterator p = descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            copy.put(entry.getKey(), PropertySet.copyDescriptor((PropertySetDescriptor)entry.getValue()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof PropertySetDescriptor;
        }
        actions[3] = true;
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(3));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void newPropertySet() {
        PropertySetDescriptor descriptor = new PropertySetDescriptor(new String[0], new LinkedList());
        this.newPropertySet(descriptor);
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        PropertySetDescriptor d = PropertySet.copyDescriptor((PropertySetDescriptor)descriptor);
        this.newPropertySet(d);
    }

    PropertySets(TreeNode parent, Map desc) throws UpdateFailedException {
        super(false, parent, "Property Sets");
        this._descriptors = desc;
        Iterator p = this._descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            this.insertChild(new PropertySet(false, this, (String)entry.getKey(), (PropertySetDescriptor)entry.getValue()), false);
        }
    }

    void update(Map updates, String[] removePropertySets) throws UpdateFailedException {
        this.removeChildren(removePropertySets);
        Vector<PropertySet> newChildren = new Vector<PropertySet>();
        Iterator p = updates.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String id = (String)entry.getKey();
            PropertySetDescriptor psd = (PropertySetDescriptor)entry.getValue();
            PropertySet child = (PropertySet)this.findChild(id);
            if (child == null) {
                newChildren.add(new PropertySet(false, this, id, psd));
                continue;
            }
            child.rebuild(psd);
        }
        this.insertChildren(newChildren, true);
    }

    Map getUpdates() {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            PropertySet ps = (PropertySet)p.next();
            if (!ps.getEditable().isNew() && !ps.getEditable().isModified()) continue;
            updates.put(ps.getId(), ps.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            PropertySet ps = (PropertySet)p.next();
            ps.commit();
        }
    }

    Object getDescriptor() {
        return this._descriptors;
    }

    public void tryAdd(String id, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new PropertySet(true, this, id, descriptor), true);
        this._descriptors.put(id, descriptor);
    }

    public void insertPropertySet(PropertySet nps, boolean fireEvent) throws UpdateFailedException {
        this.insertChild(nps, fireEvent);
    }

    public void removePropertySet(PropertySet nps) {
        this.removeChild(nps);
    }

    public void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    public Editable getEditable() {
        return super.getEditable();
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet propertySet;
        block2: {
            propertySet = new PropertySet(this, this.makeNewChildId("PropertySet"), descriptor);
            try {
                this.insertChild(propertySet, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(propertySet);
    }

    static {
        $assertionsDisabled = !PropertySets.class.desiredAssertionStatus();
    }
}

