/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.CloseConnectionException;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import IceInternal.BasicStream;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Protocol;
import IceInternal.Reference;
import IceUtil.OutputBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;

public abstract class OutgoingAsync {
    protected BasicStream __is;
    protected BasicStream __os;
    private ObjectPrx _proxy;
    private int _cnt;
    private OperationMode _mode;
    private volatile long _absoluteTimeoutMillis;
    private final Object _monitor = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract void ice_exception(LocalException var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void __finished(BasicStream is) {
        Object object = this._monitor;
        synchronized (object) {
            byte status;
            try {
                this.__is.swap(is);
                status = this.__is.readByte();
                switch (status) {
                    case 0: 
                    case 1: {
                        this.__is.startReadEncaps();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        String facet;
                        Identity id = new Identity();
                        id.__read(this.__is);
                        String[] facetPath = this.__is.readStringSeq();
                        if (facetPath.length > 0) {
                            if (facetPath.length > 1) {
                                throw new MarshalException();
                            }
                            facet = facetPath[0];
                        } else {
                            facet = "";
                        }
                        String operation = this.__is.readString();
                        RequestFailedException ex = null;
                        switch (status) {
                            case 2: {
                                ex = new ObjectNotExistException();
                                break;
                            }
                            case 3: {
                                ex = new FacetNotExistException();
                                break;
                            }
                            case 4: {
                                ex = new OperationNotExistException();
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                        ex.id = id;
                        ex.facet = facet;
                        ex.operation = operation;
                        throw ex;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        String unknown = this.__is.readString();
                        UnknownException ex = null;
                        switch (status) {
                            case 7: {
                                ex = new UnknownException();
                                break;
                            }
                            case 5: {
                                ex = new UnknownLocalException();
                                break;
                            }
                            case 6: {
                                ex = new UnknownUserException();
                                break;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                        ex.unknown = unknown;
                        throw ex;
                    }
                    default: {
                        throw new UnknownReplyStatusException();
                    }
                }
            }
            catch (LocalException ex) {
                this.__finished(ex);
                return;
            }
            if (!$assertionsDisabled && status != 0 && status != 1) {
                throw new AssertionError();
            }
            try {
                this.__response(status == 0);
            }
            catch (Exception ex) {
                this.warning(ex);
            }
            finally {
                this.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void __finished(LocalException exc) {
        Object object = this._monitor;
        synchronized (object) {
            if (this.__os != null && (this._mode == OperationMode.Nonmutating || this._mode == OperationMode.Idempotent || exc instanceof CloseConnectionException || exc instanceof ObjectNotExistException)) {
                try {
                    this._cnt = ((ObjectPrxHelperBase)this._proxy).__handleException(exc, this._cnt);
                    this.__send();
                    return;
                }
                catch (LocalException ex) {
                    // empty catch block
                }
            }
            try {
                this.ice_exception(exc);
            }
            catch (Exception ex) {
                this.warning(ex);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public final boolean __timedOut() {
        if (this._absoluteTimeoutMillis > 0L) {
            return System.currentTimeMillis() >= this._absoluteTimeoutMillis;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void __prepare(ObjectPrx prx, String operation, OperationMode mode, Map context) {
        Object object = this._monitor;
        synchronized (object) {
            try {
                while (this.__os != null) {
                    try {
                        this._monitor.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                ((ObjectPrxHelperBase)prx).__checkTwowayOnly(operation);
                this._proxy = prx;
                this._cnt = 0;
                this._mode = mode;
                Reference ref = ((ObjectPrxHelperBase)this._proxy).__reference();
                if (!$assertionsDisabled && this.__is != null) {
                    throw new AssertionError();
                }
                this.__is = new BasicStream(ref.getInstance());
                if (!$assertionsDisabled && this.__os != null) {
                    throw new AssertionError();
                }
                this.__os = new BasicStream(ref.getInstance());
                this.__os.writeBlob(Protocol.requestHdr);
                ref.getIdentity().__write(this.__os);
                String facet = ref.getFacet();
                if (facet == null || facet.length() == 0) {
                    this.__os.writeStringSeq(null);
                } else {
                    String[] facetPath = new String[]{facet};
                    this.__os.writeStringSeq(facetPath);
                }
                this.__os.writeString(operation);
                this.__os.writeByte((byte)mode.value());
                if (context == null) {
                    this.__os.writeSize(0);
                } else {
                    int sz = context.size();
                    this.__os.writeSize(sz);
                    if (sz > 0) {
                        Iterator i = context.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            this.__os.writeString((String)entry.getKey());
                            this.__os.writeString((String)entry.getValue());
                        }
                    }
                }
                this.__os.startWriteEncaps();
            }
            catch (LocalException ex) {
                this.cleanup();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void __send() {
        var1_1 = this._monitor;
        synchronized (var1_1) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    comp = new BooleanHolder();
                    con = ((ObjectPrxHelperBase)this._proxy).__getDelegate().__getConnection(comp);
                    this._absoluteTimeoutMillis = con.timeout() >= 0 ? System.currentTimeMillis() + (long)con.timeout() : 0L;
                    try {
                        con.sendAsyncRequest(this.__os, this, comp.value);
                        return;
                    }
                    catch (LocalExceptionWrapper ex) {
                        ((ObjectPrxHelperBase)this._proxy).__handleExceptionWrapper(ex);
                    }
                    catch (LocalException ex) {
                        this._cnt = ((ObjectPrxHelperBase)this._proxy).__handleException(ex, this._cnt);
                        continue;
                    }
                    break;
                }
            }
            catch (LocalException ex) {
                this.__finished(ex);
            }
            ** GOTO lbl-1000
        }
    }

    protected abstract void __response(boolean var1);

    private final void warning(Exception ex) {
        if (this.__os != null) {
            Reference ref = ((ObjectPrxHelperBase)this._proxy).__reference();
            if (ref.getInstance().initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.AMICallback", 1) > 0) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                OutputBase out = new OutputBase(pw);
                out.setUseTab(false);
                out.print("exception raised by AMI callback:\n");
                ex.printStackTrace(pw);
                pw.flush();
                ref.getInstance().initializationData().logger.warning(sw.toString());
            }
        }
    }

    private final void cleanup() {
        this.__is = null;
        this.__os = null;
        this._monitor.notify();
    }

    static {
        $assertionsDisabled = !OutgoingAsync.class.desiredAssertionStatus();
    }
}

