/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PROJECTSVIEW_H
#define PROJECTSVIEW_H

#include "view.h"
#include "rdb/tableitemmodel.h"

class QTreeView;
class QModelIndex;

/**
* View for displaying the tree of projects and folders.
*/
class ProjectsView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    ProjectsView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~ProjectsView();

public:
    /**
    * Set selection to the specified folder.
    */
    void setSelectedFolderId( int folderId );

    /**
    * Return the identifier of the selected folder.
    */
    int selectedFolderId() const { return m_selectedFolderId; }

public: // overrides
    void initialUpdate();

    bool eventFilter( QObject* obj, QEvent* e );

signals:
    /**
    * Emitted when the selected folder is changed.
    */
    void selectedFolderChanged( int folderId );

protected: // overrides
    void updateAccess( Access access );

    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void updateActions();

    void updateTimeout();

    void updateProjects();
    void showMembers();
    void addProject();
    void addFolder();
    void editRename();
    void editDelete();
    void editWatches();
    void toggleNotify();
    void openFolder();

    void contextMenu( const QPoint& pos );
    void activated( const QModelIndex& index );

    void projectsPopulated();

private:
    Access checkDataAccess();

    void updateSummary();

    void periodicUpdate( bool initial );

    QModelIndex selectedIndex();

private:
    QTreeView* m_list;
    RDB::TableItemModel* m_model;

    bool m_firstUpdateDone;

    int m_updateCounter;

    int m_selectedProjectId;
    int m_selectedFolderId;

    int m_currentProjectId;
    bool m_currentProjectAdmin;

    bool m_systemAdmin;
    bool m_anyProjectAdmin;

    int m_activateReason;
};

#endif
