/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TREEVIEWHELPER_H
#define TREEVIEWHELPER_H

#include <QMap>
#include <QPair>

class QTreeView;

/**
* Functions for reading and applying settings of a tree view.
*/
class TreeViewHelper
{
public:
    /**
    * Read sort order from the tree view.
    */
    static QPair<int, Qt::SortOrder> readSortOrder( QTreeView* view );

    /**
    * Apply sort order to the tree view.
    */
    static void applySortOrder( QTreeView* view, const QPair<int, Qt::SortOrder>& order );

    /**
    * Read column widths from the tree view.
    */
    static QMap<int, int> readColumnWidths( QTreeView* view );

    /**
    * Apply column widths to the tree view.
    */
    static void applyColumnWidths( QTreeView* view, const QMap<int, int>& widths );

    /**
    * Read expanded nodes from the tree view.
    */
    static QList<int> readExpandedNodes( QTreeView* view );

    /**
    * Apply expanded nodes to the tree view.
    */
    static void applyExpandedNodes( QTreeView* view, const QList<int>& nodes );
};

#endif
