/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "staterows.h"

FolderState::FolderState( int folderId ) :
    m_folderId( folderId ),
    m_listStamp( 0 ),
    m_cached( false ),
    m_watchState( NotWatched ),
    m_notify( false )
{
}

FolderState::~FolderState()
{
}

IssueState::IssueState( int issueId ) :
    m_issueId( issueId ),
    m_detailsStamp( 0 ),
    m_lockCount( 0 ),
    m_watchStamp( 0 ),
    m_notify( false )
{
}

IssueState::~IssueState()
{
}
