/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "preferencesdata.h"

PreferencesData::PreferencesData()
{
}

PreferencesData::~PreferencesData()
{
}

QString PreferencesData::value( const QString& key ) const
{
    return m_map.value( key );
}

bool PreferencesData::isEmpty() const
{
    return m_map.isEmpty();
}

void PreferencesData::setValue( const QString& key, const QString& value )
{
    m_map.insert( key, value );
}

void PreferencesData::clear()
{
    m_map.clear();
}

PreferencesData PreferencesData::compareWith( const PreferencesData& other ) const
{
    PreferencesData diff;

    for ( QMap<QString, QString>::const_iterator it = m_map.constBegin(); it != m_map.constEnd(); ++it ) {
        if ( other.m_map.value( it.key() ) != it.value() )
            diff.m_map.insert( it.key(), it.value() );
    }

    return diff;
}
