/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TYPESVIEW_H
#define TYPESVIEW_H

#include <QModelIndex>

#include "view.h"

class QTreeView;

namespace WebIssues
{

class TableItemModel;
class RowIndex;

/**
* View for displaying the tree of types and attributes.
*/
class TypesView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    TypesView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~TypesView();

public: // overrides
    void initialUpdate();

private slots:
    void updateActions();

    void updateTypes();
    void addType();
    void addAttribute();
    void editRename();
    void editModify();
    void editDelete();

    void contextMenu( const QPoint& pos );
    void activated( const QModelIndex& index );

    QModelIndex selectedIndex();

private:
    QTreeView* m_list;
    TableItemModel* m_model;

    int m_selectedTypeId;
    int m_selectedAttributeId;

    int m_currentTypeId;

    bool m_systemAdmin;
};

}

#endif
