#ifndef TLIN2PORT_H
#define TLIN2PORT_H

#include <Component.h>

#include <qpixmap.h>

class TLin2Port : public Component
{
public:
  TLin2Port( const QPoint& center );
  virtual ~TLin2Port();

  virtual void initComponent();
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn );

  virtual const QString& getCatagory() const;
  virtual const QString& getName() const;
  virtual const QPixmap& getPixmap() const;

  virtual bool initSweep();

protected:
  virtual void drawSymbol(QPainter*);

private:
  static QPixmap* pixmap_;
  TReal z_;
  TReal e_;
  TReal f_;
};

#endif
