/********************************************************************

    File:       common.c

    Purpose:    Utility functions for upsd.

                Copyright 1996, Bob Hauck
                Copyright 1998, Michael Robinton
                
                This program is free software; you can redistribute it
                and/or modify it under the terms of the GNU General Public
                License as published by the Free Software Foundation;
                either version 2 of the License, or (at your option) any
                later version.

                This program is distributed in the hope that it will be
                useful, but WITHOUT ANY WARRANTY; without even the implied
                warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
                PURPOSE.  See the GNU General Public License for more details.

                You should have received a copy of the GNU General Public
                License along with this program; if not, write to the Free
                Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
                USA.

    Language:   GCC 2.7.0

    Author:     Bob Hauck
    Modified:   Michael Robinton
    
    Revision 1.3  1997/05/13 18:09:00  miker
    Add text for -r -w options
    Add logic to turn logging completely off
    Move Version number into Makefile
    Rename Status to NetStatus to reflect usage.
    
    Revision 1.2  1997/01/20 22:35:48  bobh
    Move PWRSTAT file spec into makefile.

    Revision 1.1  1996/11/23 16:45:12  bobh
    Initial revision

**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "common.h"

static char *Version = VERSION;

char *ProgName;   /*  Program name  */
int   NetStatus;  /*  Network Status (S_* codes)  */
int   IsDaemon;   /*  -1 = quiet - not a daemon - no messages,
                   *   0 = not daemon, 1 daemon 
                   *   2 = daemon with log file open.  */


/*-------------------------------------------------------------------*
     LogError

     Log error messages to stderr or to syslog, depending on whether
     we are running as a daemon.

     Parameters:  Module - Module that is reporting the error.
                  Error  - Error message

     Returns:     Nothing.
 *-------------------------------------------------------------------*/
void LogError (const char *Module, const char *Error)
    {
    char *MBuf = alloca (strlen (Module) + 1);
    char *EBuf = alloca (strlen (Error) + 1);

    strcpy (MBuf, Module);
    strcpy (EBuf, Error);
    
    if (IsDaemon > 0)
        {
        if (IsDaemon == 1)
            {
            openlog (ProgName, LOG_CONS, LOG_DAEMON);
            ++IsDaemon;
            }
        syslog (LOG_WARNING, "%s: %s", MBuf, EBuf);
        }
    if (!(IsDaemon))
        {
        printf ("%s: %s: %s\n", ProgName, MBuf, EBuf);
        }
    }


/*-------------------------------------------------------------------*
     Usage

     Print help & usage information.

     Parameters:  None

     Returns:     Nothing.
 *-------------------------------------------------------------------*/
void Usage (void)
    {
    printf ("Usage:\n");
    printf ("    %s [options] device | host\n", ProgName);
    printf ("Options:\n");
    printf (" -c count  Delay 'count' polls before shutdown (default 2).\n");
    printf (" -d mode   Perform 'dummy' UPS event simulation.\n");
    printf ("           Mode= master: Serve the net with UPS 'status' from\n");
    printf ("           /tmp/upsds, all options except 'port' are ignored.\n");
    printf ("           Mode= local: Behave normally except UPS 'status' is\n");
    printf ("           taken from file /tmp/upsds instead of UPS or net,\n");
    printf ("           all other options are in force.\n");
    printf (" -e        Enhanced mode, support 'init' powerfailnow.\n");
    printf (" -h        Print this help.\n");
    printf (" -i time   Set poll interval to 'time' seconds (default 10).\n");
    printf (" -k        Kill power now.\n");
    printf (" -l        Don't shut down until low battery.\n");
    printf (" -m        Disable master mode.\n");
    printf (" -p port   Use 'port' for remote status (default 401).\n");
    printf (" -r        Recall powerfail status from /etc/upstatus.\n");
    printf (" -s        Slave to host instead of device.\n");
    printf (" -t        Test mode, don't become daemon.\n");
    printf (" -w time   Wait quietly, no messages, don't daemonize, check\n");
    printf ("           every 'time' seconds, return at power recovery.\n");
    printf ("\n");
    printf ("Version ID = %s\n", Version);
    }
