/* ========================================================================== */
/* === umfpack_get_numeric ================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_get_numeric
(
    int Lp [ ],
    int Li [ ],
    double Lx [ ],
    int Up [ ],
    int Ui [ ],
    double Ux [ ],
    int P [ ],
    int Q [ ],
    void *Numeric
) ;

long umfpack_l_get_numeric
(
    long Lp [ ],
    long Li [ ],
    double Lx [ ],
    long Up [ ],
    long Ui [ ],
    double Ux [ ],
    long P [ ],
    long Q [ ],
    void *Numeric
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Numeric ;
    int *Lp, *Li, *Up, *Ui, *P, *Q, status ;
    double *Lx, *Ux ;
    status = umfpack_get_numeric (Lp, Li, Lx, Up, Ui, Ux, P, Q, Numeric) ;

long Syntax:

    #include "umfpack.h"
    void *Numeric ;
    long *Lp, *Li, *Up, *Ui, *P, *Q, status ;
    double *Lx, *Ux ;
    status = umfpack_l_get_numeric (Lp, Li, Lx, Up, Ui, Ux, P, Q, Numeric) ;

Purpose:

    This routine copies the LU factors and permutation vectors from the Numeric
    object into user-accessible arrays.  This routine is not needed to solve a
    linear system.  Note that the output arrays Lp, Li, Lx, Up, Ui, Ux, P, and
    Q are not allocated by umfpack_get_numeric; they must exist on input.

Returns:

    Returns UMFPACK_OK if successful.  Returns UMFPACK_ERROR_out_of_memory
    if insufficient memory is available for the 2*n integer workspace that
    UMFPACK_get_numeric allocates to construct L and/or U.  Returns
    UMFPACK_ERROR_invalid_Numeric_object if the Numeric object provided as
    input is invalid.

Arguments:

    Int Lp [n+1] ;	Output argument.
    Int Li [lnz] ;	Output argument.
    double Lx [lnz] ;	Output argument.

	The matrix L is returned in compressed-row form.  The column indices
	of row i and corresponding numerical values are in:

	    Li [Lp [i] ... Lp [i+1]-1]
	    Lx [Lp [i] ... Lp [i+1]-1]

	respectively.  Each row is stored in sorted order, from low column
	indices to higher.  The last entry in each row is the diagonal, which
	is numerically equal to one.  The sizes of Lp, Li, and Lx are returned
	by umfpack_get_lunz.  If any one of the Lp, Li, or Lx arrays are not
	present, the L matrix is not returned.  This is not an error condition.
	Thus, if you do not want the L matrix returned, simply pass
	(Int *) NULL for Lp and Li, and (double *) NULL for Lx.
	The L matrix can be printed if n, Lp, Li, and Lx are passed to
	umfpack_report_matrix (using the "row" form).

    Int Up [n+1] ;	Output argument.
    Int Ui [unz] ;	Output argument.
    double Ux [unz] ;	Output argument.

	The matrix U is returned in compressed-column form.  The row indices
	of column j and corresponding numerical values are in

	    Ui [Up [j] ... Up [j+1]-1]
	    Ux [Up [j] ... Up [j+1]-1]

	respectively.  Each column is stored in sorted order, from low row
	indices to higher.  The last entry in each column is the diagonal.  The
	sizes of Up, Ui, and Ux are returned by umfpack_get_lunz.  If any one of
	the Up, Ui, or Ux arrays are not present, the U matrix is not returned.
	This is not an error condition.  Thus, if you do not want the U matrix
	returned, simply pass (Int *) NULL for Up and Ui, and (double *) NULL
	for Ux.  The U matrix can be printed if n, Up, Ui, and Ux are passed to
	umfpack_report_matrix (using the "column" form).

    Int P [n] ;		Output argument.

	The permutation vector P is defined as P [k] = i, where the original
	row i of A is the kth pivot row in PAQ.  If you do not want the P vector
	to be returned, simply pass (Int *) NULL for P.  This is not an error
	condition.  You can print P and Q with umfpack_report_perm.

    Int Q [n] ;		Output argument.

	The permutation vector Q is defined as Q [k] = j, where the original
	column j of A is the kth pivot column in PAQ.  If you not want the Q
	vector to be returned, simply pass (Int *) NULL for Q.  This is not
	an error condition.  Note that Q is not necessarily identical to
	Qtree, the column preordering held in the Symbolic object.  Refer to
	the description of Qtree and Front_npivots in umfpack_get_symbolic for
	details.

    void *Numeric ;	Input argument, not modified.

	Numeric must point to a valid Numeric object, computed by
	umfpack_numeric.

*/

