#include "cs_mex.h"
/* cs_updown: sparse Cholesky update/downdate */
void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    cs Lmatrix, *Lin, Cmatrix, *C, *L ;
    int ignore, j, k, n, lnz, *parent, sigma = 1 ;
    char sigma_string [20] ;
    if (nargout > 1 || nargin < 3 || nargin > 4)
    {
	mexErrMsgTxt ("Usage: L = cs_updown(L,c,parent,sigma)") ;
    }
    Lin = cs_get_sparse (&Lmatrix, 1, 1, pargin [0]) ;	/* get input L */
    n = Lin->n ;
    if (nargin > 3 && mxIsChar (pargin [3]))
    {
	mxGetString (pargin [3], sigma_string, 8) ;
	sigma = (sigma_string [0] == '-') ? (-1) : 1 ;
    }
    /* make a copy of L (this takes more work than updating L itself) */
    lnz = Lin->p [n] ;
    L = cs_spalloc (n, n, lnz, 1, 0) ;
    for (j = 0 ; j <= n ; j++) L->p [j] = Lin->p [j] ;
    for (k = 0 ; k < lnz ; k++) L->i [k] = Lin->i [k] ;
    for (k = 0 ; k < lnz ; k++) L->x [k] = Lin->x [k] ;
    cs_check (0, n, 1, 0, 1, 1, pargin [1]) ;		/* get C */
    C = cs_get_sparse (&Cmatrix, 0, 1, pargin [1]) ;
    parent = cs_get_int (n, pargin [2], &ignore, 0) ;	/* get parent */
    cs_updown (L, sigma, C, parent) ;			/* update/downdate */
    pargout [0] = cs_put_sparse (&L) ;			/* return new L */ 
}
