#include "cs_mex.h"
/* cs_dmperm: maximum matching or Dulmage-Mendelsohn permutation */
void mexFunction
(
    int	nargout,
    mxArray *pargout [ ],
    int	nargin,
    const mxArray *pargin [ ]
)
{
    cs *A, Amatrix ;
    csd *D ;
    int m, n, *jmatch ;
    if (nargin != 1 || nargout > 6)
    {
	mexErrMsgTxt ("Usage: [p,q,r,s,cc,rr] = cs_dmperm (A)") ;
    }
    A = cs_get_sparse (&Amatrix, 0, 0, pargin [0]) ;	/* get A */
    n = A->n ;
    m = A->m ;
    if (nargout <= 1)
    {
	jmatch = cs_maxtrans (A) ;			/* maximum matching */
	pargout [0] = cs_put_int (jmatch+m, n, 1, 0) ;	/* return imatch */
	cs_free (jmatch) ;
    }
    else
    {
	D = cs_dmperm (A) ;		/* Dulmage-Mendelsohn decomposition */
	pargout [0] = cs_put_int (D->P, m, 1, 0) ;
	pargout [1] = cs_put_int (D->Q, n, 1, 0) ;
	pargout [2] = cs_put_int (D->R, D->nb+1, 1, 0) ;
	pargout [3] = cs_put_int (D->S, D->nb+1, 1, 0) ;
	pargout [4] = cs_put_int (D->cc, 5, 1, 0) ;
	pargout [5] = cs_put_int (D->rr, 5, 1, 0) ;
	cs_dfree (D) ;
    }
}
