//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1994
// 
// uContext.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Wed Feb 23 17:32:14 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 11:09:32 2005
// Update Count     : 63
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>


// Adding or removing from a task's context list requires mutual exclusion
// because a context switch can occur while executing this code, which results
// in the context routine traversing a possibly inconsistent list structure.


uContext::uContext( void *key ) : key( key ) {
    // Check the lists of additional contexts for this execution state for a
    // context with the same unique key as the context being added in this
    // call.  If there is a similar context already active for this state, do
    // not add this context again.

    uBaseCoroutine &c = uThisCoroutine();		// optimization
    uContext *context;
    for ( uSeqIter<uContext> iter(c.uAdditionalContexts); iter >> context; ) {
      if ( context->key == key ) return;
    } // for

    // If no similar context is found, add this context to the list of contexts
    // active for this state.

    THREAD_GETMEM( uSelf )->disableInterrupts();
    c.uAdditionalContexts.addTail( this );
    c.uExtras.uIs.uContexts = 1;
    THREAD_GETMEM( uSelf )->enableInterrupts();
} // uContext::uContext

uContext::uContext() : key( this ) {
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    THREAD_GETMEM( uSelf )->disableInterrupts();
    c.uAdditionalContexts.addTail( this );
    c.uExtras.uIs.uContexts = 1;
    THREAD_GETMEM( uSelf )->enableInterrupts();
} // uContext::uContext

uContext::~uContext() {
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    // If the context is present on a list of contexts, remove it.
    if ( listed() ) {
	THREAD_GETMEM( uSelf )->disableInterrupts();
	c.uAdditionalContexts.remove( this );
	if ( c.uAdditionalContexts.empty() ) {
	    c.uExtras.uIs.uContexts = 0;
	} // if
	THREAD_GETMEM( uSelf )->enableInterrupts();
    } // if
} // uContext::~uContext


void uContext::save() {
} // uContext::save

void uContext::restore() {
} // uContext::restore


// Local Variables: //
// compile-command: "gmake install" //
// End: //
