//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1994
// 
// uC++.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Fri Dec 17 22:10:52 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jan  1 13:07:35 2006
// Update Count     : 2103
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uProfiler.h>
#include <uHeapLmmm.h>
#include <uBootTask.h>
#include <uSystemTask.h>
#include <uFilebuf.h>
//#include <uDebug.h>

#include <iostream>
#include <exception>
#include <dlfcn.h>
#include <cstdio>
#include <unistd.h>					// _exit

#if defined( __linux__ ) && defined( __i386__ ) && ! defined( __U_PTHREAD__ )
#include <asm/unistd.h>					// for _syscall3, __NR_modify_ldt

#ifndef _syscall3				        // fedora change to account for moved definition of _syscall3
#include <linux/unistd.h>
#endif

#include <asm/ldt.h>					// for struct modify_ldt_ldt_s
#include <linux/version.h>				// for KERNEL_VERSION

// modify_ldt has no prototype in the headers
// this is copied from the man page
_syscall3( int, modify_ldt, int, func, void *, ptr, unsigned long, bytecount );

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,40)
#define modify_ldt_ldt_s user_desc			// name change
#endif

#endif // __linux__ && __i386__ && ! __U_PTHREAD__

#if defined( __irix__ )
#include <ulocks.h>					// for usconfig
#include <sys/wait.h>					// for waitpid
#endif // __irix__

#if defined( __ia64__ )
#include <ia64intrin.h>					// __sync_lock_release
#endif // __ia64__

bool            uKernelModule::uKernelModuleInitialized	= false;
bool            uKernelModule::uInitialization		= false;
bool		uKernelModule::uCoreDumped		= false;
#ifndef __U_MULTI__
bool		uKernelModule::uDeadlock		= false;
#endif // ! __U_MULTI__
bool		uKernelModule::uGlobalAbort		= false;
bool		uKernelModule::uGlobalSpinAbort		= false;
uSpinLock	*uKernelModule::uGlobalAbortLock	= NULL;
uSpinLock	*uKernelModule::uGlobalProcessorLock	= NULL;
uSpinLock	*uKernelModule::uGlobalClusterLock	= NULL;
uDefaultScheduler *uKernelModule::uSystemScheduler	= NULL;
uCluster	*uKernelModule::uSystemCluster		= NULL;
uProcessor	*uKernelModule::uSystemProcessor	= NULL;
uBootTask	*uKernelModule::uTaskBoot		= (uBootTask *)&uTaskBootStorage;
uSystemTask	*uKernelModule::uTaskSystem		= NULL;
uProcessor	*uKernelModule::uUserProcessor		= NULL;
uCluster	*uKernelModule::uUserCluster		= NULL;

unsigned int    uKernelModule::uAttaching		= 0; // debugging

char		uKernelModule::uSystemProcessorStorage[sizeof(uProcessor)] __attribute__(( aligned (16) )) = {0};
char		uKernelModule::uSystemClusterStorage[sizeof(uCluster)] __attribute__(( aligned (16) )) = {0};
char		uKernelModule::uTaskBootStorage[sizeof(uBootTask)] __attribute__(( aligned (16) )) = {0};

std::filebuf	*uKernelModule::cerrFilebuf = NULL, *uKernelModule::clogFilebuf = NULL, *uKernelModule::coutFilebuf = NULL, *uKernelModule::cinFilebuf = NULL;


// Fake uKernelModule used before uKernelBoot::startup.
volatile __U_THREAD__ uKernelModule	uKernelModule::uKernelModuleBoot;

uProcessorSeq	*uKernelModule::uGlobalProcessors	= NULL;
uClusterSeq	*uKernelModule::uGlobalClusters		= NULL;

#ifdef __U_FLOATINGPOINTDATASIZE__
int		uFloatingPointContext::uniqueKey	= 0;
#endif // __U_FLOATINGPOINTDATASIZE__

#define __U_TIMEOUTPOSN__ 0				// bit 0 is reserved for timeout
#define __U_DESTRUCTORPOSN__ 1				// bit 1 is reserved for destructor

#ifndef __U_MULTI__
uNBIO		*uCluster::NBIO				= NULL;
#endif // ! __U_MULTI__

int		uKernelBoot::uCount			= 0;


extern "C" void _pthread_deletespecific( void * );	// see pthread simulation
extern "C" void _pthread_pid_destroy( void );


//######################### main #########################


// Declare a variable in shared memory to obtain a return code from the user
// program.  Unless modified, the return code is zero.

int uRetCode = 0;


// The main routine that gets the first task started with the OS supplied
// arguments, waits for its completion, and returns the result code to the OS.
// Define in this translation unit so it cannot be replaced by a user.

#if defined( __irix__ )
extern "C" void __do_global_dtors();
extern "C" void _exithandle();
extern "C" void _cleanup();
#endif // __irix__

int main( int argc, char *argv[] ) {
    {
	uMain uUserMain( *uKernelModule::uUserCluster, uMainStackSize(), argc, argv, uRetCode );
    }

    // Return the program return code to the operating system.

#if defined( __irix__ )
    // SKULLDUGGERY: irix does not run global destructors until all sprocs
    // have terminated.  But uC++ depends on destructors to terminate sprocs.
    // So, invoke the destructor sequence by hand here, and then _exit to
    // prevent the destructors from being done twice.  Because _exit stops
    // execution, all of the regular cleanups must done.

    _exithandle();					// atexit functions
    _cleanup();						// close files
    __do_global_dtors();				// global destructors
    _exit( uRetCode );
#endif // __irix__

    return uRetCode;
} // main


//######################### uSpinLock #########################


void *uSpinLock::operator new( size_t, void *storage ) {
    return storage;
} // uSpinLock::operator new

void *uSpinLock::operator new( size_t size ) {
    return ::operator new( size );
} // uSpinLock::operator new


uSpinLock::uSpinLock() {
    value = 0;						// unlock
} // uSpinLock::uSpinLock


void uSpinLock::acquire() {
    // No race condition exists for accessing uDisableIntSpin in the
    // multiprocessor case because this variable is private to each UNIX
    // process. Also, the spin lock must be acquired after adjusting
    // uDisableIntSpin because the time slicing must see the attempt to access
    // the lock first to prevent live-lock on the same processor.  For example,
    // one task acquires the ready queue lock, a time slice occurs, and it does
    // not appear that the current task is in the kernel because
    // uDisableIntSpin is not set so the signal handler tries to yield.
    // However, the ready queue lock is held so the yield live-locks. There is
    // a similar situation on releasing the lock.

#ifdef __U_DEBUG__
#ifndef __U_MULTI__
    if ( value != 0 ) {					// locked ?
	uAbort( "(uSpinLock &)0x%p.acquire() : internal error, attempt to multiply acquire spin lock by same task.", this );
    } // if
#endif // __U_MULTI__
#endif // __U_DEBUG__

    THREAD_GETMEM( uSelf )->disableIntSpinLock();

#ifdef __U_MULTI__
    if ( uAtomic( &value ) != 0 ) {			// test and set, uAtomic returns 0 or non-zero

#if 0
        THREAD_GETMEM( uSelf )->disableInterrupts();
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskStartSpin ) {
	    (*uProfiler::uProfiler_BuiltInRegisterTaskStartSpin)( uProfiler::uProfilerInstance, uThisTask() );
	} // if
	THREAD_GETMEM( uSelf )->enableInterrupts();
#endif

	int spin = 1;
	for ( ;; ) {					// poll for lock
	    THREAD_GETMEM( uSelf )->enableIntSpinLock();
	    for ( int i = 0; i < spin; i += 1 ) {	// exponential spin
		if ( uKernelModule::uGlobalSpinAbort ) {
		    _exit( -1 );			// close down in progress, shutdown immediately!
		} // if
	    } // for
	    spin += spin;				// powers of 2
	    if ( spin > 65536 ) spin = 1;		// prevent overflow
	    THREAD_GETMEM( uSelf )->disableIntSpinLock();
	  if ( uAtomic( &value ) == 0 ) break;		// test and set, uAtomic returns 0 or non-zero
	} // for

#if 0
        THREAD_GETMEM( uSelf )->disableInterrupts();
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskStopSpin ) {
	    (*uProfiler::uProfiler_BuiltInRegisterTaskStopSpin)( uProfiler::uProfilerInstance, uThisTask() );
	} // if
	THREAD_GETMEM( uSelf )->enableInterrupts();
#endif
    } // if
#if defined( __sparc__ )
    asm( "membar #LoadLoad" );				// flush the cache
#endif // __sparc__

#else
    value = 1;						// lock
#endif // __U_MULTI__
} // uSpinLock::acquire

// Same as acquire, except it calls uKernelModule::enableIntSpinLockNoRF()
void uSpinLock::acquireNoRF() {
    // No race condition exists for accessing uDisableIntSpin in the
    // multiprocessor case because this variable is private to each UNIX
    // process. Also, the spin lock must be acquired after adjusting
    // uDisableIntSpin because the time slicing must see the attempt to access
    // the lock first to prevent live-lock on the same processor.  For example,
    // one task acquires the ready queue lock, a time slice occurs, and it does
    // not appear that the current task is in the kernel because
    // uDisableIntSpin is not set so the signal handler tries to yield.
    // However, the ready queue lock is held so the yield live-locks. There is
    // a similar situation on releasing the lock.

#ifdef __U_DEBUG__
#ifndef __U_MULTI__
    if ( value != 0 ) {					// locked ?
	uAbort( "(uSpinLock &)0x%p.acquireNoRF() : internal error, attempt to multiply acquire spin lock by same task.", this );
    } // if
#endif // __U_MULTI__
#endif // __U_DEBUG__

    THREAD_GETMEM( uSelf )->disableIntSpinLock();

#ifdef __U_MULTI__
    if ( uAtomic( &value ) != 0 ) {			// test and set, uAtomic returns 0 or non-zero

#if 0
	THREAD_GETMEM( uSelf )->disableInterrupts();
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskStartSpin ) {
	    (*uProfiler::uProfiler_BuiltInRegisterTaskStartSpin)( uProfiler::uProfilerInstance, uThisTask() );
	} // if
	THREAD_GETMEM( uSelf )->enableInterrupts();
#endif

	int spin = 1;
	for ( ;; ) {					// poll for lock
	    THREAD_GETMEM( uSelf )->enableIntSpinLockNoRF();
	    for ( int i = 0; i < spin; i += 1 ) {	// exponential spin
		if ( uKernelModule::uGlobalSpinAbort ) {
		    _exit( -1 );			// close down in progress, shutdown immediately!
		} // if
	    } // for
	    spin += spin;				// powers of 2
	    if ( spin > 65536 ) spin = 1;		// prevent overflow
	    THREAD_GETMEM( uSelf )->disableIntSpinLock();
	  if ( uAtomic( &value ) == 0 ) break;		// test and set, uAtomic returns 0 or non-zero
	} // for

#if 0
	THREAD_GETMEM( uSelf )->disableInterrupts();
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskStopSpin ) {
	    (*uProfiler::uProfiler_BuiltInRegisterTaskStopSpin)( uProfiler::uProfilerInstance, uThisTask() );
	} // if
	THREAD_GETMEM( uSelf )->enableInterrupts();
#endif
    } // if
#if defined( __sparc__ )
    asm( "membar #LoadLoad" );				// flush the cache
#endif // __sparc__

#else
    value = 1;						// lock
#endif // __U_MULTI__
} // uSpinLock::acquireNoRF

bool uSpinLock::tryacquire() {
#ifdef __U_DEBUG__
#ifndef __U_MULTI__
    if ( value != 0 ) {					// locked ?
	uAbort( "(uSpinLock &)0x%p.tryacquire() : internal error, attempt to multiply acquire spin lock by same task.", this );
    } // if
#endif // __U_MULTI__
#endif // __U_DEBUG__

    THREAD_GETMEM( uSelf )->disableIntSpinLock();

#ifdef __U_MULTI__
    if ( uAtomic( &value ) == 0 ) {			// get the lock ?
#if defined( __sparc__ )
	asm( "membar #LoadLoad" );			// flush the cache
#endif // __sparc__
	return true;
    } else {
	THREAD_GETMEM( uSelf )->enableIntSpinLock();
	return false;
    } // if
#else
    value = 1;						// lock
    return true;
#endif // __U_MULTI__
} // uSpinLock::tryacquire

void uSpinLock::release() {
#if defined( __sparc__ )
    asm( "membar #StoreStore | #LoadStore" );		// flush the cache
#endif // __sparc__
    uAssert( value != 0 );
#if defined( __ia64__ )
    __sync_lock_release( &value );
#else
    value = 0;						// unlock
#endif // __ia64__
    THREAD_GETMEM( uSelf )->enableIntSpinLock();
} // uSpinLock::release

// Same as release, except it calls uKernelModule::enableIntSpinLockNoRF()
void uSpinLock::releaseNoRF() {
#if defined( __sparc__ )
    asm( "membar #StoreStore | #LoadStore" );		// flush the cache
#endif // __sparc__
    uAssert( value != 0 );
#if defined( __ia64__ )
    __sync_lock_release( &value );
#else
    value = 0;						// unlock
#endif // __ia64__
    THREAD_GETMEM( uSelf )->enableIntSpinLockNoRF();
} // uSpinLock::releaseNoRF


uCSpinLock::uCSpinLock( uSpinLock &spinLock ) : spinLock( spinLock ) {
    spinLock.acquire();
} // uCSpinLock::uCSpinLock

uCSpinLock::~uCSpinLock() {
    spinLock.release();
} // uCSpinLock::~uCSpinLock


//######################### uLock #########################


uLock::uLock() {
    value = 1;
} // uLock::uLock

uLock::uLock( unsigned int val ) {
#ifdef __U_DEBUG__
    if ( value > 1 ) {
	uAbort( "Attempt to initialize uLock 0x%p to %d, which exceeds range 0-1.", this, value );
    } // if
#endif // __U_DEBUG__
    value = val;
} // uLock::uLock

void uLock::acquire() {
    for ( ;; ) {
	spinLock.acquire();
      if ( value == 1 ) break;
	spinLock.release();
	uThisTask().yield();
    } // for
    value = 0;
    spinLock.release();
} // uLock::acquire

bool uLock::tryacquire() {
    spinLock.acquire();
    if ( value == 1 ) {
	value = 0;
	spinLock.release();
	return true;
    } else {
	spinLock.release();
	return false;
    } // if
} // uLock::tryacquire

void uLock::release() {
    value = 1;
} // uLock::release


//######################### uOwnerLock #########################


void *uOwnerLock::operator new( size_t, void *storage ) {
    return storage;
} // uOwnerLock::operator new

void *uOwnerLock::operator new( size_t size ) {
    return ::operator new( size );
} // uOwnerLock::operator new

void uOwnerLock::_add( uBaseTask &t ) {			// used by uCondLock::signal
    spin.acquire();
    if ( _owner != NULL ) {				// lock in use ?
	waiting.addTail( &(t.uEntryRef) );		// move task to owner lock list
    } else {
	_owner = &t;					// become owner
	count = 1;
	t.uWake();					// restart new owner
    } // if
    spin.release();
} // uOwnerLock::_add

void uOwnerLock::_release() {				// used by uCondLock::wait
    spin.acquire();
    if ( ! waiting.empty() ) {				// waiting tasks ?
	_owner = &(waiting.dropHead()->uGet());	// remove task at head of waiting list and make new owner
	count = 1;
	_owner->uWake();				// restart new owner
    } else {
	_owner = NULL;					// release, no owner
	count = 0;
    } // if
    spin.release();
} // uOwnerLock::_release

uOwnerLock::uOwnerLock() {
    _owner = NULL;					// no one owns the lock
    count = 0;						// so count is zero
} // uOwnerLock::uOwnerLock

#ifdef __U_DEBUG__
uOwnerLock::~uOwnerLock() {
    spin.acquire();
    if ( ! waiting.empty() ) {
	uBaseTask *t = &(waiting.head()->uGet());	// waiting list could change as soon as spin lock released
	spin.release();
	uAbort( "Attempt to delete owner lock with task %.256s (0x%p) still on it.", t->getName(), t );
    } // if
    spin.release();
} // uOwnerLock::uOwnerLock
#endif // __U_DEBUG__

unsigned int uOwnerLock::times() const {
    return count;
} // uOwnerLock::times

uBaseTask *uOwnerLock::owner() const {
    return _owner;
} // uOwnerLock::times

void uOwnerLock::acquire() {
    uBaseTask &t = uThisTask();				// optimization

    if ( uKernelModule::uInitialization ) uAssert( ! THREAD_GETMEM( uDisableInt ) && THREAD_GETMEM( uDisableIntCnt ) == 0 );
    spin.acquire();
    if ( _owner != &t ) {				// don't own lock yet
	if ( _owner != NULL ) {				// but if lock in use
	    waiting.addTail( &(t.uEntryRef) );		// suspend current task
	    uSCHEDULE( &spin );				// atomically release owner spin lock and block
	    // _owner and count set in release
	    return;
	} else {
	    _owner = &t;				// become owner
	    count = 1;
	} // if
    } else {
	count += 1;					// remember how often
    } // if
    spin.release();
} // uOwnerLock::acquire

bool uOwnerLock::tryacquire() {
    uBaseTask &t = uThisTask();				// optimization

    if ( uKernelModule::uInitialization ) uAssert( ! THREAD_GETMEM( uDisableInt ) && THREAD_GETMEM( uDisableIntCnt ) == 0 );
    spin.acquire();
    if ( _owner != &t ) {				// don't own lock yet
	if ( _owner != NULL ) {				// but if lock in use
	    spin.release();
	    return false;				// don't wait for the lock
	} // if
	_owner = &t;					// become owner
	count = 1;
    } else {
	count += 1;					// remember how often
    } // if
    spin.release();
    return true;
} // uOwnerLock::tryacquire

void uOwnerLock::release() {
    if ( uKernelModule::uInitialization ) uAssert( ! THREAD_GETMEM( uDisableInt ) && THREAD_GETMEM( uDisableIntCnt ) == 0 );
    spin.acquire();
#ifdef __U_DEBUG__
    if ( _owner != &uThisTask() ) {
	uBaseTask *t = _owner;				// owner could change as soon as spin lock released
	spin.release();
	uAbort( "Attempt to release owner lock, which is currently owned by task %.256s (0x%p).", t->getName(), t );
    } // if
#endif // __U_DEBUG__
    count -= 1;						// release the lock
    if ( count == 0 ) {					// if this is the last
	if ( ! waiting.empty() ) {			// waiting tasks ?
	    _owner = &(waiting.dropHead()->uGet());	// remove task at head of waiting list and make new owner
	    count = 1;
	    _owner->uWake();				// restart new owner
	} else {
	    _owner = NULL;				// release, no owner
	} // if
    } // if
    spin.release();
} // uOwnerLock::release


//######################### uCondLock #########################


void *uCondLock::operator new( size_t, void *storage ) {
    return storage;
} // uCondLock::operator new

void *uCondLock::operator new( size_t size ) {
    return ::operator new( size );
} // uCondLock::operator new

uCondLock::uCondLock() {
} // uCondLock::uCondLock

#ifdef __U_DEBUG__
uCondLock::~uCondLock() {
    spin.acquire();
    if ( ! waiting.empty() ) {
	uBaseTask *t = &(waiting.head()->uGet());
	spin.release();
	uAbort( "Attempt to delete owner lock with task %.256s (0x%p) still blocked on it.", t->getName(), t );
    } // if
    spin.release();
} // uCondLock::uCondLock
#endif // __U_DEBUG__

bool uCondLock::empty() const {
    return waiting.empty();
} // uCondLock::empty

void uCondLock::wait( uOwnerLock &lock ) {
    uBaseTask &t = uThisTask();				// optimization
#ifdef __U_DEBUG__
    uBaseTask *owner = lock.owner();			// owner could change
    if ( owner != &t ) {
	uAbort( "Attempt by waiting task %.256s (0x%p) to release owner lock currently owned by task %.256s (0x%p).",
		t.getName(), &t, owner->getName(), owner );
    } // if
#endif // __U_DEBUG__
    t.uLockPtr = &lock;					// task remembers this lock before blocking for use in signal
    unsigned int prevcnt = lock.count;			// remember this lock's recursive count before blocking
    spin.acquire();
    waiting.addTail( &(t.uEntryRef) );			// queue current task
    // Must add to the condition queue first before releasing the owner lock
    // because testing for empty condition can occur immediately after the
    // owner lock is released.
    lock._release();					// release owner lock
    uSCHEDULE( &spin );					// atomically release condition spin lock and block
    // spin released by uSchedule, owner lock is acquired when task restarts
    uAssert( &t == lock.owner() );
    lock.count = prevcnt;				// reestablish lock's recursive count after blocking
} // uCondLock::wait

bool uCondLock::timedwait( uOwnerLock &lock, uDuration duration ) {
    return timedwait( lock, uActiveProcessorKernel->uKernelClock.getTime() + duration );
} // uCondLock::timedwait

bool uCondLock::timedwait( uOwnerLock &lock, uTime time ) {
    uBaseTask &t = uThisTask();				// optimization
#ifdef __U_DEBUG__
    uBaseTask *owner = lock.owner();			// owner could change
    if ( owner != &t ) {
	uAbort( "Attempt by waiting task %.256s (0x%p) to release owner lock currently owned by task %.256s (0x%p).",
		t.getName(), &t, owner->getName(), owner );
    } // if
#endif // __U_DEBUG__
    t.uLockPtr = &lock;					// task remembers this lock before blocking for use in signal
    unsigned int prevcnt = lock.count;			// remember this lock's recursive count before blocking
    spin.acquire();

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCondLock &)0x%p.timedwait, task:0x%p\n", this, &t );
#endif // __U_DEBUG_H__

    uCondLockTimedwaitHndlr handler( t, *this );	// handler to wake up blocking task

    uEventNode uTimeoutEvent( t, handler, time, 0 );
    uTimeoutEvent.uExecuteLocked = true;

    uTimeoutEvent.add();

    waiting.addTail( &(t.uEntryRef) );			// queue current task
    // Must add to the condition queue first before releasing the owner lock
    // because testing for empty condition can occur immediately after the
    // owner lock is released.
    lock._release();					// release owner lock
    uSCHEDULE( &spin );					// atomically release owner spin lock and block
    // spin released by uSchedule, owner lock is acquired when task restarts
    uAssert( &t == lock.owner() );
    lock.count = prevcnt;				// reestablish lock's recursive count after blocking

    uTimeoutEvent.remove();

    return ! handler.timedout;
} // uCondLock::timedwait

void uCondLock::waitTimeout( uBaseTask &t, uCondLockTimedwaitHndlr &h ) {
    // This uCondLock member is called from the kernel, and therefore, cannot
    // block, but it can spin.

    spin.acquire();
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCondLock &)0x%p.waitTimeout, task:0x%p\n", this, &t );
#endif // __U_DEBUG_H__
    if ( t.uEntryRef.listed() ) {			// is task on queue
	waiting.remove( &(t.uEntryRef) );		// remove task at head of waiting list
	h.timedout = true;
	spin.release();
	t.uLockPtr->_add( t );				// restart it or chain to its owner lock
    } else {
	spin.release();
    } // if
} // uCondLock::waitTimeout

void uCondLock::signal() {
    spin.acquire();
    if ( waiting.empty() ) {				// signal on empty condition is no-op
	spin.release();
	return;
    } // if
    uBaseTask &t = waiting.dropHead()->uGet();		// remove task at head of waiting list
    spin.release();
    t.uLockPtr->_add( t );				// restart it or chain to its owner lock
} // uCondLock::signal

void uCondLock::broadcast() {
    // It is impossible to chain the entire waiting list to the associated
    // owner lock because each wait can be on a different owner lock. Hence,
    // each task has to be individually processed to move it onto the correct
    // owner lock.

    uQueue<uBaseTaskDL> temp;
    spin.acquire();
    uQueue<uBaseTaskDL>::transfer( temp, waiting );
    spin.release();
    while ( ! temp.empty() ) {
	uBaseTask &t = temp.dropHead()->uGet();	// remove task at head of waiting list
	t.uLockPtr->_add( t );				// restart it or chain to its owner lock
    } // while
} // uCondLock::broadcast


//######################### Real-Time #########################


uWakeupHndlr::uWakeupHndlr( uBaseTask &t ) {
    This = &t;
} // uWakeupHndlr::uWakeupHndlr

void uWakeupHndlr::uHandler() {
    This->uWake();
} // uWakeupHndlr::uHandler


void uCxtSwtchHndlr::uHandler() {
    // Do not use yield here because it polls for async events. Async events
    // cannot be delivered because there is a signal handler stack frame on the
    // current stack, and it is unclear what the semantics are for abnormally
    // terminating that frame.

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uCxtSwtchHndlr &)0x%p.uHandler yield task:0x%p\n", this, &uThisTask() );
#endif // __U_DEBUG_H__
    uThisTask().uYieldInvoluntary();
} // uCxtSwtchHndlr::uHandler


uTimeoutHndlr::uTimeoutHndlr( uBaseTask &t, uSerial &serial ) : serial( serial ) {
    This = &t;
} // uTimeoutHndlr::uTimeoutHndlr

uTimeoutHndlr::uTimeoutHndlr( uSerial &serial ) : serial( serial ) {
    This = NULL;
} // uTimeoutHndlr::uTimeoutHndlr

void uTimeoutHndlr::uHandler() {
    serial.uEnterTimeout();
} // uTimeoutHndlr::uHandler


uSelectTimeoutHndlr::uSelectTimeoutHndlr( uBaseTask &t, uNBIOnode &n ) : node( n ) {
    This = &t;
} // uSelectTimeoutHndlr::uSelectTimeoutHndlr

void uSelectTimeoutHndlr::uHandler() {
    node.uTimedout = true;
} // uSelectTimeoutHndlr::uHandle


uCondLockTimedwaitHndlr::uCondLockTimedwaitHndlr( uBaseTask &t, uCondLock &condlock ) : condlock( condlock ) {
    This = &t;
    timedout = false;
} // uCondLockTimedwaitHndlr::uCondLockTimedwaitHndlr

uCondLockTimedwaitHndlr::uCondLockTimedwaitHndlr( uCondLock &condlock ) : condlock( condlock ) {
    This = NULL;
    timedout = false;
} // uCondLockTimedwaitHndlr::uCondLockTimedwaitHndlr

void uCondLockTimedwaitHndlr::uHandler() {
    condlock.waitTimeout( *This, *this );
} // uCondLockTimedwaitHndlr::uHandler


uBaseTask &uBaseScheduleFriend::uGetInheritTask( uBaseTask &t ) const {
    return t.uGetInheritTask();
} // uBaseScheduleFriend::uGetInheritTask

int uBaseScheduleFriend::uGetActivePriority( uBaseTask &t ) const {
    // special case for base of active priority stack
    return t.getActivePriority();
} // uBaseScheduleFriend::uGetActivePriority

int uBaseScheduleFriend::uGetActivePriorityValue( uBaseTask &t ) const {
    return t.getActivePriorityValue();
} // uBaseScheduleFriend::uGetActivePriorityValue

int uBaseScheduleFriend::uSetActivePriority( uBaseTask &t1, int p ) {
    return t1.uSetActivePriority( p );
} // uBaseScheduleFriend::uSetActivePriority

int uBaseScheduleFriend::uSetActivePriority( uBaseTask &t1, uBaseTask &t2 ) {
    return t1.uSetActivePriority( t2 );
} // uBaseScheduleFriend::uSetActivePriority

int uBaseScheduleFriend::uGetBasePriority( uBaseTask &t ) const {
    return t.getBasePriority();
} // uBaseScheduleFriend::uGetBasePriority

int uBaseScheduleFriend::uSetBasePriority( uBaseTask &t, int p ) {
    return t.uSetBasePriority( p );
} // uBaseScheduleFriend::uSetBasePriority

int uBaseScheduleFriend::uGetActiveQueueValue( uBaseTask &t ) const {
    return t.getActiveQueueValue();
} // uBaseScheduleFriend::uGetActiveQueueValue

int uBaseScheduleFriend::uSetActiveQueue( uBaseTask &t1, int q ) {
    return t1.uSetActiveQueue( q );
} // uBaseScheduleFriend::uSetActiveQueue

int uBaseScheduleFriend::uGetBaseQueue( uBaseTask &t ) const {
    return t.getBaseQueue();
} // uBaseScheduleFriend::uGetBaseQueue

int uBaseScheduleFriend::uSetBaseQueue( uBaseTask &t, int q ) {
    return t.uSetBaseQueue( q );
} // uBaseScheduleFriend::uSetBaseQueue

bool uBaseScheduleFriend::uIsEntryBlocked( uBaseTask &t ) const {
    return t.uEntryRef.listed();
} // uBaseScheduleFriend::uIsEntryBlocked

bool uBaseScheduleFriend::uCheckHookConditions( uBaseTask &t1, uBaseTask &t2 ) const {
    return t2.getSerial().uCheckHookConditions( &t1 );
} // uBaseScheduleFriend::uCheckHookConditions


//######################### uBasePrioritySeq #########################


uBasePrioritySeq::uBasePrioritySeq() {
    uExecuteHooks = false;
} // uBasePrioritySeq::uBasePrioritySeq

bool uBasePrioritySeq::empty() const {
    return list.empty();
} // uBasePrioritySeq::empty

uBaseTaskDL *uBasePrioritySeq::head() const {
    return list.head();
} // uBasePrioritySeq::head

int uBasePrioritySeq::add( uBaseTaskDL *node, uBaseTask *uOwner ) {
    list.addTail( node );
    return 0;
} // uBasePrioritySeq::add

uBaseTaskDL *uBasePrioritySeq::drop() {
    return list.dropHead();
} // uBasePrioritySeq::drop

void uBasePrioritySeq::remove( uBaseTaskDL *node ) {
    list.remove( node );
} // uBasePrioritySeq::remove

void uBasePrioritySeq::uOnAcquire( uBaseTask &uOwner ) {
} // uBasePrioritySeq::uOnAcquire

void uBasePrioritySeq::uOnRelease( uBaseTask &uOldOwner ) {
} // uBasePrioritySeq::uOnRelease

int uBasePrioritySeq::uReposition( uBaseTask &t, uSerial &s ) {
    remove( &(t.uEntryRef) );				// remove from entry queue
    t.uCalledEntryMem->remove( &(t.uMutexRef) );	// remove from mutex queue
    
    // Call cluster routine to adjust ready queue and active priority as owner
    // is not on entry queue, it can be updated based on its uPIQ.

    uThisCluster().uTaskSetPriority( t, t );
    
    t.uCalledEntryMem->add( &(t.uMutexRef), s.uMutexOwner ); // add to mutex queue
    return add( &(t.uEntryRef), s.uMutexOwner );	// add to entry queue, automatically does transitivity
} // uBasePrioritySeq::uReposition


//######################### uBasePriorityQueue #########################


bool uBasePriorityQueue::empty() const {
    return list.empty();
} // uBasePriorityQueue::empty

uBaseTaskDL *uBasePriorityQueue::head() const {
    return list.head();
} // uBasePriorityQueue::head

int uBasePriorityQueue::add( uBaseTaskDL *node, uBaseTask *uOwner ) {
    list.add( node );
    return 0;						// dummy value
} // uBasePriorityQueue::add

uBaseTaskDL *uBasePriorityQueue::drop() {
    return list.drop();
} // uBasePriorityQueue::drop

void uBasePriorityQueue::remove( uBaseTaskDL *node ) {
    // Only used with default FIFO case, so node to remove is at the front of
    // the list.
    list.drop();
} // uBasePriorityQueue::remove

void uBasePriorityQueue::uOnAcquire( uBaseTask &uOwner ) {
} // uBasePriorityQueue::uOnAcquire

void uBasePriorityQueue::uOnRelease( uBaseTask &uOldOwner ) {
} // uBasePriorityQueue::uOnRelease



//######################### uRepositionEntry #########################


uRepositionEntry::uRepositionEntry( uBaseTask &b, uBaseTask &c ) : blocked( b ), calling( c ), bSerial( blocked.getSerial() ), cSerial( calling.getSerial() ) {
} // uRepositionEntry::uRepositionEntry

int uRepositionEntry::uReposition( bool RelCallingLock ) {
    int uRelPrevLock = 0;
    
    bSerial.lock.acquire();
    
    // If owner's current mutex object changes, then owner fixes its own active
    // priority. Recheck if inheritance is necessary as only owner can lower
    // its priority => updated.

    if ( &bSerial != &blocked.getSerial() || ! blocked.uEntryRef.listed() ||
	 blocked.uPIQ->uGetHighestPriority() >= blocked.getActivePriorityValue() ) {
	// As owner restarted, the end of the blocking chain has been reached.
	bSerial.lock.release();
	return uRelPrevLock;
    } // if

    if ( RelCallingLock == true ) {
	// release the old lock as correct current lock is acquired
	cSerial.lock.release();
	uRelPrevLock = 1;
    } // if

    if ( bSerial.uEntryList.uReposition( blocked, bSerial ) == 0 ) {
	// only last call does not release lock, so reacquire first entry lock
	if ( RelCallingLock == true ) uThisTask().getSerial().lock.acquire();
	bSerial.lock.release();
    } // if

    // The return value is based on the release of cSerial.lock not
    // bSerial.lock.  The return value from bSerial is processed in the if
    // statement above, so it does not need to be propagated.

    return uRelPrevLock;
} // uRepositionEntry::uReposition


//######################### uDefaultScheduler #########################


bool uDefaultScheduler::empty() const {
    return list.empty();
} // uDefaultScheduler::empty

void uDefaultScheduler::add( uBaseTaskDL *node ) {
    list.addTail( node );
} // uDefaultScheduler::add

uBaseTaskDL *uDefaultScheduler::drop() {
    return list.dropHead();
} // uDefaultScheduler::drop

bool uDefaultScheduler::uCheckPriority( uBaseTaskDL &, uBaseTaskDL & ) { return false; }

void uDefaultScheduler::uResetPriority( uBaseTaskDL &, uBaseTaskDL & ) {}

void uDefaultScheduler::addInitialize( uBaseTaskSeq & ) {};

void uDefaultScheduler::removeInitialize( uBaseTaskSeq & ) {};

void uDefaultScheduler::uRescheduleTask( uBaseTaskDL *, uBaseTaskSeq & ) {};


//######################### uKernelModule #########################


void uKernelModule::startup() {
    uKernelModule::uKernelModuleInitialized = true;
    volatile uKernelModule *km;

#if defined( __irix__ ) && defined( __U_MULTI__ )
    // the user part of the PRDA holds the kernel module
    km = (uKernelModule *)&(PRDA->usr_prda);
#elif defined( __ia64__ ) && defined( __linux__ ) && defined( __U_MULTI__ )
#if defined( __U_TLS__ ) && ! defined( __INTEL_COMPILER )
    asm volatile ("addl %0 = @ltoff(@tprel(_ZN13uKernelModule17uKernelModuleBootE#)), gp;;\n"
                  "ld8 %0 = [%0];;\n"
                  "add %0 = %0, r13;;\n" : "=r" (km) );
#else
    km = &uKernelModule::uKernelModuleBoot;
#endif // __U_TLS__
#elif defined( __i386__ ) && defined( __linux__ ) && defined( __U_MULTI__ )
#if defined( __U_TLS__ )
    asm volatile ("movl %%gs:0,%0\n"
		  "leal _ZN13uKernelModule17uKernelModuleBootE@ntpoff(%0),%0"
		  : "=r" (km) );
#else
    km = &uKernelModule::uKernelModuleBoot;
    km->threadPointer = (unsigned long)km;
    km->ldtValue = uProcessor::uAllocLDT();
#endif // __U_TLS__
#elif defined( __x86_64__ ) && defined( __linux__ ) && defined( __U_MULTI__ )
    asm volatile ("movq %%fs:0,%0\n"
		  "leaq _ZN13uKernelModule17uKernelModuleBootE@tpoff(%0),%0"
		  : "=r" (km) );
#elif defined( __sparc__ ) && defined( __U_TLS__ ) && defined( __U_MULTI__ )
    asm volatile ("sethi %%tle_hix22(_ZN13uKernelModule17uKernelModuleBootE),%0\n\t"
		  "xor %0, %%tle_lox10(_ZN13uKernelModule17uKernelModuleBootE), %0\n\t"
		  "add %%g7, %0, %0" : "=r" (km) );
#else
    // use statically allocated kernel module
    km = &uKernelModule::uKernelModuleBoot;
#endif

    km->ctor();
} // uKernelModule::startup


void uKernelModule::ctor() volatile {
    uSelf = this;
    uKernelModuleInitialized = true;

    uActiveProcessor = (uProcessor *)&uKernelModule::uSystemProcessorStorage;
    uActiveCluster = (uCluster *)&uKernelModule::uSystemClusterStorage;
    uActiveTask = (uBaseTask *)&uTaskBootStorage;

    uDisableInt = true;
    uDisableIntCnt = 1;

    uDisableIntSpin = false;
    uDisableIntSpinCnt = 0;

    InKernelRF = 0;

#if defined( __U_MULTI__ )
    // set private memory pointer
#if defined( __linux__ )
#if defined( __i386__ )
#if ! defined( __U_TLS__ )
    int ldtIndex = ( ldtValue - 7 ) / 8;
    struct modify_ldt_ldt_s ldtEntry =
    {
    	ldtIndex,
    	(unsigned long int) threadPointer,
    	0xfffff /* 4GB in pages */,
    	1, 0, 0, 1, 0, 1 //, 0
    };
    if ( modify_ldt( 1, &ldtEntry, sizeof(ldtEntry) ) != 0 ) {
	uAbort( "(uKernelModule &)0x%p.ctor() : internal error, modify_ldt.", this );
    } // if
    asm volatile ( "movw %w0, %%gs" : : "q" (ldtValue) );
#endif // ! __U_TLS__

#elif defined( __ia64__ )
#if defined( __U_TLS__ )
#ifdef __INTEL_COMPILER
    threadPointer = __getReg( _IA64_REG_TP );
#else
    register volatile uKernelModule *thread_self asm( "r13" );
    threadPointer = (unsigned long)thread_self;
#endif // __INTEL_COMPILER
#else
    threadPointer = (unsigned long)&uIA64OffsetStoreFlag;
    uIA64OffsetStoreFlag = 0;
    /* Register r13 (tp) is reserved by the ABI as "thread pointer". */
    asm volatile ("mov r13=%0" : : "r" (&uIA64OffsetStoreFlag));
#endif // __U_TLS__

#elif defined( __x86_64__ )
    // assume TLS -- nothing to do

#else
    #error uC++ : internal error, unsupported architecture
#endif

#elif defined( __solaris__ )
#if ! defined( __U_TLS__ )
    _lwp_setprivate( (void *)this );
#endif // __U_TLS__

#elif defined( __irix__ )

#else
    #error uC++ : internal error, unsupported architecture
#endif
#endif // __U_MULTI__
} // uKernelModule::ctor


void uKernelModule::processEvents( uEventList *events, bool inKernel ) {
#ifdef __U_DEBUG_H__
    char buffer[256];
    int debugCnt = 0;
#endif // __U_DEBUG_H__
    uEventNode *event;

    for ( uEventListPop iter( *events, inKernel ); iter >> event; ) {
#ifdef __U_DEBUG_H__
	debugCnt += 1;
	uDebugPrtBuf( buffer, "processEvents, pop #%d\n", debugCnt );
#endif // __U_DEBUG_H__
    } // for
} // uKernelModule::processEvents


void uKernelModule::rollForward( bool inKernel ) {
#ifdef __U_DEBUG_H__
    char buffer[256];
    uDebugPrtBuf( buffer, "rollForward( %d ), uDisableInt:%d, uDisableIntCnt:%d, uDisableIntSpin:%d, uDisableIntSpinCnt:%d, InKernelRF:%d\n",
		  inKernel, THREAD_GETMEM(uDisableInt), THREAD_GETMEM(uDisableIntCnt), THREAD_GETMEM(uDisableIntSpin), THREAD_GETMEM(uDisableIntSpinCnt), THREAD_GETMEM(InKernelRF) );
#endif // __U_DEBUG_H__

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    if ( &uThisProcessor() == uKernelModule::uSystemProcessor ) {
	processEvents( uThisProcessor().uEvents, true );
    } // if
    processEvents( uThisProcessor().uProcEvents, inKernel );
#else
    processEvents( uThisProcessor().uEvents, inKernel );
#endif // __U_ONETIMER__ && __U_MULTI__

#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buffer, "rollForward, leaving, InKernelRF:%d\n", THREAD_GETMEM( InKernelRF) );
#endif // __U_DEBUG_H__
} // rollForward


//######################### Translator Generated Definitions #########################


uCoroutineConstructor::uCoroutineConstructor( uAction f, uSerial &s, uBaseCoroutine &c, const char *n ) {
    if ( f == uYes ) {
	c.uStartHere( (void (*)( uMachContext & ))uMachContext::uInvokeCoroutine );
	c.name = n;
	c.serial = &s;					// set cormonitor's serial instance

	if ( uThisTask().uProfileActive && uProfiler::uProfiler_RegisterCoroutine && // profiling & coroutine registered for profiling ?
	     dynamic_cast<uProcessorKernel *>(&c) == NULL ) { // and not kernel coroutine
	    (*uProfiler::uProfiler_RegisterCoroutine)( uProfiler::uProfilerInstance, c, s );
	} // if
    } // if
} // uCoroutineConstructor::uCoroutineConstructor


uCoroutineDestructor::uCoroutineDestructor( uAction f, uBaseCoroutine &c ) : f( f ), c( c ) {
} // uCoroutineDestructor::uCoroutineDestructor

uCoroutineDestructor::~uCoroutineDestructor() {
    if ( f == uYes ) {
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_DeregisterCoroutine ) { // profiling this coroutine & coroutine registered for profiling ? 
	    (*uProfiler::uProfiler_DeregisterCoroutine)( uProfiler::uProfilerInstance, c );
	} // if
    } // if
} // uCoroutineDestructor::~uCoroutineDestructor


uCoroutineMain::uCoroutineMain( uBaseCoroutine &c ) : c( c ) {
    // also appears in uBaseCoroutine::uContextSw2
    if ( uThisTask().uProfileActive && uProfiler::uProfiler_RegisterCoroutineUnblock ) {
	if ( THREAD_GETMEM( uDisableInt ) ) return;	// ignore profiling for kernel coroutine
	(*uProfiler::uProfiler_RegisterCoroutineUnblock)( uProfiler::uProfilerInstance, uThisTask() );
    } // if
} // uCoroutineMain::uCoroutineMain

uCoroutineMain::~uCoroutineMain( ) {			// necessary for KDB
} // uCoroutineMain::uCoroutineMain


uSerial::uSerial( uBasePrioritySeq &uEntryList ) : uEntryList( uEntryList ) {
    uMask.clrAll();					// mutex members start closed
    uMutexOwner = &uThisTask();				// set the current mutex owner to the creating task

    // Make creating task the owner of the mutex.
    prevSerial = &uMutexOwner->getSerial();		// save previous serial
    uMutexOwner->uSetSerial( *this );			// set new serial
    mr = uMutexOwner->mutexRecursion;			// save previous recursive count
    uMutexOwner->mutexRecursion = 0;			// reset recursive count

    acceptMask = false;
    uMutexMaskPosn = NULL;

    uDestructorTask = NULL;  
    uDestructorStatus = NoDestructor;
    uConstructorTask = uMutexOwner;

    // real-time

    uTimeoutEvent.uExecuteLocked = true;
    uProc = NULL;
    uEvents = NULL;

    // exception handling

    uLastAcceptor = NULL;
    uAlive = true;
    uTimedoutRF = false;

    // profiling

    uProfileSerialSamplerInstance = NULL;
} // uSerial::uSerial

uSerial::~uSerial() {
    uAlive = false;					// no more entry calls can be accepted
    uBaseTask &t = uThisTask();				// optimization
    t.uSetSerial( *prevSerial );			// reset previous serial

    for ( ;; ) {
	uBaseTaskDL *p = uAcceptSignalled.drop();
      if ( p == NULL ) break;
	uMutexOwner = &(p->uGet());
	_Throw EntryFailure( this, "blocked on acceptor/signalled stack" ) _At *(uMutexOwner->currCoroutine);
	uAcceptSignalled.add( &(t.uMutexRef) );		// suspend current task on top of accept/signalled stack
	uSCHEDULE( uMutexOwner );
    } // for

    if ( ! uEntryList.empty() ) {			// no need to acquire the lock if the queue is empty
	for ( ;; ) {
	    lock.acquire();
	    uBaseTaskDL *p = uEntryList.drop();
	  if ( p == NULL ) break;
	    uMutexOwner = &(p->uGet());
	    uMutexOwner->uCalledEntryMem->remove( &(uMutexOwner->uMutexRef) );
	    _Throw EntryFailure( this, "blocked on entry queue" ) _At *(uMutexOwner->currCoroutine);
	    uAcceptSignalled.add( &(t.uMutexRef) ); // suspend current task on top of accept/signalled stack
	    uSCHEDULE( &lock, uMutexOwner );
	} // for
	lock.release();
    } // if
} // uSerial::~uSerial

bool uSerial::uCheckHookConditions( uBaseTask *t ) {
    return t != uConstructorTask && t != uDestructorTask;
} // uSerial::uCheckHookConditions

void uSerial::uResetDestructorStatus() {
    uDestructorStatus = NoDestructor;
    uDestructorTask = NULL;
} // uSerial::uCheckHookConditions

void uSerial::uEnter( unsigned int &mr, uBasePrioritySeq &ml, int mp ) {
    uBaseTask &t = uThisTask();				// optimization
    lock.acquire();

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uEnter, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, ml:0x%p, mp:%d\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, &ml, mp );
#endif // __U_DEBUG_H__
    if ( uMask.isSet( mp ) ) {				// member acceptable ?
	uMask.clrAll();					// clear the mask
	mr = t.mutexRecursion;				// save previous recursive count
	t.mutexRecursion = 0;				// reset recursive count
	uMutexOwner = &t;				// set the current mutex owner
	if ( uEntryList.uExecuteHooks ) {
	    // always execute hook as calling task cannot be constructor or destructor
	    uEntryList.uOnAcquire( *uMutexOwner );	// perform any priority inheritance
	} // if
	lock.release();
    } else if ( uMutexOwner == &t ) {			// already hold mutex ?
	t.mutexRecursion += 1;				// another recursive call at the mutex object level
	lock.release();
    } else {						// otherwise block the calling task
	ml.add( &(t.uMutexRef), uMutexOwner );		// add to end of mutex queue
	t.uCalledEntryMem = &ml;			// remember which mutex member called
	uEntryList.add( &(t.uEntryRef), uMutexOwner ); // add mutex object to end of entry queue
	uSCHEDULE( &lock );				// find someone else to execute; release lock on kernel stack
	mr = t.mutexRecursion;				// save previous recursive count
	t.mutexRecursion = 0;				// reset recursive count
	_Enable <uSerial::Failure>;			// implicit poll
    } // if
    if ( uMutexMaskPosn != NULL ) *uMutexMaskPosn = mp;	// set active mutex member
} // uSerial::uEnter

// enter routine for destructor, does not poll
void uSerial::uEnterDestructor( unsigned int &mr, uBasePrioritySeq &ml, int mp ) {
    uBaseTask &t = uThisTask();				// optimization

    if ( uDestructorStatus != NoDestructor ) {		// only one task is allowed to call destructor
	uAbort( "Attempt by task %.256s (0x%p) to call the destructor for uSerial 0x%p, but this destructor was already called by task %.256s (0x%p).\n"
		"Possible cause is multiple tasks simultaneously deleting a mutex object.",
		t.getName(), &t, this, uDestructorTask->getName(), uDestructorTask );
    } // if

    lock.acquire();

    uDestructorStatus = DestrCalled;
    uDestructorTask = &t;

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uEnterNoPoll, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, ml:0x%p, mp:%d\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, &ml, mp );
#endif // __U_DEBUG_H__
    if ( uMask.isSet( mp ) ) {				// member acceptable ?
	uMask.clrAll();					// clear the mask
	mr = t.mutexRecursion;				// save previous recursive count
	t.mutexRecursion = 0;				// reset recursive count
	uMutexOwner = &t;				// set the current mutex owner
	uDestructorStatus = DestrScheduled;
	// hook is not executed for destructor
	lock.release();
    } else if ( uMutexOwner == &t ) {			// already hold mutex ?
	uAbort( "Attempt by task %.256s (0x%p) to call the destructor for uSerial 0x%p, but this task has outstanding nested calls to this mutex object.\n"
		"Possible cause is deleting a mutex object with outstanding nested calls to one of its members.",
		t.getName(), &t, this );
    } else {						// otherwise block the calling task
	t.uCalledEntryMem = &ml;			// remember which mutex member was called
	uSCHEDULE( &lock );				// find someone else to execute; release lock on kernel stack
	mr = t.mutexRecursion;				// save previous recursive count
	t.mutexRecursion = 0;				// reset recursive count
    } // if
    if ( uMutexMaskPosn != NULL ) *uMutexMaskPosn = mp;	// set active mutex member
} // uSerial::uEnterDestructor

void uSerial::uEnterTimeout() {
    // This monitor member is called from the kernel, and therefore, cannot
    // block, but it can spin.

    lock.acquire();

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uEnterTimeout, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, uMutexMaskPosn:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, uMutexMaskPosn );
#endif // __U_DEBUG_H__
    if ( uMask.isSet( __U_TIMEOUTPOSN__ ) ) {		// timeout member acceptable ?  0 => timeout mask bit
	uMask.clrAll();					// clear the mask
	*uMutexMaskPosn = 0;				// set timeout mutex member  0 => timeout mask bit
	uMutexOwner = &(uAcceptSignalled.drop()->uGet()); // next task to gain control of the mutex object
	
	// priority-inheritance, bump up priority of mutexowner from head
	// of prioritized entry queue (NOT leaving task), because suspended
	// stack is not prioritized.
	
	if ( uEntryList.uExecuteHooks && uCheckHookConditions( uMutexOwner ) ) {
	    uEntryList.uOnAcquire( *uMutexOwner );
	} // if

#ifdef __U_DEBUG_H__
	uDebugPrt( "(uSerial &)0x%p.uEnterTimeout, waking task %.256s (0x%p) \n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
	uMutexOwner->uWake();				// wake up next task to use this mutex object
    } // if

    lock.release();
} // uSerial::uEnterTimeout

// uLeave and uLeave2 do not poll for concurrent exceptions because they are
// called in some critical destructors.  Throwing an exception out of these
// destructors causes problems.

void uSerial::uLeave( unsigned int mr ) {		// used when a task is leaving a mutex and has not queued itself before calling
    uBaseTask &t = uThisTask();				// optimization

    if ( t.mutexRecursion != 0 ) {			// already hold mutex ?
	if ( acceptMask ) {
	    // lock is acquired and mask set by accept statement
	    acceptMask = false;
	    lock.release();
	} // if
	t.mutexRecursion -= 1;
    } else {
	if ( acceptMask ) {
	    // lock is acquired and mask set by accept statement
	    acceptMask = false;
	    uMutexOwner = NULL;				// reset no task in mutex object
	    if ( uEntryList.uExecuteHooks && uCheckHookConditions( &t)  ) {
		uEntryList.uOnRelease( t );
	    } // if
	    if ( &t == uDestructorTask ) uResetDestructorStatus();
	    lock.release();
	} else if ( uAcceptSignalled.empty() ) {	// no tasks waiting re-entry to mutex object ?
	    lock.acquire();
	    if ( uDestructorStatus != DestrCalled ) {
		if ( uEntryList.empty() ) {		// no tasks waiting entry to mutex object ?
		    uMask.setAll();			// accept all members
		    uMask.clr( 0 );			// except timeout
		    uMutexOwner = NULL;			// reset no task in mutex object
		    if ( uEntryList.uExecuteHooks && uCheckHookConditions( &t)  ) {
			uEntryList.uOnRelease( t );
		    } // if
		    if ( &t == uDestructorTask ) uResetDestructorStatus();
		    lock.release();
		} else {				// tasks wating entry to mutex object
		    uMutexOwner = &(uEntryList.drop()->uGet()); // next task to gain control of the mutex object
		    uMutexOwner->uCalledEntryMem->remove( &(uMutexOwner->uMutexRef) ); // also remove task from mutex queue
		    if ( uEntryList.uExecuteHooks ) {
			if ( uCheckHookConditions( &t) ) uEntryList.uOnRelease( t );
			if ( uCheckHookConditions( uMutexOwner ) ) uEntryList.uOnAcquire( *uMutexOwner );
		    } // if
		    if ( &t == uDestructorTask ) uResetDestructorStatus();
		    lock.release();
#ifdef __U_DEBUG_H__
		    uDebugPrt( "(uSerial &)0x%p.uLeave, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
		    uMutexOwner->uWake();		// wake up next task to use this mutex object
		} // if
	    } else {
		uMutexOwner = uDestructorTask;
		uDestructorStatus = DestrScheduled;
		if ( uEntryList.uExecuteHooks ) {
		    if ( uCheckHookConditions( &t) ) uEntryList.uOnRelease( t );
		    // do not call acquire the hook for the destructor
		} // if
		lock.release();
#ifdef __U_DEBUG_H__
		    uDebugPrt( "(uSerial &)0x%p.uLeave, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
		uMutexOwner->uWake();			// wake up next task to use this mutex object
	    } // if
	} else {
	    // priority-inheritance, bump up priority of mutexowner from head
	    // of prioritized entry queue (NOT leaving task), because suspended
	    // stack is not prioritized.

	    if ( uEntryList.uExecuteHooks ) {
		lock.acquire();				// acquire entry lock to prevent inversion during transfer 
		uMutexOwner = &(uAcceptSignalled.drop()->uGet()); // next task to gain control of the mutex object
		if ( uCheckHookConditions( &t) ) uEntryList.uOnRelease( t );
		if ( uCheckHookConditions( uMutexOwner ) ) uEntryList.uOnAcquire( *uMutexOwner );
#ifdef __U_DEBUG_H__
		uDebugPrt( "(uSerial &)0x%p.uLeave, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
		uMutexOwner->uWake();			// wake up next task to use this mutex object
		if ( &t == uDestructorTask ) uResetDestructorStatus();
		lock.release();
	    } else {
#ifdef __U_DEBUG_H__
		uDebugPrt( "(uSerial &)0x%p.uLeave, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
		uMutexOwner = &(uAcceptSignalled.drop()->uGet()); // next task to gain control of the mutex object
		if ( &t == uDestructorTask ) {
		    lock.acquire();
		    uResetDestructorStatus();
		    lock.release();
		} // if
		uMutexOwner->uWake();			// wake up next task to use this mutex object
	    } // if
	} // if
	t.mutexRecursion = mr;				// restore previous recursive count
    } // if

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uLeave, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n", this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif // __U_DEBUG_H__
} // uSerial::uLeave

void uSerial::uLeave2() {				// used when a task is leaving a mutex and has queued itself before calling
    uBaseTask &t = uThisTask();				// optimization

    if ( acceptMask ) {
	// lock is acquired and mask set by accept statement
	acceptMask = false;
	uMutexOwner = NULL;				// reset no task in mutex object
	if ( uEntryList.uExecuteHooks && uCheckHookConditions( &t )  ) {
	    uEntryList.uOnRelease( t );
	} // if
	if ( &t == uDestructorTask ) uResetDestructorStatus();
	uSCHEDULE( &lock );				// find someone else to execute; release lock on kernel stack
    } else if ( uAcceptSignalled.empty() ) {		// no tasks waiting re-entry to mutex object ?
	lock.acquire();
        if ( uDestructorStatus != DestrCalled ) {
	    if ( uEntryList.empty() ) {		// no tasks waiting entry to mutex object ?
		uMask.setAll();				// accept all members
		uMask.clr( 0 );				// except timeout
		uMutexOwner = NULL;
		if ( uEntryList.uExecuteHooks && uCheckHookConditions( &t ) ) {
		    uEntryList.uOnRelease( t );
		} // if
		uSCHEDULE( &lock );			// find someone else to execute; release lock on kernel stack
	    } else {
		uMutexOwner = &(uEntryList.drop()->uGet()); // next task to gain control of the mutex object
		uMutexOwner->uCalledEntryMem->remove( &(uMutexOwner->uMutexRef) ); // also remove task from mutex queue
		if ( uEntryList.uExecuteHooks ) {
		    if ( uCheckHookConditions( &t ) ) uEntryList.uOnRelease( t );
		    if ( uCheckHookConditions( uMutexOwner ) ) uEntryList.uOnAcquire( *uMutexOwner );
		} // if
#ifdef __U_DEBUG_H__
		uDebugPrt( "(uSerial &)0x%p.uLeave2, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
		uSCHEDULE( &lock, uMutexOwner );	// find someone else to execute; release lock and wake on kernel stack
	    } // if
	} else {
	   uMutexOwner = uDestructorTask;
	   uDestructorStatus = DestrScheduled;
	   if ( uEntryList.uExecuteHooks ) {
	       if ( uCheckHookConditions( &t ) ) uEntryList.uOnRelease( t );
	       // do not call acquire the hook for the destructor
	   } // if
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSerial &)0x%p.uLeave2, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
	    uSCHEDULE( &lock, uMutexOwner );		// find someone else to execute; release lock and wake on kernel stack
	} // if
    } else {
	// priority-inheritance, bump up priority of mutexowner from head of
	// prioritized entry queue (NOT leaving task), because suspended stack
	// is not prioritized.

#ifdef __U_DEBUG_H__
	uDebugPrt( "(uSerial &)0x%p.uLeave2, waking task %.256s (0x%p)\n", this, uMutexOwner->getName(), uMutexOwner );
#endif // __U_DEBUG_H__
	if ( uEntryList.uExecuteHooks ) {
	    lock.acquire();
	    uMutexOwner = &(uAcceptSignalled.drop()->uGet()); // next task to gain control of the mutex object
	    if ( uCheckHookConditions( &t ) ) uEntryList.uOnRelease( t );
	    if ( uCheckHookConditions( uMutexOwner ) ) uEntryList.uOnAcquire( *uMutexOwner );
	    uSCHEDULE( &lock, uMutexOwner );		// find someone else to execute; release lock and wake on kernel stack
	} else {
	    uMutexOwner = &(uAcceptSignalled.drop()->uGet()); // next task to gain control of the mutex object
	    uSCHEDULE( uMutexOwner );			// find someone else to execute; wake on kernel stack
	} // if
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uLeave2, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif // __U_DEBUG_H__
} // uSerial::uLeave2


// The field uSerial::uLastAcceptor is set in uAcceptTry and uAcceptPause and
// reset to NULL in uSerialMember::uSerialMember, so an exception can be thrown
// when all the guards in the accept statement fail.  This ensures that
// uLastAcceptor is set only when a task rendezouvs with another task.

void uSerial::uAcceptStart( unsigned int &uMutexMaskPosn ) {
    uBaseTask &t = uThisTask();				// optimization
#ifdef __U_DEBUG__
    if ( &t != uMutexOwner ) {				// must have mutex lock to wait
	uAbort( "Attempt to accept in a mutex object not locked by this task.\n"
		"Possible cause is accepting in a nomutex member routine." );
    } // if
#endif // __U_DEBUG__

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterAcceptStart ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterAcceptStart)( uProfiler::uProfilerInstance, *this, t );
    } // if

    uSerial::uMutexMaskPosn = &uMutexMaskPosn;
    acceptLocked = false;
} // uSerial::uAcceptStart

bool uSerial::uAcceptTry( uBasePrioritySeq &ml, int mp ) {
    if ( ! acceptLocked ) {				// lock is acquired on demand
	lock.acquire();
	uMask.clrAll();
	acceptLocked = true;
    } // if
    if ( mp == __U_DESTRUCTORPOSN__ ) {			// ? destructor accepted
	// Handles the case where destructor has not been called or the
	// destructor has been scheduled.  If the destructor has been
	// scheduled, there is potential for synchronization deadlock when only
	// the destructor is accepted.
	if ( uDestructorStatus != DestrCalled ) {
	    uMask.set( mp );				// add this mutex member to the mask
	    return false;				// the accept failed
	} else {
	    uBaseTask &t = uThisTask();			// optimization
	    uMutexOwner = uDestructorTask;		// next task to use this mutex object
	    uDestructorStatus = DestrScheduled;		// change status of destructor to scheduled
	    uLastAcceptor = &t;				// saving the acceptor thread of a rendezvous
	    uMask.clrAll();				// clear the mask
	    uAcceptSignalled.add( &(t.uMutexRef) );	// suspend current task on top of accept/signalled stack
	    if ( uEntryList.uExecuteHooks ) {
		// no check for destructor because it cannot accept itself
		if ( uCheckHookConditions( &t ) ) uEntryList.uOnRelease( t );  
		// do not call the acquire hook for the destructor
	    } // if
	    uSCHEDULE( &lock, uMutexOwner );		// find someone else to execute; release lock and wake on kernel stack
	    if ( t.uAcceptedCall ) {			// accepted entry is suspended if true
		t.uAcceptedCall->uAcceptorSuspended = false; // acceptor resumes
		t.uAcceptedCall = NULL;
	    } // if
	    _Enable <uSerial::RendezvousFailure>;	// implicit poll
	    return true;
	} // if
    } else {
	if ( ml.empty() ) {
	    uMask.set( mp );				// add this mutex member to the mask
	    return false;				// the accept failed
	} else {
	    uBaseTask &t = uThisTask();			// optimization
	    uMutexOwner = &(ml.drop()->uGet());	// next task to use this mutex object
	    uLastAcceptor = &t;				// saving the acceptor thread of a rendezvous
	    uEntryList.remove( &(uMutexOwner->uEntryRef) ); // also remove task from entry queue
	    uMask.clrAll();				// clear the mask
	    uAcceptSignalled.add( &(t.uMutexRef) );	// suspend current task on top of accept/signalled stack
	    if ( uEntryList.uExecuteHooks ) {
		if ( uCheckHookConditions( &t ) ) uEntryList.uOnRelease( t );  
		if ( uCheckHookConditions( uMutexOwner ) ) uEntryList.uOnAcquire( *uMutexOwner );
	    } // if
	    uSCHEDULE( &lock, uMutexOwner );		// find someone else to execute; release lock and wake on kernel stack
	    if ( t.uAcceptedCall ) {			// accepted entry is suspended if true
		t.uAcceptedCall->uAcceptorSuspended = false; // acceptor resumes
		t.uAcceptedCall = NULL;
	    } // if
	    _Enable <uSerial::RendezvousFailure>;	// implicit poll
	    return true;
	} // if
    } // if
} // uSerial::uAcceptTry

void uSerial::uAcceptTry() {
    if ( ! acceptLocked ) {				// lock is acquired on demand
	lock.acquire();
	uMask.clrAll();
	acceptLocked = true;
    } // if
    uMask.set( 0 );					// add this mutex member to the mask, 0 => timeout mask bit
} // uSerial::uAcceptTry

bool uSerial::uAcceptTry2( uBasePrioritySeq &ml, int mp ) {
    if ( ! acceptLocked ) {				// lock is acquired on demand
	lock.acquire();
	uMask.clrAll();
	acceptLocked = true;
    } // if
    if ( mp == __U_DESTRUCTORPOSN__ ) {			// ? destructor accepted
	// Handles the case where destructor has not been called or the
	// destructor has been scheduled.  If the destructor has been
	// scheduled, there is potential for synchronization deadlock when only
	// the destructor is accepted.
	if ( uDestructorStatus != DestrCalled ) {
	    uMask.set( mp );				// add this mutex member to the mask
	    return false;				// the accept failed
	} else {
	    uBaseTask *acceptedTask = uDestructorTask;	// next task to use this mutex object
	    uDestructorStatus = DestrScheduled;		// change status of destructor to scheduled
	    uMask.clrAll();				// clear the mask
	    lock.release();
	    uAcceptSignalled.add( &(acceptedTask->uMutexRef) ); // move accepted task on top of accept/signalled stack
	    return true;
	} // if
    } else {
	if ( ml.empty() ) {
	    uMask.set( mp );				// add this mutex member to the mask
	    return false;				// the accept failed
	} else {
	    uBaseTask *acceptedTask = &(ml.drop()->uGet()); // next task to use this mutex object
	    uEntryList.remove( &(acceptedTask->uEntryRef) ); // also remove task from entry queue
	    uMask.clrAll();				// clear the mask
	    lock.release();
            uAcceptSignalled.add( &(acceptedTask->uMutexRef) ); // move accepted task on top of accept/signalled stack
	    return true;
	} // if
    } // if
} // uSerial::uAcceptTry2

bool uSerial::uAcceptTestMask() {
    return uMask.isAllClr();
} // uSerial::uAcceptTestMask

void uSerial::uAcceptElse() {
    if ( acceptLocked ) {
	uMask.clrAll();
	lock.release();
    } // if
} // uSerial::uAcceptElse

void uSerial::uAcceptMask() {
    // The lock acquired at the start of the accept statement cannot be
    // released here, otherwise, it is necessary to recheck the mutex queues
    // before exit. As a consequence, all destructors between here and
    // ~uSerialMember (which executes uLeave) are executed with the mutex lock
    // closed, preventing tasks from queuing on this mutex object.
    acceptMask = true;
} // uSerial::uAcceptMask

void uSerial::uAcceptPause() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uAcceptPause, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif // __U_DEBUG_H__
    // lock is acquired at beginning of accept statement
    uBaseTask &t = uThisTask();				// optimization
    uLastAcceptor = &t;					// saving the acceptor thread of a rendezvous
    uAcceptSignalled.add( &(t.uMutexRef) );		// suspend current task on top of accept/signalled stack
    uMutexOwner = NULL;
    if ( uEntryList.uExecuteHooks && uCheckHookConditions( &t ) ) {
	uEntryList.uOnRelease( t );
    } // if
    uSCHEDULE( &lock );					// find someone else to execute; release lock on kernel stack
    if ( t.uAcceptedCall ) {				// accepted entry is suspended if true
        t.uAcceptedCall->uAcceptorSuspended = false;	// acceptor resumes
	t.uAcceptedCall = NULL;
    } // if
    _Enable <uSerial::Failure>;				// implicit poll
} // uSerial::uAcceptPause

void uSerial::uAcceptPause( uDuration duration ) {
    uAcceptPause( uActiveProcessorKernel->uKernelClock.getTime() + duration );
} // uSerial::uAcceptPause

void uSerial::uAcceptPause( uTime time ) {
    uBaseTask &t = uThisTask();				// optimization
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uAcceptPause, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif // __U_DEBUG_H__
    uTimeoutHndlr handler( t, *this );			// handler to wake up blocking task

    uTimeoutEvent.uExecuteLocked = true;
    uTimeoutEvent.timerT = time;
    uTimeoutEvent.uWho = &t;
    uTimeoutEvent.SigHandler = &handler;

    uTimeoutEvent.add();

    // lock is acquired at beginning of accept statement
    uBaseTask &uCallingTask = t;			// optimization
    uLastAcceptor = &uCallingTask;			// saving the acceptor thread of a rendezvous
    uAcceptSignalled.add( &(uCallingTask.uMutexRef) );	// suspend current task on top of accept/signalled stack

    uMutexOwner = NULL;
    if ( uEntryList.uExecuteHooks && uCheckHookConditions( &uCallingTask ) ) {
	uEntryList.uOnRelease( uCallingTask );
    } // if
    uSCHEDULE( &lock );					// find someone else to execute; release lock on kernel stack

    uTimeoutEvent.remove();

    if ( uCallingTask.uAcceptedCall ) {			// accepted entry is suspended if true
        uCallingTask.uAcceptedCall->uAcceptorSuspended = false;	// acceptor resumes
	uCallingTask.uAcceptedCall = NULL;
    } // if
    _Enable <uSerial::Failure>;				// implicit poll
} // uSerial::uAcceptPause

void uSerial::uRemoveTimeout() {
    if ( uEvents != NULL ) {
	uTimeoutEvent.remove();
    } // if
} // uSerial::uRemoveTimeout

void uSerial::uAcceptEnd() {
    uMutexMaskPosn = NULL;

    if ( uThisTask().uProfileActive && uProfiler::uProfiler_RegisterAcceptEnd ) { // task registered for profiling ?              
	(*uProfiler::uProfiler_RegisterAcceptEnd)( uProfiler::uProfilerInstance, *this, uThisTask() );
    } // if
} // uSerial::uAcceptEnd


uSerial::uProtectAcceptStmt::uProtectAcceptStmt( uSerial &s ) : s( s ) {
    s.uAcceptStart( uMutexMaskPosn );
} // uSerial::uProtectAcceptStmt::uProtectAcceptStmt

uSerial::uProtectAcceptStmt::uProtectAcceptStmt( uSerial &s, bool ) : s( s ) {
    s.uRemoveTimeout();
    s.uAcceptStart( uMutexMaskPosn );
} // uSerial::uProtectAcceptStmt::uProtectAcceptStmt

uSerial::uProtectAcceptStmt::~uProtectAcceptStmt() {
    s.uAcceptEnd();
} // uSerial::uProtectAcceptStmt::~uProtectAcceptStmt


uSerial::Failure::Failure( const uSerial *const serial, const char *const msg ) : uKernelFailure( msg ), serial( serial ) {}

uSerial::Failure::Failure( const char *const msg ) : uKernelFailure( msg ), serial( NULL ) {}

uSerial::Failure::~Failure() {}

const uSerial *uSerial::Failure::serialId() const { return serial; }

void uSerial::Failure::defaultTerminate() const {
    uAbort( "(uSerial &)0x%p : %.256s.", serialId(), message() );
} // uSerial::Failure::defaultTerminate


uSerial::EntryFailure::EntryFailure( const uSerial *const serial, const char *const msg ) : uSerial::Failure( serial, msg ) {}

uSerial::EntryFailure::EntryFailure( const char *const msg ) : uSerial::Failure( msg ) {}

uSerial::EntryFailure::~EntryFailure() {}

void uSerial::EntryFailure::defaultTerminate() const {
    uAbort( "(uSerial &)0x%p : Entry failure while executing mutex destructor, task %.256s (0x%p) found %.256s.",
	    serialId(), sourceName(), &source(), message() );
} // uSerial::EntryFailure::defaultTerminate


uSerial::RendezvousFailure::RendezvousFailure( const uSerial *const serial, const char *const msg ) : uSerial::Failure( serial, msg ), _caller( &uThisCoroutine() ) {}

uSerial::RendezvousFailure::~RendezvousFailure() {}

const uBaseCoroutine *uSerial::RendezvousFailure::caller() const { return _caller; }

void uSerial::RendezvousFailure::defaultTerminate() const {
    uAbort( "(uSerial &)0x%p : Rendezvous failure in %.256s from task %.256s (0x%p) to mutex member of task %.256s (0x%p).",
	    serialId(), message(), sourceName(), &source(), uThisTask().getName(), &uThisTask() );
} // uSerial::RendezvousFailure::defaultTerminate


uTaskConstructor::uTaskConstructor( uAction f, uSerial &s, uBaseTask &t, uBasePIQ &piq, const char *n, bool profile ) : f( f ), s( s ), t( t ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uTaskConstructor &)0x%p.uTaskConstructor, f:%d, s:0x%p, t:0x%p, piq:0x%p, n:%s, profile:%d\n", this, f, &s, &t, &piq, n, profile );
#endif // __U_DEBUG_H__
    if ( f == uYes ) {
	t.uStartHere( (void (*)( uMachContext & ))uMachContext::uInvokeTask );
	t.name = n;
	t.serial = &s;					// set task's serial instance
	t.uSetSerial( s );
	t.uProfileActive = profile;
	t.uPIQ = &piq;

	if ( t.uProfileActive && uProfiler::uProfiler_RegisterTask ) { // profiling this task & task registered for profiling ? 
	    (*uProfiler::uProfiler_RegisterTask)( uProfiler::uProfilerInstance, t, s, uThisTask() );
	} // if

	s.uAcceptSignalled.add( &(t.uMutexRef) );

#if __U_LOCALDEBUGGER_H__
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->checkPoint();
#endif // __U_LOCALDEBUGGER_H__

	t.currCluster->uTaskAdd( t );			// add task to the list of tasks on this cluster
    } // if
} // uTaskConstructor::uTaskConstructor


uTaskConstructor::~uTaskConstructor() {
    if ( f == uYes && std::uncaught_exception() ) {
	// An exception was thrown during task construction. It is necessary to
	// clean up constructor side-effects.

	// Since no task could have been accepted, the acceptor/signaller stack
	// should only contain this task.  It must be removed here so that it
	// is not scheduled by ~uSerial.
	s.uAcceptSignalled.drop();

	uTaskDestructor::cleanup( t );
    } // if
} // uTaskConstructor::~uTaskConstructor


uTaskDestructor::uTaskDestructor( uAction f, uBaseTask &t ) : f( f ), t( t ) {
} // uTaskDestructor::uTaskDestructor

uTaskDestructor::~uTaskDestructor() {
    if ( f == uYes ) {
#ifdef __U_DEBUG__
	if ( t.uBaseCoroutine::getState() != uBaseCoroutine::Halt ) {
	    uAbort( "Attempt to delete task %.256s (0x%p) that is not halted.\n"
		    "Possible cause is task blocked on a condition queue.",
		    t.getName(), &t );
	} // if
#endif // __U_DEBUG__

	cleanup( t );
    } // if
} // uTaskDestructor::uTaskDestructor


void uTaskDestructor::cleanup( uBaseTask &t ) {
#if __U_LOCALDEBUGGER_H__
    if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->checkPoint();
#endif // __U_LOCALDEBUGGER_H__

    t.uProfileActive = false;
    if ( t.uProfileTaskSamplerInstance && uProfiler::uProfiler_DeregisterTask ) { // task registered for profiling ?
	(*uProfiler::uProfiler_DeregisterTask)( uProfiler::uProfilerInstance, t );
    } // if

    t.currCluster->uTaskRemove( t );			// remove the task from the list of tasks that live on this cluster.
} // uTaskDestructor::cleanup


uTaskMain::uTaskMain( uBaseTask &t ) : t( t ) {
    // SKULLDUGGERY: To allow "main" to be treated as a normal member routine,
    // a counter is used to allow recursive entry.

    t.recursion += 1;
    if ( t.recursion == 1 ) {				// first call ?
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterTaskStartExecution ) { 
	    (*uProfiler::uProfiler_RegisterTaskStartExecution)( uProfiler::uProfilerInstance, t ); 
	} // if
#if __U_LOCALDEBUGGER_H__
	// Registering a task with the global debugger must occur in this
	// routine for the register set to be correct.

	if ( uLocalDebugger::uLocalDebuggerActive ) {
	    uLocalDebugger::uLocalDebuggerInstance->createULThread();
	} // if
#endif // __U_LOCALDEBUGGER_H__
    } // if
} // uTaskMain::uTaskMain


uTaskMain::~uTaskMain() {
    t.recursion -= 1;
    if ( t.recursion == 0 ) {
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterTaskEndExecution ) {
	    (*uProfiler::uProfiler_RegisterTaskEndExecution)( uProfiler::uProfilerInstance, t ); 
	} // if   
#if __U_LOCALDEBUGGER_H__
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->destroyULThread();
#endif // __U_LOCALDEBUGGER_H__
    } // if
} // uTaskMain::~uTaskMain


uSerialConstructor::uSerialConstructor( uAction f, uSerial &s ) : f( f ), s( s ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerialConstructor &)0x%p.uSerialConstructor, f:%d, s:0x%p\n", this, f, &s );
#endif // __U_DEBUG_H__
} // uSerialConstructor::uSerialConstructor

uSerialConstructor::uSerialConstructor( uAction f, uSerial &s, const char *n ) : f( f ), s( s ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerialConstructor &)0x%p.uSerialConstructor, f:%d, s:0x%p, n:%s\n", this, f, &s, n );
#endif // __U_DEBUG_H__
    if ( f == uYes ) {
	if ( uThisTask().uProfileActive && uProfiler::uProfiler_RegisterMonitor ) { // task registered for profiling ?
	    (*uProfiler::uProfiler_RegisterMonitor)( uProfiler::uProfilerInstance, s, n, uThisTask() );
	} // if
    } // if
} // uSerialConstructor::uSerialConstructor

uSerialConstructor::~uSerialConstructor() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerialConstructor &)0x%p.~uSerialConstructor\n", this );
#endif // __U_DEBUG_H__
    if ( f == uYes && ! std::uncaught_exception() ) {
	uBaseTask &t = uThisTask();			// optimization

	t.uSetSerial( *s.prevSerial );			// reset previous serial
	s.uLeave( s.mr );
    } // if
} // uSerialConstructor::~uSerialConstructor


uSerialDestructor::uSerialDestructor( uAction f, uSerial &s, uBasePrioritySeq &ml, int mp ) : f( f ) {
    if ( f == uYes ) {
	uBaseTask &t = uThisTask();			// optimization
#ifdef __U_DEBUG__
	nlevel = t.uCurrSerialLevel += 1;
#endif // __U_DEBUG__
	s.prevSerial = &t.getSerial();			// save previous serial
	t.uSetSerial( s );				// set new serial

	s.uEnterDestructor( mr, ml, mp );
	if ( ! s.uAcceptSignalled.empty() ) {
	    s.uLastAcceptor = NULL;
	    uBaseTask &uCallingTask = t;		// optimization
	    s.uMutexOwner = &(s.uAcceptSignalled.drop()->uGet());
	    s.uAcceptSignalled.add( &(uCallingTask.uMutexRef) ); // suspend terminating task on top of accept/signalled stack
	    uSCHEDULE( s.uMutexOwner );			// find someone else to execute; wake on kernel stack
	} // if
    } // if
} // uSerialDestructor::uSerialDestructor

uSerialDestructor::~uSerialDestructor() {
    if ( f == uYes ) {
	uBaseTask &t = uThisTask();			// optimization
	uSerial &s = t.getSerial();			// get current serial
	// Useful for dynamic allocation if an exception is thrown in the
	// destructor so the object can continue to be used and deleted again.
#ifdef __U_DEBUG__
	if ( nlevel != t.uCurrSerialLevel ) {
	    uAbort( "Attempt to perform a non-nested entry and exit from multiple accessed mutex objects." );
	} // if
	t.uCurrSerialLevel -= 1;
#endif // __U_DEBUG__
	if ( std::uncaught_exception() ) {
	    s.uLeave( mr );
	} else {
	    if ( t.uProfileActive && uProfiler::uProfiler_DeregisterMonitor ) { // task registered for profiling ?
		(*uProfiler::uProfiler_DeregisterMonitor)( uProfiler::uProfilerInstance, s, t );
	    } // if

	    t.mutexRecursion = mr;			// restore previous recursive count
	} // if
    } // if
} // uSerialDestructor::~uSerialDestructor


void uSerialMember::finalize( uBaseTask &t ) {
#ifdef __U_DEBUG__
    if ( nlevel != t.uCurrSerialLevel ) {
	uAbort( "Attempt to perform a non-nested entry and exit from multiple accessed mutex objects." );
    } // if
    t.uCurrSerialLevel -= 1;
#endif // __U_DEBUG__
    t.uSetSerial( *prevSerial );			// reset previous serial
} // uSerialMember::finalize

uSerialMember::uSerialMember( uSerial &s, uBasePrioritySeq &ml, int mp ) {
    uBaseTask &t = uThisTask();				// optimization

    // There is a race condition between setting and testing this flag.
    // However, it is the best that can be expected because the mutex storage
    // is being deleted.

    if ( ! s.uAlive ) {					// check against improper memory management
	_Throw uSerial::EntryFailure( &s, "mutex object has been destroyed" );
    } // if

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionEntryTry ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterMutexFunctionEntryTry)( uProfiler::uProfilerInstance, s, t );
    } // if

    try {
	// Polling in uEnter happens after properly setting values of mr and
	// therefore, in the catch clause, it can be used to retore the mr
	// value in the uSerial object.

	prevSerial = &t.getSerial();			// save previous serial
	t.uSetSerial( s );				// set new serial
#ifdef __U_DEBUG__
	nlevel = t.uCurrSerialLevel += 1;
#endif // __U_DEBUG__
	s.uEnter( mr, ml, mp );
        acceptor = s.uLastAcceptor;
	uAcceptorSuspended = acceptor != NULL;
	if ( uAcceptorSuspended ) {
	    acceptor->uAcceptedCall = this;
	} // if
	s.uLastAcceptor = NULL;				// avoid messing up subsequent mutex method invocation
    } catch( ... ) {					// UNDO EFFECTS OF FAILED SERIAL ENTRY
	finalize( t );
        if ( s.uLastAcceptor ) {
	    s.uLastAcceptor->uAcceptedCall = NULL;      // the rendezvous did not materialize
	    _Resume uSerial::RendezvousFailure( &s, "accepted call" ) _At *s.uLastAcceptor->currCoroutine; // acceptor is not initialized
	    s.uLastAcceptor = NULL;
	} // if
	s.uLeave( mr );					// look at ~uSerialMember()
	_Throw;
    } // try

    noUserOverride = true;

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionEntryDone ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterMutexFunctionEntryDone )( uProfiler::uProfilerInstance, s, t );
    } // if
} // uSerialMember::uSerialMember

uSerialMember::~uSerialMember() {
    uBaseTask &t = uThisTask();				// optimization
    uSerial &s = t.getSerial();				// get current serial

    finalize( t );
    if ( acceptor ) {
	acceptor->uAcceptedCall = NULL;			// accepted mutex member terminates
	// raise a concurrent exception at the acceptor
	if ( std::uncaught_exception() && noUserOverride && s.uAlive && uAcceptorSuspended ) {
	    // Return the acceptor only when the acceptor remains suspended and the
	    // mutex object has yet to be destroyed, otherwise return a NULL reference.
	    // Side-effect: prevent the kernel from resuming (_Resume) a concurrent
	    // exception at the suspended acceptor if the rendezvous terminates with an
	    // exception.

	    noUserOverride = false;
	    _Resume uSerial::RendezvousFailure( &s, "accepted call" ) _At *(( s.uAlive && uAcceptorSuspended ) ? acceptor->currCoroutine : NULL);
	} // if
    } // if

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionExit ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterMutexFunctionExit)( uProfiler::uProfilerInstance, s, t );
    } // if

    s.uLeave( mr );
} // uSerialMember::~uSerialMember


uCondition::uCondition() : owner( NULL ) {
} // uCondition::uCondition

uCondition::~uCondition() {
    // A uCondition object must be destroyed before its owner.  Concurrent
    // execution of the destructor for a uCondition and its owner is
    // unacceptable.  The flag owner->uAlive tells if a mutex object is
    // destroyed or not but it cannot protect against concurrent execution.  As
    // long as uCondition objects are declared inside its owner mutex object,
    // the proper order of destruction is guaranteed.

    if ( ! uCondQueue.empty() ) {
	// wake each task blocked on the condition with an async event
	for ( ;; ) {
	    uBaseTaskDL *p = uCondQueue.head();	// get the task blocked at the start of the condition
	  if ( p == NULL ) break;			// list empty ?
	    uEHM::uDeliverAEStack dummy( false );	// block all async exceptions in destructor
	    uBaseTask &t = p->uGet();
	    _Throw WaitingFailure( *this, "found blocked task on condition variable during deletion" ) _At *(t.currCoroutine); // throw async event at blocked task
	    signalBlock();				// restart (signal) the blocked task
	} // for
    } // if
} // uCondition::~uCondition


#ifdef __U_DEBUG__
#define uConditionMsg( operation ) \
    "Attempt to " operation " a condition variable for a mutex object not locked by this task.\n" \
    "Possible cause is accessing the condition variable outside of a mutex member for the mutex object owning the variable."
#endif // __U_DEBUG__


void uCondition::wait() {				// wait on a condition
    uBaseTask &t = uThisTask();				// optimization
    uSerial &s = t.getSerial();

#ifdef __U_DEBUG__
    if ( owner != NULL && &t != owner->uMutexOwner ) {	// must have mutex lock to wait
	uAbort( uConditionMsg( "wait on" ) );
    } // if
#endif // __U_DEBUG__
    if ( owner != &s ) {				// only owner can use condition
	if ( owner == NULL ) {				// owner exist ?
	    owner = &s;					// set condition owner
	} // if
    } // if

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterWait ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterWait)( uProfiler::uProfilerInstance, *this, t, s );
    } // if

    uCondQueue.add( &(t.uMutexRef) );			// add to end of condition queue

    s.uLeave2();					// release mutex and let it schedule another task
    _Enable <uSerial::Failure>;				// implicit poll

    if ( t.uProfileActive && uProfiler::uProfiler_RegisterReady ) { // task registered for profiling ?
	(*uProfiler::uProfiler_RegisterReady)( uProfiler::uProfilerInstance, *this, t, s );
    } // if
} // uCondition::wait

void uCondition::wait( long int info ) {		// wait on a condition with information
    uThisTask().info = info;				// store the information with this task
    wait();						// wait on this condition
} // uCondition::wait


#ifdef __U_DEBUG__
#define uSignalCheck() \
    /* must have mutex lock to signal */ \
    if ( owner != NULL && &t != owner->uMutexOwner ) uAbort( uConditionMsg( "signal" ) );
#endif // __U_DEBUG__


void uCondition::signal() {				// signal a condition
    if ( ! uCondQueue.empty() ) {
	uBaseTask &t = uThisTask();			// optimization
	uSerial &s = t.getSerial();
#ifdef __U_DEBUG__
	uSignalCheck();
#endif // __U_DEBUG__
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterSignal ) { // task registered for profiling ?
	    (*uProfiler::uProfiler_RegisterSignal)( uProfiler::uProfilerInstance, *this, t, s );
	} // if

	s.uAcceptSignalled.add( uCondQueue.drop() );	// move signalled task on top of accept/signalled stack
    } // if
} // uCondition::uS

void uCondition::signalBlock() {			// signal a condition
    if ( ! uCondQueue.empty() ) {
	uBaseTask &t = uThisTask();			// optimization
	uSerial &s = t.getSerial();
#ifdef __U_DEBUG__
	uSignalCheck();
#endif // __U_DEBUG__
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterSignal ) { // task registered for profiling ?
	    (*uProfiler::uProfiler_RegisterSignal)( uProfiler::uProfilerInstance, *this, t, s );
	} // if
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterWait ) { // task registered for profiling ?
	    (*uProfiler::uProfiler_RegisterWait)( uProfiler::uProfilerInstance, *this, t, s );
	} // if

	s.uAcceptSignalled.add( &(t.uMutexRef) );	// suspend signaller task on accept/signalled stack
	s.uAcceptSignalled.addHead( uCondQueue.drop() ); // move signalled task on head of accept/signalled stack
	s.uLeave2();					// release mutex and let it schedule the signalled task

	if ( t.uProfileActive && uProfiler::uProfiler_RegisterReady ) { // task registered for profiling ?
	    (*uProfiler::uProfiler_RegisterReady)( uProfiler::uProfilerInstance, *this, t, s );
	} // if
    } // if
} // uCondition::signalBlock


bool uCondition::empty() const {			// test for tasks on a condition
    return uCondQueue.empty();				// check if the condition queue is empty
} // uCondition::empty

long int uCondition::front() const {			// return task information
#ifdef __U_DEBUG__
    if ( uCondQueue.empty() ) {			// condition queue must not be empty
	uAbort( "Attempt to access user data on an empty condition.\n"
		"Possible cause is not checking if the condition is empty before reading stored data." );
    } // if
#endif // __U_DEBUG__
    return uCondQueue.head()->uGet().info;		// return condition information stored with blocked task
} // uCondition::front


uCondition::WaitingFailure::WaitingFailure( const uCondition &cond, const char *const msg ) : uSerial::Failure( cond.owner, msg ), cond( cond ) {}

uCondition::WaitingFailure::~WaitingFailure() {}

const uCondition &uCondition::WaitingFailure::conditionId() const { return cond; }

void uCondition::WaitingFailure::defaultTerminate() const {
    uAbort( "(uCondition &)0x%p : Waiting failure as task %.256s (0x%p) found blocked task %.256s (0x%p) on condition variable during deletion.",
	    &conditionId(), sourceName(), &source(), uThisTask().getName(), &uThisTask() );
} // uCondition::WaitingFailure::defaultTerminate


//######################### uMain #########################


uMain::uMain( uCluster &cluster, int size, int argc, char *argv[], int &retcode ) :
	uBaseTask( cluster, size ), argc( argc ), argv( argv ), uRetCode( retcode ) {
    // task uMain is always profiled when the profiler is active
    uProfileActivate( *uKernelModule::uTaskBoot );	// make boot task the parent
} // uMain::uMain


uMain::~uMain() {
    if ( uKernelModule::uTaskSystem->pthreadDetach ) {
	uKernelModule::uTaskSystem->pthreadCheck();
    } // if 
} // uMain::~uMain


//######################### uRealPthread #########################


static void *uInterposeSymbol( const char *symbolName, const char *version = NULL ) {
    static void *library;
    char *error;
    void *originalFunc;
    if ( library == NULL ) {
#if defined( RTLD_NEXT )
	library = RTLD_NEXT;
#else
	// missing RTLD_NEXT => must hard-code library name, assuming libstdc++
	library = dlopen( "libstdc++.so", RTLD_LAZY );
	if ( (error = dlerror()) != NULL ) {
	    fprintf( stderr, "uInterposeSymbol : internal error, %s\n", error );
	    exit( -1 );
	} // if
#endif // RTLD_NEXT
    } // if
#if defined( __linux__ )
    if( version == NULL ) {
#endif // __linux__
	originalFunc = dlsym( library, symbolName );
#if defined( __linux__ )
    } else {
	originalFunc = dlvsym( library, symbolName, version );
    } // if
#endif // __linux__
    if ( (error = dlerror()) != NULL ) {
	fprintf( stderr, "uInterposeSymbol : internal error, %s\n", error );
	exit( -1 );
    } // if
    return originalFunc;
} // uInterposeSymbol


#ifdef __U_PTHREAD__

typeof( ::pthread_create ) *uRealPthread::pthread_create;
typeof( ::pthread_attr_init ) *uRealPthread::pthread_attr_init;
typeof( ::pthread_attr_setstack ) *uRealPthread::pthread_attr_setstack;
typeof( ::pthread_self ) *uRealPthread::pthread_self;
typeof( ::pthread_kill ) *uRealPthread::pthread_kill;
typeof( ::pthread_join ) *uRealPthread::pthread_join;

void uRealPthread::startup() {
    char *version = NULL;
#if defined( __linux__ ) && defined( __i386__ )
    version = "GLIBC_2.1";
#endif // __linux__&& __i386__
    pthread_create = (typeof(pthread_create))uInterposeSymbol( "pthread_create", version );
    pthread_attr_init = (typeof(pthread_attr_init))uInterposeSymbol( "pthread_attr_init", version );
    pthread_attr_setstack = (typeof(pthread_attr_setstack))uInterposeSymbol( "pthread_attr_setstack" );
    pthread_self = (typeof(pthread_self))uInterposeSymbol( "pthread_self" );
    pthread_kill = (typeof(pthread_kill))uInterposeSymbol( "pthread_kill" );
    pthread_join = (typeof(pthread_join))uInterposeSymbol( "pthread_join" );
} // uRealPthread::startup

#endif // __U_PTHREAD__


//######################### Kernel Boot #########################


#if defined( __irix__ ) && ! defined( __U_MULTI__ )
void uNullFunc( void *, size_t ) {
    // this function exists only to give the dummy sproc somewhere to go
}
#endif // __irix__ && ! __U_MULTI__


void uKernelBoot::startup() {
    if ( ! uKernelModule::uKernelModuleInitialized ) {
	uKernelModule::startup();
    } // if

#ifdef __U_DEBUG__
    // Force initialization of exception system, which results in dynamic
    // allocations that are not subsequently freed.

    std::uncaught_exception();

    // Storage allocated before the start of uC++ is normally not freed until
    // after uC++ completes (if at all). Hence, this storage is not considered
    // when calculating unfreed storage when the heap's destructor is called in
    // finishup.

    if ( uHeapManager::uHeapManagerInstance == NULL ) {
	uHeapManager::boot();
    } // if
    uHeapManager::PreAlloc = uHeapManager::uHeapManagerInstance->uCheckFree();
#endif // __U_DEBUG__

    // create kernel locks

    uKernelModule::uGlobalAbortLock = new uSpinLock;
    uKernelModule::uGlobalProcessorLock = new uSpinLock;
    uKernelModule::uGlobalClusterLock = new uSpinLock;

#ifdef __U_PTHREAD__
    // must come before any call to uDebugPrt
    uRealPthread::startup();
#endif // __U_PTHREAD__

#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::startup1, uDisableInt:%d, uDisableIntCnt:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ) );
#endif // __U_DEBUG_H__

    // initialize kernel signal handlers

    uSigHandlerModule();

    // create global lists

    uKernelModule::uGlobalProcessors = new uProcessorSeq;
    uKernelModule::uGlobalClusters = new uClusterSeq;

    // SKULLDUGGERY: Initialize the global pointers with the appropriate memory
    // locations and then "new" the cluster and processor. Because the global
    // pointers are initialized, all the references through them in the cluster
    // and processor constructors work out. (HA!)

    uKernelModule::uSystemProcessor = (uProcessor *)&uKernelModule::uSystemProcessorStorage;
    uKernelModule::uSystemCluster = (uCluster *)&uKernelModule::uSystemClusterStorage;
    uKernelModule::uSystemScheduler = new uDefaultScheduler;

#if defined( __irix__ )
#ifdef __U_MULTI__
    // Irix has a default limit of 8 KTs (sprocs) in the default share group.
    // This must be changed *before* the first call to sproc or sprocsp.  There
    // can be at most 10000 in a share group.
    usconfig( CONF_INITUSERS, 256 );
#else // ! __U_MULTI__
    // SKULLDUGGERY: libc only provides locking around standard library functions
    // after sproc has been called.  Since there would otherwise be no calls to
    // sproc in a uniprocessor program, make a dummy call here.  uNullFunc returns
    // immediately, so the sproc created here has a short life.

    // Asking sproc to allocate a stack seems to be an expensive operation.
    #define U_DUMMY_STACK_SIZE 4000
    static char dummy_stack[ U_DUMMY_STACK_SIZE ];
    pid_t pid = sprocsp( uNullFunc, PR_SADDR | PR_SFDS | PR_SUMASK, NULL, dummy_stack + U_DUMMY_STACK_SIZE - 8, U_DUMMY_STACK_SIZE );
    if ( pid == -1 ) {
	uAbort( "uKernelBoot::startup, sprocsp : internal error, error(%d) %s.", errno, strerror( errno ) );
    } // if

    // uProcWait and uSigChldHandler race to wait on the pid for normal
    // termination so the loser ignores the ECHILD.
    int code = waitpid( pid, NULL, 0 );
    if ( code == -1 && errno != ECHILD ) {
	uAbort( "uKernelBoot::startup, waitpid : internal error, error(%d) %s.", errno, strerror( errno ) );
    } // if
#endif // ! __U_MULTI__
#endif // __irix__

    // create system cluster: it is at a fixed address so storing the result is unnecessary.

    new((void *)&uKernelModule::uSystemClusterStorage) uCluster( *uKernelModule::uSystemScheduler, uDefaultStackSize(), "uSystemCluster" );
    new((void *)&uKernelModule::uSystemProcessorStorage) uProcessor( *uKernelModule::uSystemCluster, 1.0 );

#if ! defined( __U_MULTI__ ) || defined( __U_ONETIMER__ )
    uProcessor::uEvents = new uSysEventList;
#endif // ! __U_MULTI__ || __U_ONETIMER__

#ifndef __U_MULTI__
    uProcessor::uContextSwitchHandler = new uCxtSwtchHndlr;
    uProcessor::uContextEvent = new uEventNode( *uProcessor::uContextSwitchHandler );
    uCluster::NBIO = new uNBIO;
#endif // ! __U_MULTI__

    // create processor kernel

    uProcessorKernel *pk = new uProcessorKernel;
    THREAD_SETMEM( uProcessorKernelStorage, pk );

    // set thread register in the new context

#if defined( __U_MULTI__ ) && defined( __U_SWAPCONTEXT__ )
#if defined( __linux__ ) && defined( __i386__ )
#if ! defined( __U_PTHREAD__ )
    ((ucontext_t *)THREAD_GETMEM(uProcessorKernelStorage)->uStorage)->uc_mcontext.gregs[REG_GS] = THREAD_GETMEM( ldtValue );
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __x86_64__ )
#if ! defined( __U_PTHREAD__ )
    #error uC++ : internal error, unsupported architecture
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __ia64__ )
    ((ucontext_t *)THREAD_GETMEM(uProcessorKernelStorage)->uStorage)->uc_mcontext.sc_gr[13] = (unsigned long)THREAD_GETMEM( threadPointer );
#elif defined( __solaris__ ) && defined( __sparc__ ) && ! defined( __U_PTHREAD__ )
    ((ucontext_t *)THREAD_GETMEM(uProcessorKernelStorage)->uStorage)->uc_mcontext.gregs[REG_G7] = (int)(THREAD_GETMEM( uSelf ) );
#elif defined( __irix__ ) && defined( __mips__ )
    // No thread register => nothing needs to be set in the mcontext
#else
    #error uC++ : internal error, unsupported architecture
#endif
#ifdef __U_ONETIMER__
    sigdelset( (sigset_t *)&(((ucontext_t *)THREAD_GETMEM(uProcessorKernelStorage)->uStorage)->uc_sigmask), SIGALRM );
#endif // __U_ONETIMER__
#endif // __U_MULTI__ && __U_SWAPCONTEXT__
#if defined( __U_MULTI__ ) && defined( __U_ONETIMER__ ) && defined( __ia64__ )
    sigdelset( &((uMachContext::uContext_t *)(THREAD_GETMEM(uProcessorKernelStorage)->uStorage))->uSigmask, SIGALRM );
#endif // __U_MULTI__ && __U_ONETIMER__ && __ia64__

    // start boot task, which executes the global constructors and destructors

    uKernelModule::uTaskBoot = new((void *)&uKernelModule::uTaskBootStorage) uBootTask();

    // SKULLDUGGERY: Set the processor's last resumer to the boot task so it
    // returns to it when the processor coroutine terminates. This has to be
    // done explicitly because the kernel coroutine is never resumed only
    // context switched to. Therefore, uLast is never set by resume, and
    // subsequently copied to uStart.

    uActiveProcessorKernel->last = uKernelModule::uTaskBoot;

    // SKULLDUGGERY: Force a context switch to the system processor to set the
    // boot task's context to the current UNIX context. Hence, the boot task
    // does not begin through uInvoke, like all other tasks. It also starts the
    // system processor's companion task so that it is ready to receive
    // processor specific requests. The trick here is that uBootTask is on the
    // ready queue when this call is made. Normally, a task is not on a ready
    // queue when it is running. As result, there has to be a special check in
    // uSchedule to not assert that this task is NOT on a ready queue when it
    // starts the context switch.

    uThisTask().yield();

    // reset filebuf for default streams

    uKernelModule::cerrFilebuf = new std::filebuf( 2, 0 ); // unbufferred
    std::cerr.rdbuf( uKernelModule::cerrFilebuf );
    uKernelModule::clogFilebuf = new std::filebuf( 2 );
    std::clog.rdbuf( uKernelModule::clogFilebuf );
    uKernelModule::coutFilebuf = new std::filebuf( 1 );
    std::cout.rdbuf( uKernelModule::coutFilebuf );
    uKernelModule::cinFilebuf  = new std::filebuf( 0 );
    std::cin.rdbuf( uKernelModule::cinFilebuf );

    // create system task

    uKernelModule::uTaskSystem = new uSystemTask();


    // THE SYSTEM IS NOW COMPLETELY RUNNING


    // Obtain the addresses of the original set_terminate and set_unexpected
    // using the dynamic loader. Use the original versions to initialize the
    // hidden variables holding the terminate and unexpected routines. All
    // other references to set_terminate and set_unexpected refer to the uC++
    // ones.

    std::terminate_handler (*orig_set_terminate)( std::terminate_handler );
    orig_set_terminate = (std::terminate_handler (*)(std::terminate_handler))uInterposeSymbol( "_ZSt13set_terminatePFvvE" );
    orig_set_terminate( uEHM::uTerminateHandler );

    std::unexpected_handler (*orig_set_unexpected)( std::unexpected_handler );
    orig_set_unexpected = (std::unexpected_handler (*)(std::unexpected_handler))uInterposeSymbol( "_ZSt14set_unexpectedPFvvE" );
    orig_set_unexpected( uEHM::uUnexpectedHandler );

    // create user cluster

    uKernelModule::uUserCluster = new uCluster( "uUserCluster" );

    // create user processor

    uKernelModule::uUserProcessor = new uProcessor( *uKernelModule::uUserCluster );

    // uOwnerLock has a runtime check testing if locking is attempted from
    // inside the kernel. This check only applies once the system becomes
    // concurrent. During the previous boot-strapping code, some locks may be
    // invoked (and hence a runtime check would occur) but the system is not
    // concurrent. Hence, these locks are always open and no blocking can
    // occur. This flag enables uOwnerLock checking after this point.

    uKernelModule::uInitialization = true;

#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::startup2, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ), uThisProcessor().getPreemption() );
#endif // __U_DEBUG_H__

    uKernelModule::uTaskBoot->migrate( *uKernelModule::uUserCluster );

#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::startup3, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ), uThisProcessor().
#endif // __U_DEBUG_H__
} // uKernelBoot::startup


void uKernelBoot::finishup() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::finishup1, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ), uThisProcessor().getPreemption() );
#endif // __U_DEBUG_H__

    uKernelModule::uTaskBoot->migrate( *uKernelModule::uSystemCluster );

#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::finishup2, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ), uThisProcessor().getPreemption() );
#endif // __U_DEBUG_H__

    delete uKernelModule::uUserProcessor;
    delete uKernelModule::uUserCluster;

    delete uKernelModule::uTaskSystem;

    // Flush standard output streams as required by 27.4.2.1.6

    delete uKernelModule::cinFilebuf;
    std::cout.flush();
    std::cout.rdbuf( NULL );
    delete uKernelModule::coutFilebuf;
    std::clog.flush();
    std::clog.rdbuf( NULL );
    delete uKernelModule::clogFilebuf;
    std::cerr.flush();
    std::cerr.rdbuf( NULL );
    delete uKernelModule::cerrFilebuf;

    // Turn off uOwnerLock checking.

    uKernelModule::uInitialization = false;

    THREAD_GETMEM( uSelf )->disableInterrupts();
    uThisProcessor().uSetContextSwitchEvent( 0 );	// clear the alarm on this processor
    THREAD_GETMEM( uSelf )->enableInterrupts();

#ifndef __U_MULTI__
    delete uCluster::NBIO;
    delete uProcessor::uContextEvent;
    delete uProcessor::uContextSwitchHandler;
#endif // ! __U_MULTI__

#if ! defined( __U_MULTI__ ) || defined( __U_ONETIMER__ )
    delete uProcessor::uEvents;
#endif //  ! __U_MULTI__ || __U_ONETIMER_

    // SKULLDUGGERY: The termination order for the boot task is different from
    // the starting order. This results from the fact that the boot task must
    // have a processor before it can start. However, the system processor must
    // have the thread from the boot task to terminate. Deleting the cluster
    // first requires that the boot task be removed first from the list of
    // tasks on the cluster or the cluster complains about unfinished
    // tasks. The boot task must be added again before its deletion because it
    // removes itself from the list. Also, when the boot task is being deleted
    // it is using the *already* deleted system cluster, which works only
    // because the system cluster storage is not dynamically allocated so the
    // storage is not scrubbed; therefore, it still has the necessary state
    // values to allow the boot task to be deleted. As well, the ready queue
    // has to be allocated spearately from the system cluster so it can be
    // deleted *after* the boot task is deleted because the boot task access
    // the ready queue during its deletion.

    // remove the boot task so the cluster does not complain
    uKernelModule::uSystemCluster->uTaskRemove( *(uBaseTask *)uKernelModule::uTaskBoot );

    // remove system processor, processor task and cluster
    uKernelModule::uSystemProcessor->uProcessor::~uProcessor();
    uKernelModule::uSystemCluster->uCluster::~uCluster();

    // remove processor kernal coroutine with execution still pending
    delete THREAD_GETMEM( uProcessorKernelStorage );

    // add the boot task back so it can remove itself from the list
    uKernelModule::uSystemCluster->uTaskAdd( *(uBaseTask *)uKernelModule::uTaskBoot );
    ((uBootTask *)uKernelModule::uTaskBoot)->uBootTask::~uBootTask();

    // Clean up storage associated with the boot task by pthread-like
    // thread-specific data (see ~uTaskMain). Must occur *after* all calls that
    // might call std::uncaught_exception, otherwise the exception
    // data-structures are created again for the task. (Note: ~uSerialX members
    // call std::uncaught_exception).

    if ( ((uBootTask *)uKernelModule::uTaskBoot)->pthreadData != NULL ) {
	_pthread_deletespecific( ((uBootTask *)uKernelModule::uTaskBoot)->pthreadData );
    } // if

    // Clean up storage associated with pthread pid table (if any).

    _pthread_pid_destroy();

    // no tasks on the ready queue so it can be deleted
    delete uKernelModule::uSystemScheduler;

#ifdef __U_DEBUG_H__
    uDebugPrt( "uKernelBoot::finishup3, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       THREAD_GETMEM( uDisableInt ), THREAD_GETMEM( uDisableIntCnt ), uThisProcessor().getPreemption() );
#endif // __U_DEBUG_H__

    delete uKernelModule::uGlobalClusters;
    delete uKernelModule::uGlobalProcessors;

    delete uKernelModule::uGlobalClusterLock;
    delete uKernelModule::uGlobalProcessorLock;
    delete uKernelModule::uGlobalAbortLock;

    // Explicitly invoking the destructor does not close down the heap because
    // it might still be used before the application terminates. The heap's
    // destructor does check for unreleased storage at this point. (The
    // constructor for the heap is called on the first call to malloc.)

    uHeapManager::uHeapManagerInstance->uHeapManager::~uHeapManager();
} // uKernelBoot::finishup


// Local Variables: //
// compile-command: "gmake install" //
// End: //
