//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.cc -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Jan  4 17:34:00 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Dec  3 08:33:38 2005
// Update Count     : 211
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>


//######################### uEventNode #########################


uEventNode::uEventNode( uBaseTask &t, uSignalHandler &sig, uTime tT, uDuration tD, uProcessor *p ) {
    timerT = tT;
    timerD = tD;
    SigHandler = &sig;
    uWho = &t;
    uExecuteLocked = false;
    proc = p;
    activeProc = NULL;
} // uEventNode::uEventNode


uEventNode::uEventNode( uSignalHandler &sig, uProcessor *p ) {
    timerT = 0;
    timerD = 0;
    SigHandler = &sig;
    uWho = NULL;
    uExecuteLocked = false;
    proc = p;
    activeProc = NULL;
} // uEventNode::uEventNode


uEventNode::uEventNode( uProcessor *p ) {
    timerT = 0;
    timerD = 0;
    SigHandler = NULL;
    uWho = NULL;
    uExecuteLocked = false;
    proc = p;
    activeProc = NULL;
} // uEventNode::uEventNode


void uEventNode::add( bool block ) {
    if ( proc == NULL ) {
	activeProc = &uThisProcessor();
	activeProc->uEvents->addEvent( *this, *activeProc, block );
    } else {
	activeProc = proc;
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	proc->uProcEvents->addEvent( *this, *proc, block );
#else
	proc->uEvents->addEvent( *this, *proc, block );
#endif // __U_ONETIMER__ && __U_MULTI__
    } // if
} // uEventNode::add


void uEventNode::remove() {
    if ( proc == NULL ) {
	activeProc->uEvents->removeEvent( *this, *activeProc );
    } else {
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	activeProc->uProcEvents->removeEvent( *this, *activeProc );
#else
	activeProc->uEvents->removeEvent( *this, *activeProc );
#endif // __U_ONETIMER__ && __U_MULTI__
    } // if
    activeProc = NULL;
} // uEventNode::remove


void uEventNode::setProcessor( uProcessor *p ) {
    if ( activeProc != NULL ) {
	uAbort( "(uEventNode &)0x%p.setProcessor() : internal error, attempt to set processor for an active event.", this );
    } // if
    proc = p;
} // uEventNode::setProcessor


//######################### uEventList #########################


void *uEventList::operator new( size_t, void *storage ) {
    return storage;
} // uEventList::operator new

void *uEventList::operator new( size_t size ) {
    return ::operator new( size );
} // uEventList::operator new


void uEventList::addEvent( uEventNode &newAlarm, uProcessor &processor, bool block ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventList &)0x%p.addEvent, newAlarm:0x%p, processor:0x%p\n", this, &newAlarm, &processor );
#endif // __U_DEBUG_H__
    acquireEventLock();

    uSeqIter<uEventNode> iter(uL);
    uEventNode *node, *prev = NULL;
    int i;

    for ( i = 0; iter >> node && node->timerT <= newAlarm.timerT; prev = node, i += 1 );

    uL.insertBef( &newAlarm, node );			// insert in list

    if ( i == 0 ) {					// insert at the front ?
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	if ( this == uThisProcessor().uEvents ) {	// same processor as event list ?
#endif // ! __U_ONETIMER__ && __U_MULTI__
	    setTimer( newAlarm.timerT );		// reset alarm
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	} else {
	    uThisCluster().uWakeProcessor( processor.getPid() );
	} // if
#endif // ! __U_ONETIMER__ && __U_MULTI__
    } // if

    if ( block ) {
	uSCHEDULE( &uEventLock );
    } else {
	releaseEventLock();
    } // if
} // uEventList::addEvent


// No yield after a removeEvent. This is handled by whatever code calls
// removeEvent.

void uEventList::removeEvent( uEventNode &oldNode, uProcessor &processor ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventList &)0x%p.removeEvent, newAlarm:0x%p, processor:0x%p\n", this, &oldNode, &processor );
#endif // __U_DEBUG_H__
    acquireEventLock();

    uEventNode *headNode;

    if ( ! oldNode.listed() ) {			// node already removed ?
	releaseEventLock();
	return;
    } // if
    headNode = uL.head();
    uL.remove( &oldNode );

    if ( headNode == &oldNode ) {			// removing at head ?  reset alarm
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	if ( this == uThisProcessor().uEvents ) {	// same processor as event list ?
#endif // ! __U_ONETIMER__ && __U_MULTI__
	    headNode = uL.head();
	    if ( ! headNode ) {				// list empty ?
		setTimer( uDuration( 0 ) );		// cancel alarm
	    } else {
		setTimer( headNode->timerT );		// reset alarm
	    } // if
#if ! defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
	} else {
	    uThisCluster().uWakeProcessor( processor.getPid() ); // send SIGALRM to reset alarm on other processor
	} // if
#endif // ! __U_ONETIMER__ && __U_MULTI__
    } // if
    releaseEventLock();
} // uEventList::removeEvent


uEventNode *uEventList::uNextEvent( ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "uEventList::uNextEvent\n" );
#endif // __U_DEBUG_H__

    uEventList *uEL;

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    uProcessor *p = &uThisProcessor();
    if ( p == uKernelModule::uSystemProcessor ) {
	uEL = uProcessor::uEvents;
    } else {
	uEL = p->uProcEvents;
    } // if
#else
    uEL = uThisProcessor().uEvents;
#endif // __U_ONETIMER__ && __U_MULTI__
    uEL->acquireEventLock();

    uEventNode *noder;
    uSeqIter<uEventNode> iter( uEL->uL );

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    if ( p == uKernelModule::uSystemProcessor ) {
	// loop executes at most 2 iterations
	for ( ; iter >> noder && noder == &uThisProcessor().uProcEvents->wakeupEvent; );
	if ( noder == NULL ) {
	    uEL->releaseEventLock();
	    uEL = p->uProcEvents;
	    uEL->acquireEventLock();
	    iter.over( uEL->uL );
	} // if
    } // if
    if ( p != uKernelModule::uSystemProcessor || noder == NULL ) {
#endif // __U_ONETIMER__ && __U_MULTI__
	// loop executes at most 2 iterations
	for ( ; iter >> noder && noder->SigHandler == (uSignalHandler *)(uThisProcessor().uContextSwitchHandler); );
#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    } // if
#endif // __U_ONETIMER__ && __U_MULTI__

    uEL->releaseEventLock();

    return noder;
} // uEventList::uNextEvent


uTime uEventList::uNextAlarm( ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "uEventList::uNextAlarm\n" );
#endif // __U_DEBUG_H__
    uEventNode *noder = uNextEvent();

    if ( noder ) {
	return noder->timerT;
    } else {
	return uTime( 0L );
    } // if
} // uEventList::uNextAlarm


void uEventList::acquireEventLock() {
    uEventLock.acquire();
} // uEventList::acquireEventLock

void uEventList::releaseEventLock() {
    uEventLock.release();
} // uEventList::releaseEventLock

void uEventList::acquireEventLockNoRF() {
    uEventLock.acquireNoRF();
} // uEventList::acquireEventLockNoRF

void uEventList::releaseEventLockNoRF() {
    uEventLock.releaseNoRF();
} // uEventList::releaseEventLockNoRF


#ifndef __U_MULTI__
bool uEventList::uUserEventPresent() {
    acquireEventLock();

    uEventNode *noder;
    uSeqIter<uEventNode> iter(uL);

    // loop executes at most 3 iterations
    for ( ; iter >> noder && ( (uSignalHandler *)(uThisProcessor().uContextSwitchHandler) == noder->SigHandler // ignore context switch events
			     || noder->uWho == (uBaseTask *)uKernelModule::uTaskSystem );		      // ignore system task
	 );
    releaseEventLock();

    return noder != NULL;
} // uEventList::uUserEventPresent
#endif // ! __U_MULTI__


void uEventList::setTimer( uTime time ) {
  if ( time == 0 ) return;				// if time is zero, it's invalid

    // Since this is private, and only uSysEventList is a friend, the assumption
    // is made that the time parameter is always in real-time (not virtual
    // time)

#if defined( REALTIME_POSIX )
    timespec curr;
    if ( clocktype < 0 ) type = CLOCK_REALTIME;
    clock_gettime( type, &curr );
#else
    timeval curr;
    GETTIMEOFDAY( &curr );
#endif // REALTIME_POSIX
    uTime currtime( curr.tv_sec, curr.tv_usec * 1000 );	// convert to nanoseconds

    uDuration dur = time - currtime;
    if ( dur <= 0 ) {					// if duration is negative (it has already past)
	// fill in the value to the next expiry by setting alarm to soonest
	// time an alarm may come
	setTimer( uDuration( 0, TIMEGRAN / 1000000L ) );
    } else {
	setTimer( dur );
    } // if
} // uEventList::setTimer


//######################### uSysEventList #########################


void uSysEventList::setTimer( uDuration dur ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uSysEventList &)0x%p.setTimer, duration %lld\n", this, dur.nanoseconds() );
#endif // __U_DEBUG_H__
    uActiveProcessorKernel->uSetTimer( dur );
} // uSysEventList::setTimer


#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
//######################### uProcWakeupHndlr #########################


uProcWakeupHndlr::uProcWakeupHndlr( uProcessor &proc ) : proc( proc ) {
} // uProcWakeupHndlr::uProcWakeupHndlr


void uProcWakeupHndlr::uHandler() {
    if ( &proc == &uThisProcessor() ) return;

#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uProcWakeupHndlr &)0x%p.uHandler: waking processor %lu\n", this, (unsigned long)proc.getPid() );
#endif // __U_DEBUG_H__

    uCluster::uWakeProcessor( proc.getPid() );
} // uProcWakeupHndlr::uHandler


//######################### uProcEventList #########################


uProcEventList::uProcEventList( uProcessor &proc ) : procWakeupHandler( proc ), wakeupEvent( procWakeupHandler ) {
} // uProcEventList::uProcEventList


void uProcEventList::setTimer( uDuration duration ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uProcEventList &)0x%p.setTimer, duration %lld\n", this, duration.nanoseconds() );
#endif // __U_DEBUG_H__
    uTime wakeupTime = uActiveProcessorKernel->uKernelClock.getTime() + duration;
    if ( ! wakeupEvent.listed() && duration != 0 ) { // first wakekup event ?
	wakeupEvent.timerT = wakeupTime;
	uProcessor::uEvents->addEvent( wakeupEvent );
    } else if ( duration > 0  && wakeupEvent.timerT != wakeupTime ) { // if event is different from previous ? change it
	uProcessor::uEvents->removeEvent( wakeupEvent );
	wakeupEvent.timerT = wakeupTime;
	uProcessor::uEvents->addEvent( wakeupEvent );
    } else if ( duration == 0 && wakeupEvent.timerT != 0 ) { // zero duration and current wakekup is nonzero ?
	uProcessor::uEvents->removeEvent( wakeupEvent );
	wakeupEvent.timerT = 0;   
    } // if
} // uProcEventList::setTimer
#endif // __U_ONETIMER__ && __U_MULTI__


//######################### uEventListPop #########################


uEventListPop::uEventListPop( uEventList &e, bool inKernel ) : uEL( &e ), uInKernel( inKernel ) {
    THREAD_SETMEM( InKernelRF, 1 );			// detect if subsequent interrupts occur
    curTime = uActiveProcessorKernel->uKernelClock.getTime();
    uCxtSwHandler = NULL;
} // uEventListPop::uEventListPop

uEventListPop::~uEventListPop() {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.~uEventListPop\n", this );
#endif // __U_DEBUG_H__
    uSignalHandler *hndlr;
    for ( uQueueIter<uSignalHandler> iter( deferredEvents ); iter >> hndlr; ) {
#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>> process deferred handler 0x%p\n", this, hndlr );
#endif // __U_DEBUG_H__
	hndlr->uHandler();
	deferredEvents.remove( hndlr );
    } // for

    uEL->acquireEventLockNoRF();
    // only reset the roll forward flag if no other interrupts occurred during
    // roll forward
    if ( THREAD_GETMEM( InKernelRF ) == 1 ) {
	THREAD_SETMEM( InKernelRF, 0 );
    } // if

    if ( ! uEL->uL.empty() ) {
	uEL->setTimer( uEL->uL.head()->timerT );
    } // if
    uEL->releaseEventLock();

    if ( ! uInKernel ) {				// not in kernel ?
	if ( uCxtSwHandler ) {				// context-switch event ?
	    uCxtSwHandler->uHandler();			// should do a yield
	} else {
	    // Force a reschedule as a higher priority task may have become
	    // ready and is now at the front of the ready queue. Note,
	    // rescheduling can occur even if a lower priority task unblocks.
	    // As a side effect, if the current task has the same priority as
	    // the task on the front of the ready queue, the current task is
	    // preempted even if it has only just started execution.

	    uThisTask().uYieldInvoluntary();
	} // if
    } else {
	// roll-forward is only called from the kernel, after waking up from
	// sleeping, or an alarm occurred while in the process of going to
	// sleep.  Therefore, yielding is unnecessary, if going to sleep (or
	// have slept).  There were no tasks to execute or context switch from
	// in the first place.

	// A preemption event may be ignored because a reschedule is just about
	// to occur, anyway, when the kernel reschedules the next task.
    } // if
} // uEventListPop::~uEventListPop

void uEventListPop::over( uEventList &e, bool inKernel ) {
    uEL = &e;
    uInKernel = inKernel;
    curTime = uActiveProcessorKernel->uKernelClock.getTime();
    uCxtSwHandler = NULL;
} // uEventListPop::over

bool uEventListPop::operator>>( uEventNode *&node ) {
#ifdef __U_DEBUG_H__
    char buf[1024];
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>>, event list 0x%p\n", this, uEL );
#endif // __U_DEBUG_H__
    uEL->acquireEventLockNoRF();

    node = uEL->uL.head();				// get event at the start of the list with the shortest time delay

#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>>, node:0x%p\n", this, node );
#endif // __U_DEBUG_H__
  if ( ! node ) {					// no events ?
	uEL->releaseEventLockNoRF();
	return false;
    } // if

  if ( node->timerT > curTime ) {			// event time delay greater than the start time for the iteration
	uEL->releaseEventLockNoRF();
	return false;
    } // if

    uEL->uL.remove( node );

    // Now see if the popped event is periodic.  If it is, insert another event
    // for next period.

    if ( node->timerD != 0 ) {
	node->timerT = curTime + node->timerD;		// Reset timerT value in clock object
	uSeqIter<uEventNode> i( uEL->uL );
	uEventNode *prev;
	uEventNode *noder;

	// May have to order identical timed elements by priority (to keep up
	// the real-time spirit)

	for ( prev = NULL; i >> noder && noder->timerT <= node->timerT; prev = noder );

	uEL->uL.insertBef( node, noder );		// insert into list
    } // if

#if defined( __U_ONETIMER__ ) && defined( __U_MULTI__ )
    if ( dynamic_cast<uProcWakeupHndlr *>( node->SigHandler ) != NULL ) {
#ifdef __U_DEBUG_H__
	uDebugPrtBuf( buf, "(uEventListPop &)0x%p.>> defer event 0x%p handler 0x%p\n", this, node, node->SigHandler );
#endif // __U_DEBUG_H__
	deferredEvents.add( node->SigHandler );		// save for last
	uEL->releaseEventLockNoRF();
    } else
#endif // __U_ONETIMER__ && __U_MULTI__
    if ( node->SigHandler == (uSignalHandler *)(uThisProcessor().uContextSwitchHandler) ) {
	uCxtSwHandler = node->SigHandler;		// remember the context switch event
	uEL->releaseEventLockNoRF();
    } else {                                            // not a ContextSwitch event
	if ( node->uExecuteLocked ) {			// should handler be called with lock
	    node->SigHandler->uHandler();		// invoke the handler code for the event
	    uEL->releaseEventLockNoRF();
	} else {
	    uEL->releaseEventLockNoRF();
	    node->SigHandler->uHandler();		// invoke the handler code for the event
	} // if
    } // if

    return true;
} // uEventListPop::operator>>


// Local Variables: //
// compile-command: "gmake install" //
// End: //
