/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997->2006 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Version: 2.4 -  Oct 2006
 */

/*
 * Globals for help find
 */

//#ifndef TWLOG_H_INCLUDED
#include "twlog.h"
//#endif
#include "twlogHelp.h"

#define FIND_AGN     0
#define THIS_SECTION 1
#define ALL_SECTIONS 2


char pattern[41];               /* pattern for help find */
Widget helpTxt, findAgnPB, topicLabel;
int sec;
char *found;

/*
 * popupHelp Function
 * Created the first time it is called and then managed as needed.  
 * Use the button number to index to the right help section.
 * Set for modeless so main interface is still active.
 */
void popupHelp (int topicNum)
{
   int i;
   static Widget helpDiag, pbform, sep, findPB, closePB;
   XmString xs;
   Arg args[20];

   if (helpDiag == NULL)
   {
      helpDiag = XmCreateFormDialog (logSH, "helpDiag", NULL, 0);

      XtVaSetValues (helpDiag,
        XmNdialogStyle, XmDIALOG_MODELESS,
        NULL);

      XtVaSetValues (XtParent (helpDiag),       /* set title bar */
         XmNtitle, "TWLOG HELP",
         NULL);

      topicLabel = XtVaCreateManagedWidget ("topicLabel", xmLabelWidgetClass,
         helpDiag,
         XmNtopAttachment, XmATTACH_FORM,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_NONE,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);

      pbform = XtVaCreateWidget ("pbrc", xmFormWidgetClass, helpDiag,
         XmNwidth, 500,
         XmNtopAttachment, XmATTACH_NONE,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNrightAttachment, XmATTACH_FORM,
         NULL);

      findPB =
         XtVaCreateManagedWidget ("Find", xmPushButtonWidgetClass, pbform,
         XmNwidth, PBWIDTH, XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 10, XmNrightAttachment, XmATTACH_POSITION,
         XmNrightPosition, 20, 
         NULL);

      findAgnPB = XtVaCreateManagedWidget ("Find Again",
         xmPushButtonWidgetClass, pbform,
         XmNsensitive, False,
         XmNwidth, PBWIDTH,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 50, XmNleftOffset, -PBWIDTH / 2,
         NULL);

      closePB = XtVaCreateManagedWidget ("Close",
         xmPushButtonWidgetClass, pbform,
         XmNwidth, PBWIDTH,
         XmNleftAttachment, XmATTACH_POSITION,
         XmNleftPosition, 80,
         XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 90,
         NULL);

      XtManageChild (pbform);

      sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass, helpDiag,
         XmNtopAttachment, XmATTACH_NONE,
         XmNleftAttachment, XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_WIDGET,
         XmNbottomWidget, pbform, XmNrightAttachment, XmATTACH_FORM,
         NULL);

      i = 0;
      XtSetArg (args[i], XmNrows, 12);
      i++;
      XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT);
      i++;
      XtSetArg (args[i], XmNeditable, False);
      i++;
      XtSetArg (args[i], XmNscrollHorizontal, False);
      i++;
      XtSetArg (args[i], XmNwordWrap, True);
      i++;
      XtSetArg (args[i], XmNtopAttachment, XmATTACH_WIDGET);
      i++;
      XtSetArg (args[i], XmNtopWidget, topicLabel);
      i++;
      XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM);
      i++;
      XtSetArg (args[i], XmNbottomAttachment, XmATTACH_WIDGET);
      i++;
      XtSetArg (args[i], XmNbottomWidget, sep);
      i++;
      XtSetArg (args[i], XmNrightAttachment, XmATTACH_FORM);
      i++;

      helpTxt = XmCreateScrolledText (helpDiag, "helpTxt", args, i);

      /* "Find" button callback */
      XtAddCallback (findPB, XmNactivateCallback, popupFindCB,
         XtParent (helpDiag));

      /* "Find Agn" button callback */
      XtAddCallback (findAgnPB, XmNactivateCallback, doFindCB,
         (XtPointer) FIND_AGN);

      /* "Cancel" button callback */
      XtAddCallback (closePB, XmNactivateCallback, popdownCB, helpDiag);

      XtManageChild (helpTxt);
   }

   /* Load the Help window label and text */
   xs = XmStringCreateLtoR (helpTopics[topicNum], XmFONTLIST_DEFAULT_TAG);
   XtVaSetValues (topicLabel,
      XmNlabelString, xs,
      NULL);
   XmStringFree (xs);

   /* save the section number and load the text wid with help */
   sec = topicNum;
   XtVaSetValues (helpTxt,
      XmNvalue, helpText[topicNum],
      NULL);

   /* New find operation so... */
   strcpy (pattern, "");

   XtManageChild (helpDiag);    /* pop it up */
}


/*
 * popdownCB - popdown the help window
 */
void popdownCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   XtVaSetValues (findAgnPB,
      XmNsensitive, False,
      NULL);

   XtUnmanageChild ((Widget) cdata);
}


/*
 * popupFindCB - popup the prompt dialog - The OK button and Apply buttons
 * are renamed "This Section" and "All Sections".
 */
void popupFindCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   int i, j;
   static Widget promptDiag;
   XmString xms[3];

   if (promptDiag == NULL)
   {
      promptDiag = XmCreatePromptDialog (cdata, "findPromptDiag", NULL, 0);

      /* set title bar to "TWLOG HELP" */
      XtVaSetValues (XtParent (promptDiag),
         XmNtitle, "TWLOG HELP",
         XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
         NULL);

      /*
       * Unmanage the Help button and Manage the Apply button
       * Change there labels to "This Section" and "All Sections"
       */
      XtUnmanageChild (XmSelectionBoxGetChild (promptDiag,
            XmDIALOG_HELP_BUTTON));
      XtManageChild (XmSelectionBoxGetChild (promptDiag,
            XmDIALOG_APPLY_BUTTON));

      /* Change the OK and APPLY button label to "This Section" */
      i = 0;
      xms[i] = XmStringCreateLocalized ("This Section");
      i++;
      xms[i] = XmStringCreateLocalized ("All Sections");
      i++;
      xms[i] = XmStringCreateLocalized ("Enter Search String");
      i++;

      XtVaSetValues (promptDiag,
         XmNokLabelString, xms[0],
         XmNapplyLabelString, xms[1],
         XmNselectionLabelString, xms[2],
         NULL);

      for (j = 0; j < i; j++)
      {
         XmStringFree (xms[j]);
      }

      /* "This Section" PB callback */
      XtAddCallback (promptDiag, XmNokCallback, doFindCB,
         (XtPointer) THIS_SECTION);

      /* "All Sections" PB callback */
      XtAddCallback (promptDiag, XmNapplyCallback, doFindCB,
         (XtPointer) ALL_SECTIONS);
   }

   /* New find, so clear any highlights */
   XmTextSetHighlight (helpTxt, 0, strlen (helpText[sec]),
      XmHIGHLIGHT_NORMAL);
   XtManageChild (promptDiag);
}

/*
 * doFindCB - find a pattern within the help text
 */
void doFindCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   char *pat;
   static int flag, start, start_sec, gotone;
   XmString xs;

   if ((int) cdata == THIS_SECTION || (int) cdata == ALL_SECTIONS)
   {
      flag = (int) cdata;       /* save THIS or ALL */
      start = 0;
      start_sec = sec;
      gotone = False;
      /* Get the find text and then clear the text box */
      XtVaGetValues (XmSelectionBoxGetChild (w, XmDIALOG_TEXT),
         XmNvalue, &pat,
         NULL);
      strncpy (pattern, pat, 40);

      /* try removing this */
      XtVaSetValues (XmSelectionBoxGetChild (w, XmDIALOG_TEXT),
         XmNvalue, "",
         NULL);

      /* Since we have find text, then findAgn is valid */
      XtVaSetValues (findAgnPB,
         XmNsensitive, True,
         NULL);
      XtFree (pat);
      XtUnmanageChild (w);      /* apply btn/all section button? */
   }

   /* Try to find it */
   if ((found = findNoCase (helpText[sec] + start, pattern)) != NULL)
   {                            /* found it */
      gotone = True;
      start = found - &helpText[sec][0];

      XmTextSetHighlight (helpTxt, start,
         start + strlen (pattern), XmHIGHLIGHT_SELECTED);

      XmTextShowPosition (helpTxt, start);

      /* Update stuff */
      start = start + strlen (pattern);
      return;
   }
   else                         /* didnt find it */
   {
      start = 0;
      /* Should we go to next section? */
      if (flag == THIS_SECTION) /* if this section only */
      {
         noMatchDiag ();
         return;
      }
      else
      {
         sec++;
         if (sec >= NUM_TOPICS)
         {
            sec = 1;
         }

         /* Load the Help window label and text */
         xs = XmStringCreateLtoR (helpTopics[sec], XmFONTLIST_DEFAULT_TAG);
         XtVaSetValues (topicLabel,
            XmNlabelString, xs,
            NULL);
         XmStringFree (xs);

         /* Load the next section to the text widget */
         XtVaSetValues (helpTxt,
            XmNvalue, helpText[sec],
            NULL);

         if (sec == start_sec)
         {
            noMatchDiag ();
            return;
         }
         doFindCB (w, FIND_AGN, cbs);
      }
   }
}

/*
 * noMatch Dialog
 */
void noMatchDiag ()
{
   XmString xs;
   Arg args[1];
   static Widget noMatchDiag;

   if (noMatchDiag == NULL)
   {
      xs = XmStringCreateLocalized ("String Not Found");

      XtSetArg (args[0], XmNmessageString, xs);
      noMatchDiag = XmCreateInformationDialog (helpTxt, "noMatchDiag",
         args, 1);
      XmStringFree (xs);

      XtUnmanageChild (XmMessageBoxGetChild (noMatchDiag,
            XmDIALOG_HELP_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (noMatchDiag,
            XmDIALOG_CANCEL_BUTTON));

      XtVaSetValues (XtParent (noMatchDiag),    /* set title bar */
         XmNtitle, "TWLOG HELP",
         NULL);
   }

   XtVaSetValues (findAgnPB,
      XmNsensitive, False,
      NULL);

   XtManageChild (noMatchDiag);
   return;
}


/*
 * find no case
 */
char * findNoCase (char *text, char *pattern)
{
   char c, sc;
   int len;

   if ((c = *pattern++) != 0)
   {
      c = tolower (c);
      len = strlen (pattern);
      do
      {
         do
         {
            if ((sc = *text++) == 0)
               return NULL;
         }
         while (tolower (sc) != c);
      }
      while (strncasecmp (text, pattern, len) != 0);
      text--;
   }
   return (char *) text;
}
