/* tbacklight.c -- turn the LCD backlight on/off in a Toshiba laptop.
 *
 * Copyright (c) 1996-2001  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log: tbacklight.c,v $
 * Revision 1.1  2001/02/02 17:11:14  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

static char const rcsid[]="$Id: tbacklight.c,v 1.1 2001/02/02 17:11:14 jab Exp jab $";


#include<stdio.h>

#include"hci.h"
#include"sci.h"


void BacklightOn(void)
{
	SMMRegisters reg;

	reg.eax = HCI_SET;
	reg.ebx = HCI_BACKLIGHT;
	reg.ecx = HCI_ENABLE;
	HciFunction(&reg);

	return;
}


void BacklightOff(void)
{
	SMMRegisters reg;

	reg.eax = HCI_SET;
	reg.ebx = HCI_BACKLIGHT;
	reg.ecx = HCI_DISABLE;
	HciFunction(&reg);

	return;
}


int main(int argc, char *argv[])
{
	int version;

	/* is this a supported machine? */

	if (SciSupportCheck(&version)==SCI_FAILURE) {
		fprintf(stderr, "tbacklight: this computer is not supported "
			"or the kernel module is not installed.\n");
		return 1;
	}

	/* process command line arguments */

	if (argc>1) {
		if (!strcmp(argv[1], "-n") || !strcmp(argv[1], "--on")) {
			BacklightOn();
		} else if (!strcmp(argv[1], "-f") || !strcmp(argv[1], "--off")) {
			BacklightOff();
		} else {
			fprintf(stderr, "tbacklight: illegal option %s\n"
				"Usage: tbacklight [-n|f]\n", argv[0]);
			return 1;
		}
	}

	return 0;
}
