// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_SOLVE_INC
#define MX_SOLVE_INC

#include "Mat.h"
#include "Vec.h"

namespace Torch {

/*  Collection of factorisations functions.
    Based on the "Meschach Library", available at the
    anonymous ftp site thrain.anu.edu.au in the directory
    pub/meschach.

    @author David E. Stewart (david.stewart@anu.edu.au)
    @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/

/* Back substitution with optional over-riding diagonal.
    Can be in-situ but doesn't need to be. */
void mxUSolve(Mat * matrix, Vec * b, Vec * out, real diag);

// Forward elimination with (optional) default diagonal value.
void mxLSolve(Mat * matrix, Vec * b, Vec * out, real diag);

/* Forward elimination with (optional) default diagonal value.
    Use UPPER triangular part of matrix. */
void mxUTSolve(Mat * mat, Vec * b, Vec * out, real diag);

/* Solves Dx=b where D is the diagonal of A.
    May be in-situ. */
void mxDSolve(Mat * mat, Vec * b, Vec * x);

/* Back substitution with optional over-riding diagonal.
   Use the LOWER triangular part of matrix.
   Can be in-situ but doesn't need to be. */
void mxLTSolve(Mat * mat, Vec * b, Vec * out, real diag);


}

#endif
