// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_HESSENBERG_INC
#define MX_HESSENBERG_INC

#include "Mat.h"
#include "Vec.h"

namespace Torch {

/**
   Routines for determining Hessenberg factorisations.
   
   Based on the "Meschach Library", available at the
   anonymous ftp site thrain.anu.edu.au in the directory
   pub/meschach.
   
   @author David E. Stewart (david.stewart@anu.edu.au)
   @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
   @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{

/** Compute Hessenberg factorisation in compact form.
   Factorisation performed in situ.
*/
void mxHFactor(Mat * mat, Vec * diag, Vec * beta);


/** Construct the Hessenberg orthogonalising matrix Q.
    i.e. Hess M = Q.M.Q'.
*/
void mxMakeHQ(Mat * h_mat, Vec * diag, Vec * beta, Mat * q_out);

/** Construct actual Hessenberg matrix.
 */
void mxMakeH(Mat * h_mat, Mat * h_out);

//@}


}

#endif
