// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "BoostingMeasurer.h"

namespace Torch {

BoostingMeasurer::BoostingMeasurer(ClassFormat *class_format_, FILE *file_) : Measurer(NULL, file_)
{
  weights = NULL;
  inputs = NULL;
  status = NULL;

  class_format = class_format_;
}

BoostingMeasurer::BoostingMeasurer(ClassFormat *class_format_, const char *filename) : Measurer(NULL, filename)
{
  weights = NULL;
  inputs = NULL;
  status = NULL;

  class_format = class_format_;
}

void BoostingMeasurer::setData(DataSet *data_)
{
  data = data_;
  status = (int *)xrealloc(status, sizeof(int)*data->n_examples);
}

void BoostingMeasurer::setWeights(real *weights_)
{
  weights = weights_;
}

void BoostingMeasurer::setInputs(List *inputs_)
{
  inputs = inputs_;
}

void BoostingMeasurer::init()
{
  Measurer::init();

  measure = xalloc(sizeof(real)*2);
    
  real *r_measure = (real *)measure;
  erreur = r_measure;
  erreur_c = r_measure+1;

  reset();
}

void BoostingMeasurer::measureEx()
{
  int c_obs = class_format->getOutputClass(inputs);
  int c_des = class_format->getTargetClass(data->targets);

  if(c_obs != c_des) {
    *erreur_c += weights[current_example];
    status[current_example++] = -1;
  } else {
    status[current_example++] = 1;
  }
}

void BoostingMeasurer::measureIter()
{
  *erreur = *erreur_c;
  beta = *erreur/(1. - *erreur);

  fprintf(file, "%g ==> %g for beta\n", *erreur, beta);
  fflush(file);
  reset();
}

void BoostingMeasurer::reset()
{
  *erreur_c = 0;
  current_example = 0;
}

BoostingMeasurer::~BoostingMeasurer()
{
  free(status);
  free(measure);
}

}

