from gettext import gettext as _

def is_valid_preset_name(name_str, preset_store, allowed_names=()):
    if len(name_str) == 0:
        return False
        
    name_str = name_str.lower()
    for allowed in allowed_names:
        if name_str == allowed.lower():
            return True
    
    return not preset_store.preset_name_exists_case_insensitive(name_str)
                
def seconds_to_hms(total_seconds):
    (hours, remaining_seconds) = divmod(total_seconds, 3600)
    (minutes, seconds) = divmod(remaining_seconds, 60)
    return (hours, minutes, seconds)
    
def hms_to_seconds(hours, minutes, seconds):
    return hours * 3600 + minutes * 60 + seconds
    
def get_preset_display_text(presets_store, row_iter):
    (name, hours, minutes, seconds) = presets_store.get_preset(row_iter)
    
    # <preset name> (HH:MM:SS)
    return _('%s (%02d:%02d:%02d)') % (name, hours, minutes, seconds)
