# Author:: Masaki Suketa.
# Adapted by:: Nathaniel Talbott.
# Copyright:: Copyright (c) Masaki Suketa. All rights reserved.
# Copyright:: Copyright (c) 2002 Nathaniel Talbott. All rights reserved.
# License:: Ruby license.

require 'runit/testsuite'

require 'testassert'
require 'testtestsuite'
require 'testtestcase'
require 'testtestresult'

class TestAll
  def self.suite
    suite = RUNIT::TestSuite.new
    Object.constants.sort.each do |k|
      next if /^Test/ !~ k
      constant = Object.const_get(k)
      if constant.kind_of?(Class) && constant.superclass == RUNIT::TestCase
      suite.add(constant.suite)
      end
    end
    suite
  end
end
