/************************************************************************/
/*									*/
/*  Manage a menu to contol the font encoding in a font selection tool.	*/
/*									*/
/************************************************************************/

#   include	<appEncodingMenu.h>
#   include	<appFrame.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Adapt to a font, encoding combination.				*/
/*									*/
/************************************************************************/

void appEncodingMenuSetOptionmenu(	AppEncodingMenu *		aem,
					const SupportedCharset *	sc,
					int				enc )
    {
    int		i;

    if  ( enc < 0 || enc >= ENCODINGps_COUNT )
	{ LLDEB(enc,ENCODINGps_COUNT);		}
    else{
	if  ( aem->aemFontEncodingChosen != enc )
	    {
	    aem->aemFontEncodingChosen= enc;

	    appSetOptionmenu( &(aem->aemEncodingOptionmenu), enc );
	    }
	}

    for ( i= 0; i < ENCODINGps_COUNT; i++ )
	{
	appGuiEnableWidget( aem->aemFontEncodingOptions[i],
						    sc[i].scSupported != 0 );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt to the encodings of a font family.				*/
/*									*/
/************************************************************************/

void appEncodingMenuAdaptToFamilyEncodings(
					AppEncodingMenu *	aem,
					const AppFontFamily *	aff )
    {
    int			enc= -1;

    enc= aff->affDefaultEncoding;

    if  ( aem->aemFontEncodingSet >= 0					&&
	  aem->aemFontEncodingSet < ENCODINGps_COUNT			&&
	  aff->affSupportedCharsets[
			    aem->aemFontEncodingSet].scSupported	)
	{
	enc= aem->aemFontEncodingSet;
	}

    if  ( aem->aemFontEncodingChosen >= 0				&&
	  aem->aemFontEncodingChosen < ENCODINGps_COUNT			&&
	  aff->affSupportedCharsets[
			    aem->aemFontEncodingChosen].scSupported	)
	{
	enc= aem->aemFontEncodingChosen;
	}

    appEncodingMenuSetOptionmenu( aem, aff->affSupportedCharsets, enc );

    return;
    }

/************************************************************************/
/*									*/
/*  Retrieve the encoding from an option menu option event.		*/
/*									*/
/************************************************************************/

int appEncodingMenuEncodingFromWidget(	int *				pEnc,
					const AppEncodingMenu *		aem,
					APP_WIDGET			w )
    {
    int		enc;

    for ( enc= 0; enc < ENCODINGps_COUNT; enc++ )
	{
	if  ( w == aem->aemFontEncodingOptions[enc] )
	    { break;	}
	}

    if  ( enc < 0 || enc >= ENCODINGps_COUNT )
	{ LLDEB(enc,ENCODINGps_COUNT); return -1;	}

    *pEnc= enc; return 0;
    }

/************************************************************************/
/*									*/
/*  Fill the option menu of an encoding menu.				*/
/*									*/
/************************************************************************/

void appEncodingMenuFillOptionmenu(	char **			opts,
					APP_BUTTON_CALLBACK	callBack,
					void *			through,
					AppEncodingMenu *	aem )
    {
    int		i;

    appEmptyOptionmenu( &(aem->aemEncodingOptionmenu) );

    for ( i= 0; i < ENCODINGps_COUNT; i++ )
	{
	aem->aemFontEncodingOptions[i]= appAddItemToOptionmenu(
				    &(aem->aemEncodingOptionmenu),
				    opts[i], callBack, through );
	}

    appSetOptionmenu( &(aem->aemEncodingOptionmenu), 0 );
    aem->aemFontEncodingSet= 0;
    aem->aemFontEncodingChosen= 0;

    appOptionmenuRefreshWidth( &(aem->aemEncodingOptionmenu) );
    
    return;
    }

/************************************************************************/
/*									*/
/*  Retrieve the textual representation of the encoding names.		*/
/*									*/
/************************************************************************/

void appEncodingMenuGetOptionTexts(	char **			opts,
					EditApplication *	ea )
    {
    int				i;
    AppConfigurableResource	acr[ENCODINGps_COUNT];
    AppConfigurableResource *	acri;
    const FontCharset *		fc;

    fc= PS_Encodings;
    acri= acr;
    for ( i= 0; i < ENCODINGps_COUNT; fc++, acri++, i++ )
	{
	APP_SET_RESOURCE( acri, fc->fcId,
		    /*
		    offsetof(AppSymbolPickerResources,asprEncodings[i]),
		    */
		    i* sizeof(char *),
		    fc->fcLabel );
	}

    appGuiGetResourceValues( ea, opts, acr, ENCODINGps_COUNT );

    return;
    }

