//code from Dorando and Sboulema's MiniT+, modified by Hemiola SUN
// modified by onemen

const DRAG_LINK = 0;
const DRAG_TAB_TO_NEW_WINDOW = 1;
const DRAG_TAB_IN_SAME_WINDOW = 2;

function TMP_DragAndDrop_init() {
  TMP_setDragEvents(true);

  if (!gIsFirefox35) {
    // for Firefox Dragmark
    gBrowser.mTabDropIndicatorBar.addEventListener('dragover', TMP_TabDragOver, true);
    gBrowser.mTabDropIndicatorBar.addEventListener('dragdrop', TMP_TabDragDrop, true);
  }

  var stringBundle = document.getElementById("tmp-string-bundle");
  TabDNDObserver.draglink = stringBundle.getString("droplink.label")
}

function TMP_setDragEvents(atStart) {
  // we only set Tabmix events at start if Tree Style Tab is not in vertical mode
  var useDefaultDnD = false;
  if ("TreeStyleTabBrowser" in window) {
    try {
      var tabbarPosition = gTabmixPrefs.getCharPref("extensions.treestyletab.tabbar.position").toLowerCase();
    }
    catch (er) {};
    useDefaultDnD = tabbarPosition == "left" || tabbarPosition == "right";
  }

  if (atStart && useDefaultDnD) {
    gBrowser.tabContainer.tabmix_useDefaultDnD = useDefaultDnD;
    return; // nothing to do here;
  }

  if ("tabmix_useDefaultDnD" in gBrowser.tabContainer && gBrowser.tabContainer.tabmix_useDefaultDnD == useDefaultDnD) {
    return; // nothing to do here;
  }
  gBrowser.tabContainer.tabmix_useDefaultDnD = useDefaultDnD;
  if (gIsFirefox37) {
    TabDNDObserver._dragOverDelay = gBrowser.tabContainer._dragOverDelay;
    TabDNDObserver.paddingLeft  = TMP_getStyle(gBrowser.tabContainer, "paddingLeft");
    return;
  }

  TabDNDObserver._dragOverDelay = gBrowser.mDragOverDelay;

  if (useDefaultDnD && gIsFirefox35) {
    gBrowser.mStrip.setAttribute("ondragstart", "this.parentNode.parentNode._onDragStart(event);");
    gBrowser.mStrip.setAttribute("ondragover", "this.parentNode.parentNode._onDragOver(event);");
    gBrowser.mStrip.setAttribute("ondrop", "this.parentNode.parentNode._onDrop(event);");
    gBrowser.mStrip.setAttribute("ondragend", "this.parentNode.parentNode._onDragEnd(event);");
    gBrowser.mStrip.setAttribute("ondragleave", "this.parentNode.parentNode._onDragLeave(event);");
    if (!gIsFirefox37) {
      gBrowser.mTabDropIndicatorBar.setAttribute("ondragover", "this.parentNode.parentNode._onDragOver(event);");
      gBrowser.mTabDropIndicatorBar.setAttribute("ondragleave", "this.parentNode.parentNode._onDragLeave(event);");
      gBrowser.mTabDropIndicatorBar.setAttribute("ondrop", "this.parentNode.parentNode._onDrop(event);");
    }
  }
  else if (useDefaultDnD && !gIsFirefox35) {
    gBrowser.mStrip.setAttribute("ondraggesture","nsDragAndDrop.startDrag(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragover","nsDragAndDrop.dragOver(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragdrop","nsDragAndDrop.drop(event, this.parentNode.parentNode); event.stopPropagation();");
    gBrowser.mStrip.setAttribute("ondragexit","nsDragAndDrop.dragExit(event, this.parentNode.parentNode); event.stopPropagation();");
  }
  else if (gIsFirefox35) {
    gBrowser.mStrip.setAttribute("ondragstart", "TabDNDObserver.onDragStart(event)");
    gBrowser.mStrip.setAttribute("ondragover", "TabDNDObserver.onDragOver(event)");
    gBrowser.mStrip.setAttribute("ondrop", "TabDNDObserver.onDrop(event);");
    gBrowser.mStrip.setAttribute("ondragend", "TabDNDObserver.onDragEnd(event);");
    gBrowser.mStrip.setAttribute("ondragleave", "TabDNDObserver.onDragExit(event);");
    if (!gIsFirefox37) {
      gBrowser.mTabDropIndicatorBar.setAttribute("ondragover", "TabDNDObserver.onDragOver(event);");
      gBrowser.mTabDropIndicatorBar.setAttribute("ondragleave", "TabDNDObserver.onDragExit(event);");
      gBrowser.mTabDropIndicatorBar.setAttribute("ondrop", "TabDNDObserver.onDrop(event);");
    }
  }
  else {
    gBrowser.mStrip.setAttribute("ondraggesture", "TMP_TabDragGesture(event);");
    gBrowser.mStrip.setAttribute("ondragover", "TMP_TabDragOver(event);");
    gBrowser.mStrip.setAttribute("ondragdrop", "TMP_TabDragDrop(event);");
    gBrowser.mStrip.setAttribute("ondragexit", "TMP_TabDragExit(event);");
  }
}

///////////////////////////////////////////////////////////////////////////
//// Drag and Drop observers

function TMP_TabDragGesture(aEvent) {
   nsDragAndDrop.startDrag(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

function TMP_TabDragOver(aEvent) {
   nsDragAndDrop.dragOver(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

function TMP_TabDragDrop(aEvent) {
   nsDragAndDrop.drop(aEvent, TabDNDObserver);
   aEvent.stopPropagation();
}

function TMP_TabDragExit(aEvent) {
   nsDragAndDrop.dragExit(aEvent, TabDNDObserver);
}

var TabDNDObserver = {
  gBackupLabel: "",
  gMsg: null,
  draglink: "",
  lastTime: 0,
  dragmarkindex: null,
  marginBottom: 0,
  paddingLeft: 0,
  _dragTime: 0,
  _dragOverDelay: 350,

  onDragStart: function (event, transferData, action) {
    if (gIsFirefox35)
      this._dragLeftWindow = false;
    if (event.target.localName != "tab" || event.originalTarget.localName == "toolbarbutton")
      return;

    let tabs = gBrowser.tabContainer.getElementsByAttribute("showbutton" , "*");
    for (var i = 0; i < tabs.length; i++)
      tabs[i].removeAttribute("showbutton");

    var draggedTab = event.target;
    var uri = gBrowser.getBrowserForTab(draggedTab).currentURI;
    var spec = uri ? uri.spec : "about:blank";

    if (gIsFirefox35) {
      let dt = event.dataTransfer;
      dt.mozSetDataAt(TAB_DROP_TYPE, draggedTab, 0);
      // We must not set text/x-moz-url or text/plain data here,
      // otherwise trying to deatch the tab by dropping it on the desktop
      // may result in an "internet shortcut"
      dt.mozSetDataAt("text/x-moz-text-internal", spec, 0);
      // Set the cursor to an arrow during tab drags.
      dt.mozCursor = "default";

      let canvas = tabPreviews.capture(draggedTab, false);
      dt.setDragImage(canvas, 0, 0);
      event.stopPropagation();
    }
    else { // Firefox 3.0.X
      var label = uri ? draggedTab.label : gBrowser.mStringBundle.getString("tabs.untitled");
      transferData.data = new TransferData();
      transferData.data.addDataForFlavour("text/x-moz-url", spec + "\n" + label);
      transferData.data.addDataForFlavour("text/unicode", spec);
      transferData.data.addDataForFlavour("text/html", '<a href="' + spec + '">' + label + '</a>');
    }

  },

  onDragOver: function minit_onDragOver(event, flavours, session) {
    var dt = event.dataTransfer;
    var tabBar = gBrowser.tabContainer;

    var sourceNode = TMP_getSourceNode(dt, session);
    var draggeType = this.getDragType(sourceNode);
    var newIndex = this.getNewIndex(event);
    var oldIndex = draggeType != DRAG_LINK ? sourceNode._tPos : -1;
    var left_right; // 1:right, 0: left, -1: drop link on tab to replace tab
    if (newIndex < gBrowser.tabs.length)
      left_right = this.getLeft_Right(event, newIndex, oldIndex, draggeType);
    else {
      newIndex = draggeType != DRAG_TAB_IN_SAME_WINDOW && getOpenTabNextPref(draggeType == DRAG_LINK) ? tabBar.selectedIndex :
                  gBrowser.tabs.length - 1;
      left_right = 1;
    }

    var isCopy;
    if (gIsFirefox35) {
      isCopy = dt.dropEffect == "copy";
      var effects = this._setEffectAllowedForDataTransfer(event, draggeType);
    }
    else
      isCopy = (event.ctrlKey || event.metaKey);

    var replaceTab = (left_right == -1);
    /* we don't allow to drop link on lock tab.
     * unless:
     *           - the tab is blank
     *     or    - the user press Ctrl/Meta Key
     *     or    - we drop link that start download
     */
    if (replaceTab && !isCopy) {
      var targetTab = gBrowser.tabs[newIndex];
      if (targetTab.getAttribute("locked") && !gBrowser.isBlankNotBusyTab(targetTab)) {
        try {
          var url;
          if (gIsFirefox35)
            url = this.retrieveURLFromData(dt);
          else {
            var dropData = nsTransferable.get(new FlavourSet([flavours]), nsDragAndDrop.getDragData, true).first.first;
            url = transferUtils.retrieveURLFromData(dropData.data, dropData.flavour.contentType);
          }
          if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
              /^\s*(javascript|data):/.test(url))
            url = null;

          var disAllowDrop = url ? !isUrlForDownload(url) : true;
        } catch (ex) { TMP_ASSERT(ex);}

        if (disAllowDrop)
          gIsFirefox35 ? dt.effectAllowed = "none" : session.canDrop = false;
      }
    }

    var canDrop;
    var hideIndicator = false;
    if (gIsFirefox35) {
      if (effects == "") {
        this.clearDragmark();
        return;
      }
      canDrop = effects != "none";
      if (canDrop && !isCopy && draggeType == DRAG_TAB_IN_SAME_WINDOW && oldIndex == newIndex) {
        canDrop = false;
        dt.effectAllowed = "none";
      }

      event.preventDefault();
      event.stopPropagation();
    }
    else {
      if (draggeType == DRAG_TAB_IN_SAME_WINDOW && oldIndex == newIndex)
        session.canDrop = isCopy && event.target != sourceNode;

      canDrop = session.canDrop;
      if (canDrop && !this.isValidTarget(event, session))
        return;
    }

    // show Drag & Drop message
    if (draggeType == DRAG_LINK) {
      this.gMsg = event.originalTarget.getAttribute("command") == "cmd_newNavigatorTab" ?
                              gNavigatorBundle.getString("droponnewtabbutton") : this.draglink;
      if (event.target.localName != "tab" && event.target.localName != "tabs")
        this.gMsg = this.gBackupLabel;
      var statusTextFld = document.getElementById("statusbar-display");
      if (statusTextFld.label != this.gMsg) {
        if (this.gBackupLabel == "")
          this.gBackupLabel = statusTextFld.label;
        statusTextFld.label = this.gMsg;
      }
    }

    if (tabBar.canScrollTabsLeft || tabBar.canScrollTabsRight) {
      var _scroll, targetAnonid;
      if (tabscroll > 0) // scroll with button
        targetAnonid = event.originalTarget.getAttribute("anonid");
      // scroll without button
      else if (event.clientX <= tabBar.tabstrip.boxObject.x)
        targetAnonid = "scrollbutton-up";
      else if(event.clientX >= (tabBar.tabstrip.boxObject.x + tabBar.tabstrip.boxObject.width))
        targetAnonid = "scrollbutton-down";

      switch (targetAnonid) {
        case "scrollbutton-up":
          if (tabBar.canScrollTabsLeft)
            _scroll = -1;
            break;
        case "scrollbutton-down":
          if (tabBar.canScrollTabsRight)
            _scroll = 1;
            break;
      }
      if (_scroll) {
        var newTime = new Date().getTime();
        if (newTime - this.lastTime > 100) {
          tabBar.tabsScroll(_scroll);
          this.lastTime = newTime;
        }
        hideIndicator = true;
      }
    }

    if (draggeType == DRAG_LINK) {
      let tab;
      if (gIsFirefox37)
        tab = tabBar._getDragTargetTab(event);
      else
        tab = event.target;
      if (tab) {
        if (!this._dragTime)
          this._dragTime = Date.now();
        if (Date.now() >= this._dragTime + this._dragOverDelay)
          tabBar.selectedItem = tab;
      }
    }

    if ( replaceTab || hideIndicator || !canDrop) {
      this.clearDragmark();
      return;
   }

   // fix problem on firefox 3.7 when draging left of the first tab and back
   var showAgain = false;
   if (gIsFirefox37 && newIndex + left_right == 0 && gBrowser.tabContainer._tabDropIndicator.collapsed &&
                event.clientX >= gBrowser.tabs[0].boxObject.x) {
     showAgain = true;
   }
   this.setDragmark(newIndex, left_right, showAgain);
  },

  onDrop: function minit_onDrop(event, dropData, session) {
    this.clearDragmark();
    var dt = event.dataTransfer;
    var sourceNode = TMP_getSourceNode(dt, session);
    var draggeType = this.getDragType(sourceNode);
    var isCopy = gIsFirefox35 ? (dt.dropEffect == "copy") : (event.ctrlKey || event.metaKey);
    var draggedTab;
    if (draggeType != DRAG_LINK) {
      draggedTab = sourceNode;
      // not our drop then
      if (!draggedTab)
        return;
    }

    if (gIsFirefox35) {
      event.stopPropagation();
    }

    var isTabReorder = draggeType == DRAG_TAB_IN_SAME_WINDOW // TreeStyleTab extension look for isTabReorder in our code
    var newIndex = this.getNewIndex(event);
    var oldIndex = draggedTab ? draggedTab._tPos : -1;
    var left_right;

    if (newIndex < gBrowser.tabs.length)
       left_right = this.getLeft_Right(event, newIndex, oldIndex, draggeType);
    else {
      newIndex = draggeType != DRAG_TAB_IN_SAME_WINDOW && getOpenTabNextPref(draggeType == DRAG_LINK) ? gBrowser.tabContainer.selectedIndex :
                 gBrowser.tabs.length - 1;
      left_right = 1;
    }

    if (draggedTab && (isCopy || draggeType == DRAG_TAB_IN_SAME_WINDOW)) {
      if (isCopy) {
        // copy the dropped tab (wherever it's from)
        var newTab = gBrowser.duplicateTab(draggedTab);
        gBrowser.moveTabTo(newTab, newIndex + left_right);

        if (draggeType == DRAG_TAB_TO_NEW_WINDOW || event.shiftKey)
          gBrowser.selectedTab = newTab;
      }
      else {
        // move the dropped tab
        newIndex += left_right - (newIndex > oldIndex);
        if (newIndex != draggedTab._tPos)
          gBrowser.moveTabTo(draggedTab, newIndex);
      }

      draggedTab.collapsed = false;
      // probably there is no way to drag collapsed tab....
      var firstVisibleIndex = gBrowser.tabContainer.collapsedTabs;
      if ( gBrowser.tabContainer.getAttribute("flowing") == "multibar" &&
            gBrowser.tabContainer.getAttribute("multibar") == "scrollbar" &&
            oldIndex < firstVisibleIndex )
        gBrowser.tabs[firstVisibleIndex - 1].collapsed = true;
      gBrowser.tabContainer.ensureTabIsVisible(newIndex);
      checkBeforeAndAfter();
    }
    else if (draggedTab) {
      if (gIsFirefox35) { // Firefox 3.5+
        // swap the dropped tab with a new one we create and then close
        // it in the other window (making it seem to have moved between
        // windows)
        newTab = gBrowser.addTab("about:blank");
        var newBrowser = gBrowser.getBrowserForTab(newTab);
        // Stop the about:blank load
        newBrowser.stop();
        // make sure it has a docshell
        newBrowser.docShell;

        gBrowser.moveTabTo(newTab, newIndex + left_right);

        gBrowser.swapBrowsersAndCloseOther(newTab, draggedTab);

        // We need to set selectedTab after we've done
        // swapBrowsersAndCloseOther, so that the updateCurrentBrowser
        // it triggers will correctly update our URL bar.
        gBrowser.selectedTab = newTab;
      }
      else {
        // Firefox 3.0
        // copy the dropped tab and remove it from the other window
        // (making it seem to have moved between windows)
        var sourceWindow = draggedTab.ownerDocument.defaultView;
        var remoteBrowser = sourceWindow.gBrowser;
        var tabCount = remoteBrowser.tabs.length;
        newTab = gBrowser.duplicateTab(draggedTab);
        gBrowser.moveTabTo(newTab, newIndex + left_right);
        gBrowser.selectedTab = newTab;
        remoteBrowser.removeTab(draggedTab);
        // close the other window if gBrowser was its last tab
        if (tabCount == 1)
          draggedTab.ownerDocument.defaultView.close();
      }
    }
    else {
      var url;
      if (gIsFirefox35)
        url = this.retrieveURLFromData(dt);
      else
        url = transferUtils.retrieveURLFromData(dropData.data, dropData.flavour.contentType);

      // valid urls don't contain spaces ' '; if we have a space it isn't a valid url.
      // Also disallow dropping javascript: or data: urls--bail out
      if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
         /^\s*(javascript|data):/.test(url))
         return;

      if (gIsFirefox35) {
        var dragService = Cc["@mozilla.org/widget/dragservice;1"].getService(Ci.nsIDragService);
        session = dragService.getCurrentSession();
      }
      nsDragAndDrop.dragDropSecurityCheck(event, session, url);
      var bgLoad = true;
      try {
        bgLoad = gTabmixPrefs.getBoolPref("browser.tabs.loadInBackground");
      }
      catch (e) { }

      if (event.shiftKey)
        bgLoad = !bgLoad; // shift Key reverse the pref

      url = getShortcutOrURI(url);
      var tab = null;
      if (left_right > -1 && !isUrlForDownload(url)) {
        // We're adding a new tab.
         try {
            tab = gBrowser.addTab(url);
            gBrowser.moveTabTo(tab, newIndex + left_right);
         } catch(ex) {
            // Just ignore invalid urls
            tmLog("addTab\n" + ex);
            return;
         }
      }
      else {
        // Load in an existing tab.
        tab = event.target.localName == "tab" ? event.target : gBrowser.tabs[newIndex];
        try {
          gBrowser.getBrowserForTab(tab).loadURI(url);
        } catch(ex) {
          // Just ignore invalid urls
          tmLog("load\n" + ex);
          return;
        }
      }
      if (gBrowser.mCurrentTab != tab)
        gBrowser.TMP_selectNewForegroundTab(tab, bgLoad, url);
    }
  },

  onDragEnd: function minit_onDragEnd(aEvent) {
    // see comment in gBrowser._onDragEnd
    // don't allow to open new window in single window mode
    var dt = aEvent.dataTransfer;
    if (dt.mozUserCancelled || dt.dropEffect != "none")
      return;

    if (gSingleWindowMode) {
      if (gIsFirefox37)
        aEvent.stopPropagation();
      return;
    }

    this.clearDragmark(aEvent);
    // Disable detach within the browser toolbox
    var eX = aEvent.screenX;
    var wX = window.screenX;
    // check if the drop point is horizontally within the window
    if (eX > wX && eX < (wX + window.outerWidth)) {
      // also avoid detaching if the the tab was dropped too close to
      // the tabbar (half a tab)
      var tabBar = gBrowser.tabContainer;
      var bo = tabBar.mTabstrip.boxObject;
      var tabHeight = tabBar.childNodes[tabBar.collapsedTabs].boxObject.height;
      var endScreenY = bo.screenY + bo.height + 0.5 * tabHeight;
      var eY = aEvent.screenY;
      if (gTabbarPosition == 0) {// tabbar on the top
        if (eY < endScreenY && eY > window.screenY)
          return;
      }
      else {// bottom
        var tb = gNavToolbox.boxObject;
        var toolboxEndScreenY = tb.screenY + tb.height;
        var startScreenY = bo.screenY - 0.5 * tabHeight;
        if ((eY > startScreenY && eY < endScreenY) || eY < toolboxEndScreenY)
          return;
      }

    }

    var draggedTab = dt.mozGetDataAt(TAB_DROP_TYPE, 0);
    gBrowser.replaceTabWithWindow(draggedTab);
    aEvent.stopPropagation();
  },

  onDragExit: function minit_onDragExit(event, session) {
    event.stopPropagation();
    this._dragTime = 0;

    if (gIsFirefox35) {
      var target = event.relatedTarget;
      while (target && target.localName != "tabs")
        target = target.parentNode;
      if (target)
        return;

      this.clearDragmark();
    }
    else
      this.isValidTarget(event, session);
  },

  isValidTarget: function minit_isValidTarget(event, session) {
    var tabStripBoxObject = gBrowser.mStrip.boxObject;
    if ( event.clientY <= tabStripBoxObject.y + 1 ||
         event.clientX < tabStripBoxObject.x ||
         event.clientY >= tabStripBoxObject.y + tabStripBoxObject.height) {
      var statusTextFld = document.getElementById("statusbar-display");
      if (statusTextFld.label == this.gMsg) {
        statusTextFld.label = this.gBackupLabel;
        this.gBackupLabel = "";
      }
      this.clearDragmark();
      gIsFirefox35 ? event.dataTransfer.effectAllowed = "none" : session.canDrop = false;
      return false;
    }
    return true;
  },

  getNewIndex: function (event) {
    // start to chack after collapsedTabs
    // if X is less then the first tab return 0
    // check if the tab is visible... if not return gBrowser.tabs.length
    // check if Y is below the tab.... if yes go to next row
    // in the row find the closest tab by X,
    // if no tab is match return gBrowser.tabs.length
    var mX = event.clientX, mY = event.clientY;
    var i, tabBar = gBrowser.tabContainer;
    var tabs = tabBar.childNodes;
    var collapsed = tabBar.collapsedTabs;
    if (!tabBar.hasAttribute("multibar")) {
      if (window.getComputedStyle(gBrowser, null).direction == "ltr") {
        for (i = event.target.localName == "tab" ? event.target._tPos : collapsed; i < tabs.length; i++)
          if (mX < tabs[i].boxObject.x + tabs[i].boxObject.width)
            return i;
      }
      else {
        for (i = event.target.localName == "tab" ? event.target._tPos : 0 ; i < tabs.length - collapsed; i++)
          if (mX > tabs[i].boxObject.x + tabs[i].boxObject.width*0)
            return i;
      }
    }
    else {
      var j, tab, thisRow;
      var top = tabBar.topTabY;
      if (window.getComputedStyle(gBrowser, null).direction == "ltr") {
        for (i = collapsed; i < tabs.length; i++) {
          if (!tabBar.isTabVisible(i))
            return tabs.length;
          tab = tabs[i];
          thisRow = tabBar.getTabRowNumber(tab, top);
          if (mY >= tab.baseY) {
            while (i < tabs.length - 1 && tabBar.getTabRowNumber(tabs[i+1], top) == thisRow)
              i++;
          }
          else if (mX < tab.boxObject.x + tab.boxObject.width )
            return i;
          else if (i == tabs.length - 1 || tabBar.getTabRowNumber(tabs[i+1], top) != thisRow)
            return i;
        }
      }
      else {
        for (i = collapsed; i < tabs.length; i++) {
          if (!tabBar.isTabVisible(i))
            return tabs.length;
          tab = tabs[i];
          thisRow = tabBar.getTabRowNumber(tab, top);
          if (mY >= tab.baseY) {
            while (i < tabs.length - 1 && tabBar.getTabRowNumber(tabs[i+1], top) == thisRow)
              i++;
          }
          else if (mX > tab.boxObject.x)
            return i;
          else if (i == tabs.length - 1 || tabBar.getTabRowNumber(tabs[i+1], top) != thisRow)
            return i;
        }
      }
    }
    return tabs.length;
  },

  getLeft_Right: function (event, newIndex, oldIndex, draggeType) {
   var clientX = event.clientX;
   var left_right;
   var tab = gBrowser.tabs[newIndex];
   var tabBo = tab.boxObject;
   var ltr = (window.getComputedStyle(gBrowser, null).direction == "ltr");
   var _left = ltr ? 0 : 1;
   var _right = ltr ? 1 : 0;

   var isCtrlKey = ((event.ctrlKey || event.metaKey) && !event.shiftKey && !event.altKey);
   var lockedTab = tab.getAttribute("locked") && !gBrowser.isBlankNotBusyTab(tab);
   if ((draggeType == DRAG_LINK && lockedTab) || (draggeType == DRAG_LINK && !lockedTab && !isCtrlKey)) {
      left_right = (clientX < tabBo.x + tabBo.width / 4 ) ? _left : _right;
      if (left_right == 1 && clientX < tabBo.x + tabBo.width * 3 / 4 )
         left_right = -1;
   }
   else {
      left_right = ( clientX < tabBo.x + tabBo.width / 2 ) ? _left : _right;
      if (!isCtrlKey && draggeType == DRAG_TAB_IN_SAME_WINDOW) {
        if (newIndex == oldIndex - 1)
          left_right = _left;
        else if (newIndex == oldIndex + 1)
          left_right = _right;
      }
   }

   return left_right;
  },

  getDragType: function minit_getDragType(aSourceNode) {
    if (aSourceNode && aSourceNode instanceof XULElement && aSourceNode.localName == "tab") {
      if (aSourceNode.parentNode == gBrowser.tabContainer)
        return DRAG_TAB_IN_SAME_WINDOW; // 2
      if (aSourceNode.ownerDocument.defaultView instanceof ChromeWindow &&
           aSourceNode.ownerDocument.documentElement.getAttribute("windowtype") == "navigator:browser")
        return DRAG_TAB_TO_NEW_WINDOW; // 1
    }
    return DRAG_LINK; // 0
  },

  setDragmark: function minit_setDragmark(index, left_right, showAgain) {
    var newIndex = index + left_right;
    if (this.dragmarkindex == newIndex && !showAgain)
      return;

   this.clearDragmark();// clear old dragmark if one exist

   if (!tabxPrefs.getBoolPref("useFirefoxDragmark")) {
      var sameRow = newIndex != 0 && newIndex != gBrowser.tabs.length &&
            inSameRow(gBrowser.tabs[newIndex-1], gBrowser.tabs[newIndex]);
      if (sameRow || left_right==0)
         this.setDragmarkAttribute(gBrowser.tabs[newIndex], "atLeft");
      if (sameRow || left_right==1)
         this.setDragmarkAttribute(gBrowser.tabs[newIndex-1], "atRight");
   }
   else {
      // code for firefox indicator
      var ib = gBrowser.mTabDropIndicatorBar;
      var ibRect = ib.getBoundingClientRect();
      var ind = gIsFirefox37 ? gBrowser.tabContainer._tabDropIndicator : ib.firstChild;
      var rect;
      var minMargin, maxMargin, newMargin;
      var tabBoxObject, tabRect;
      var ltr = (window.getComputedStyle(gBrowser, null).direction == "ltr");
      if (gIsFirefox36) {
         var scrollRect = gBrowser.tabContainer.tabstrip.getBoundingClientRect();
         rect = (gIsFirefox37 ? gBrowser.tabContainer : gBrowser).getBoundingClientRect();
         let paddingLeft = !gBrowser.tabContainer.overflow || tabscroll == 0 ||  tabscroll == 2 ||
                                      (tabscroll == 3 && !tabxPrefs.getBoolPref("tabBarSpace")) ? this.paddingLeft : 0;
         minMargin = scrollRect.left - rect.left - paddingLeft;
         if (gIsFirefox37)
            maxMargin = Math.min(minMargin + scrollRect.width, scrollRect.right);
         else
            maxMargin = Math.min(minMargin + scrollRect.width, ibRect.right - ind.clientWidth);
         if (!ltr)
            [minMargin, maxMargin] = [gBrowser.clientWidth - maxMargin, gBrowser.clientWidth - minMargin];

         tabRect = gBrowser.tabs[index].getBoundingClientRect();
         if (ltr)
            newMargin = tabRect.left - rect.left  + (left_right == 1 ? tabRect.width : 0) - paddingLeft;
         else
            newMargin = rect.right - tabRect.right - (left_right == 0 ? tabRect.width : 0);
      }
      else {
         this.setFirefoxDropIndicator(true);
         var tabStripBoxObject = gBrowser.tabContainer.tabstrip.boxObject;
         minMargin = tabStripBoxObject.x - gBrowser.boxObject.x;
         maxMargin = Math.min(minMargin + tabStripBoxObject.width, ib.boxObject.x + ib.boxObject.width - ind.boxObject.width);
         if (!ltr)
            [minMargin, maxMargin] = [gBrowser.boxObject.width - maxMargin, gBrowser.boxObject.width - minMargin];
         if (gTabbarPosition != 1)
            this.setFirefoxDropIndicator(false);
         tabBoxObject = gBrowser.tabs[index].boxObject;
         if (ltr)
            newMargin = tabBoxObject.screenX - gBrowser.boxObject.screenX + (left_right == 1 ? tabBoxObject.width : 0);
         else
            newMargin = gBrowser.boxObject.screenX - tabBoxObject.screenX + gBrowser.boxObject.width - (left_right == 0 ? tabBoxObject.width : 0);
      }

      // ensure we never place the drop indicator beyond our limits
      if (newMargin < minMargin)
         newMargin = minMargin;
      else if (newMargin > maxMargin)
            newMargin = maxMargin;

      var newMarginY;
      if ( gTabbarPosition == 1) {
         ind.style.backgroundPosition = "50% 0%";
         if (gIsFirefox36 )
            newMarginY = tabRect.top - ibRect.top;
         else
            newMarginY = tabBoxObject.screenY - ib.boxObject.screenY;
      }
      else {
         ind.style.backgroundPosition = "50% 100%";
         if (gIsFirefox36 ) {
            newMarginY = rect.top - tabRect.top + this.marginBottom;
         }
         else
            newMarginY = gBrowser.tabContainer.boxObject.screenY - tabBoxObject.screenY + this.marginBottom;
      }

      if (gIsFirefox37) {
         this.setFirefoxDropIndicator(true);
         newMarginY = (gTabbarPosition == 1 ? 1 : -1) * newMarginY;
         newMargin += ind.clientWidth / 2;
         if (!ltr)
           newMargin *= -1;

         ind.style.MozMarginStart = (-ind.clientWidth) + "px";
         ind.style.MozTransform = "translate(" + Math.round(newMargin) + "px," + (newMarginY - (gTabbarPosition == 1 ?  0 : ind.clientHeight)) + "px)";
      }
      else {
         ind.style.MozMarginStart = newMargin + "px";
         if (gTabbarPosition == 1)
            ind.style.marginTop = newMarginY + "px";
         else
            ind.style.marginBottom = newMarginY + "px";
         this.setFirefoxDropIndicator(true);
      }
    }

    this.dragmarkindex = newIndex;
  },

  clearDragmark: function minit_clearDragmark() {
    if (this.dragmarkindex == null)
      return;

    if (!tabxPrefs.getBoolPref("useFirefoxDragmark")) {
      var index = this.dragmarkindex;
      if (index != gBrowser.tabs.length && gBrowser.tabs[index].hasAttribute("dragmark"))
         this.removetDragmarkAttribute(gBrowser.tabs[index]);
      if (index != 0 && gBrowser.tabs[index-1].hasAttribute("dragmark"))
         this.removetDragmarkAttribute(gBrowser.tabs[index-1]);
    }
    else
      this.setFirefoxDropIndicator(false);

    this.dragmarkindex = null;
  },

  setFirefoxDropIndicator: function (val) {
    var indicator = gIsFirefox37 ? gBrowser.tabContainer._tabDropIndicator : gBrowser.mTabDropIndicatorBar;
    indicator.collapsed = !val;
  },

  removetDragmarkAttribute: function (tab) {
    tab.removeAttribute("dragmark");
    if (tab.hasAttribute("faviconized")) {
      tab.maxWidth = null;
      tab.style.removeProperty("max-width");
    }
    else {
      tab.maxWidth = gBrowser.tabContainer.mTabMaxWidth;
      tab.style.maxWidth = tab.maxWidth + "px";
    }
  },

  setDragmarkAttribute: function (tab, markSide) {
    tab.maxWidth = tab.boxObject.width;
    tab.style.maxWidth = tab.maxWidth + "px";
    tab.setAttribute("dragmark", markSide);
  },

  /*
   *  helper function for firefox 3.0.x
   */
  getSupportedFlavours: function () {
    var flavourSet = new FlavourSet();
    flavourSet.appendFlavour("text/x-moz-url");
    flavourSet.appendFlavour("text/unicode");
    flavourSet.appendFlavour("application/x-moz-file", "nsIFile");
    return flavourSet;
  },

  canDrop: function (aEvent, aDragSession) {
    if (aDragSession.sourceNode &&
      aDragSession.sourceNode.parentNode == gBrowser.tabContainer) {
      var sourceBo = aDragSession.sourceNode.boxObject;
      if (aEvent.screenX >= sourceBo.screenX &&
          aEvent.screenX <= (sourceBo.screenX +sourceBo.width) &&
          aEvent.screenY >= sourceBo.screenY &&
          aEvent.screenY <= (sourceBo.screenY +sourceBo.height))
        return false;
    }
    return true;
  },

  /*
   *  helper function for firefox 3.5+
   */
  _setEffectAllowedForDataTransfer: function minit_setEffectAllowed(aEvent, aDraggeType) {
    var dt = aEvent.dataTransfer;
    // Disallow dropping multiple items
    if (dt.mozItemCount > 1)
      return dt.effectAllowed = "none";

    var sourceNode = dt.mozGetDataAt(TAB_DROP_TYPE, 0);
    // move or copy tab
    if (aDraggeType != DRAG_LINK) {
      if (aDraggeType == DRAG_TAB_IN_SAME_WINDOW && aEvent.target == sourceNode) {
        return dt.effectAllowed = "none";
      }
      return dt.effectAllowed = "copyMove";
    }

    var types = dt.mozTypesAt(0);
    var supportedLinkDropTypes = gIsFirefox37 ? gBrowser.tabContainer._supportedLinkDropTypes : gBrowser._supportedLinkDropTypes;
    for (var i = 0; i < supportedLinkDropTypes.length; i++) {
      if (types.contains(supportedLinkDropTypes[i])) {
        // Here we need to to do this manually
        return dt.effectAllowed = dt.dropEffect = "link";
      }
    }
    return dt.effectAllowed = "none";
  },

  retrieveURLFromData: function minit_retrieveURLFromData(aDataTransfer) {
    var supportedLinkDropTypes = gIsFirefox37 ? gBrowser.tabContainer._supportedLinkDropTypes : gBrowser._supportedLinkDropTypes;
    for (var i=0; i < supportedLinkDropTypes.length; i++) {
      var dataType = supportedLinkDropTypes[i];
      var isURLList = dataType == "text/uri-list";
      var urlData = isURLList ?
                      aDataTransfer.mozGetDataAt("URL", 0) : aDataTransfer.mozGetDataAt(dataType, 0);
      if (urlData)
        return transferUtils.retrieveURLFromData(urlData, isURLList ? "text/plain" : dataType);
    }
    return null;
  }

} // TabDNDObserver end

function TMP_goButtonClick(aEvent) {
   if (aEvent.button == 1 && gURLBar.value == gBrowser.currentURI.spec)
      gBrowser.duplicateTab(gBrowser.mCurrentTab);
   else if (aEvent.button != 2) {
      if (gIsFirefox35)
         gURLBar.handleCommand(aEvent);
      else
         handleURLBarCommand(aEvent);
   }
}

function TM_BrowserHome() {
   var homePage = gHomeButton.getHomePage();
   if (TMP_whereToOpen(false).inNew) {
     TMP_loadTabs(homePage.split("|"), false);
   }
   else
      loadOneOrMoreURIs(homePage);
}

function TMP_loadTabs(aURIs, aReplace) {
  let bgLoad = gTabmixPrefs.getBoolPref("browser.tabs.loadInBackground");
  try {
    gBrowser.loadTabs(aURIs, bgLoad, aReplace);
  } catch (ex) { }
  // not in use for Firefox 3.7+
  gBrowser.tabContainer.nextTab = 1;
}

var undocloseTabButtonObserver = {
  onDragOver: function (aEvent, aFlavour, aDragSession) {
    var dt = aEvent.dataTransfer;
    var sourceNode = TMP_getSourceNode(dt, aDragSession);
    if (!sourceNode || sourceNode.localName != "tab") {
      gIsFirefox35 ? dt.effectAllowed = "none" : aDragSession.canDrop = false;
      return true;
    }

    var statusTextFld = document.getElementById("statusbar-display");
    var stringBundle = document.getElementById("tmp-string-bundle");
    statusTextFld.label = stringBundle.getString("droptoclose.label");
    aEvent.target.setAttribute("dragover", "true");
    return true;
  },

  onDragExit: function (aEvent, aDragSession) {
    if (aEvent.target.hasAttribute("dragover")) {
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = "";
      aEvent.target.removeAttribute("dragover");
    }
  },

  onDrop: function (aEvent, aXferData, aDragSession) {
    var sourceNode = TMP_getSourceNode(aEvent.dataTransfer, aDragSession);
    if (sourceNode && sourceNode.localName == "tab")
      // let the tabbrowser drag event time to end before we remove the sourceNode
      setTimeout( function (b, aTab) {b.removeTab(aTab, true);}, 0, gBrowser, sourceNode);
  },

  getSupportedFlavours: function () {
    var flavourSet = new FlavourSet();
    if (gIsFirefox35)
      flavourSet.appendFlavour(TAB_DROP_TYPE);
    flavourSet.appendFlavour("text/x-moz-url");
    flavourSet.appendFlavour("text/unicode");
    return flavourSet;
  }
}

/*
 *  helper function for firefox 3.5+
 */
function TMP_getSourceNode(aDataTransfer, aSession) {
  if (gIsFirefox35) {
    var types = aDataTransfer.mozTypesAt(0);
    if (types[0] == TAB_DROP_TYPE)
      return aDataTransfer.mozGetDataAt(TAB_DROP_TYPE, 0);
    return null;
  }
  return aSession.sourceNode;
}

function TMP_whereToOpen(pref, altKey) {
   var aTab = gBrowser.mCurrentTab;
   var isBlankTab = gBrowser.isBlankNotBusyTab(aTab);
   var isLockTab = !isBlankTab && aTab.hasAttribute("locked");

   var openTabPref = typeof(pref) == "string" ? gTabmixPrefs.getBoolPref(pref) : pref;
   if (typeof(altKey) != "undefined") {
      // don't reuse balnk tab if the user press alt key when the pref is to open in current tab
      if (altKey && !openTabPref)
         isBlankTab = false;

      // see bug 315034 If search is set to open in a new tab,
      // Alt+Enter should open the search result in the current tab
      // so here we reverse the pref if user press Alt key
      openTabPref = (altKey ^ openTabPref) == 1;
   }
   return { inNew: !isBlankTab && (isLockTab || openTabPref), lock: isLockTab };
}

function TMP_setStripVisibilityTo(aShow) {
   if (gIsFirefox37)
     gBrowser.tabContainer.visible = aShow
   else
     gBrowser.mStrip.collapsed = !aShow;
}
