# Sample of rubyunit

=begin
=How to use RubyUnit framework.
(1)load RubyUnit framework.

     require 'rubyunit'

(2)Define class derived from RUNIT::TestCase class.
     
     class SimpleTest < RUNIT::TestCase
     end
     
(3)If you want to prepare to run test, override setup method.
     
     class SimpleTest < RUNIT::TestCase
       def setup
         @fval1 = 2.0
         @fval2 = 3.0
       end
     end
     
(4)Add testXXXX method for running test.
     
     class SimpleTest < RUNIT::TestCase
       ...
       def test_add
         result = @fval1 + @fval2
         assert(result == 6.0)
       end
     end
     
(5)Add teardown method if you want to do something after running test.

=end

require 'rubyunit'

class SimpleTest < RUNIT::TestCase

  def setup
    @fval1 = 2.0
    @fval2 = 3.0
  end
  
  def test_add
    result = @fval1 + @fval2
    assert(result == 6.0)
  end

  def test_divide_by_zero
    zero = 0
    result = 8 / zero
  end

  def test_equals
    assert_equal(12, 12)
    assert_equal(12, 13)
  end

  def test_match
    assert_match(/foo/, 'foobar')
    assert_match(/foo/, 'barbaz')
  end

end


