require 'ftools'
require 'find'

LIBDIR = 'runit'
BINDIR = 'bin'

def instdirs
  begin
    require 'rbconfig'
    libdir = Config::CONFIG['sitedir'] + "/" + 
             Config::CONFIG['MAJOR'] + "." +
             Config::CONFIG['MINOR']
    bindir = Config::CONFIG['bindir']
  rescue ScriptError
    $LOAD_PATH.each do |l|
      if l =~ /site_ruby/ && l =~ /\d$/ && l !~ /#{PLATFORM}/
	libdir = l
	break
      end
    end
    STDERR.puts "Hmm... `rbconfig.rb' can not load."
    STDERR.puts "The library(`runit' directory) is installed to #{libdir}"
  end
  return libdir, bindir
end

INSTLIBDIR, INSTBINDIR = instdirs
def make_lib_dir(dir)
  File.makedirs(INSTLIBDIR + "/" + dir)
end

def inst_lib(file, mode)
  to = INSTLIBDIR + "/" + file
  File.install(file, to, mode, true)
end

def inst_bin(file, mode)
  to = INSTBINDIR + "/" + File.basename(file)
  File.install(file, to, mode, true)
end

make_lib_dir(LIBDIR)
Find.find(LIBDIR) do |f|
  if /\.rb$/ =~ f
    make_lib_dir(File.dirname(f))
    inst_lib(f, 0644)
  end
end
inst_lib('rubyunit.rb', 0644)

if INSTBINDIR
  Find.find(BINDIR) do |f|
    if /\.rb$/ =~ f
      inst_bin(f, 0755)
    end
  end
else 
  STDERR.puts "bin/*.rb not installed. Copy bin/*.rb manually!!!"
end
