#include "rbgst.h"

static VALUE busclass;
static ID id_call;

/* Class: Gst::Bus */
static VALUE
rb_gst_bus_new(VALUE self) {
  GstBus *bus = gst_bus_new();
  if (bus != NULL) 
    G_INITIALIZE(self, bus);
  return Qnil;
}

static gboolean
bus_func(GstBus *bus, GstMessage *message, gpointer func) {
  if (!is_ruby_native_thread()) {
    rb_bug("Bus callback in non-native thread");
  }
  if (!RTEST(rb_funcall((VALUE)func, id_call, 1, GOBJ2RVAL(message)))) {
    /* Returned false, watch is removed, remove it as child from the busclass
     * too */
    G_CHILD_REMOVE(busclass, (VALUE)func);
    return FALSE;
  } else 
  return TRUE;
}

static VALUE
rb_gst_bus_add_watch(VALUE self) {
  VALUE func = G_BLOCK_PROC();
  G_CHILD_ADD(busclass, func);
  return UINT2NUM(gst_bus_add_watch(RGST_BUS(self), (GstBusFunc)bus_func, 
                   (gpointer)func));
}

static VALUE
rb_gst_bus_remove_watch(VALUE self, VALUE watch_id) {
  g_source_remove(NUM2UINT(watch_id));
  return self;
}

void
Init_gst_bus(void) {
  busclass = G_DEF_CLASS (GST_TYPE_BUS, "Bus", mGst);
  rb_define_method (busclass, "initialize", rb_gst_bus_new, 0);
  rb_define_method (busclass, "add_watch", rb_gst_bus_add_watch, 0);
  rb_define_method (busclass, "remove_watch", rb_gst_bus_remove_watch, 1);
  id_call = rb_intern("call");
}
