# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # This Azure VM workload-specific (also known as IaaS VM workload-specific)
    # backup item has been backed up.
    #
    class AzureIaaSVMProtectedItem < ProtectedItem

      include MsRestAzure


      def initialize
        @protectedItemType = "AzureIaaSVMProtectedItem"
      end

      attr_accessor :protectedItemType

      # @return [String] The friendly name of the VM represented by this backup
      # item.
      attr_accessor :friendly_name

      # @return [String] The fully qualified Resource Manager ID of the virtual
      # machine represented by this item.
      attr_accessor :virtual_machine_id

      # @return [String] The backup status of this backup item.
      attr_accessor :protection_status

      # @return [ProtectionState] The backup state of this backup item.
      # Possible values include: 'Invalid', 'IRPending', 'Protected',
      # 'ProtectionError', 'ProtectionStopped', 'ProtectionPaused'
      attr_accessor :protection_state

      # @return [String] The last backup operation status. The possible values
      # are: Healthy or Unhealthy.
      attr_accessor :last_backup_status

      # @return [DateTime] The timestamp of the last backup operation for this
      # backup item.
      attr_accessor :last_backup_time

      # @return [AzureIaaSVMProtectedItemExtendedInfo] Additional information
      # for this backup item.
      attr_accessor :extended_info


      #
      # Mapper for AzureIaaSVMProtectedItem class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AzureIaaSVMProtectedItem',
          type: {
            name: 'Composite',
            class_name: 'AzureIaaSVMProtectedItem',
            model_properties: {
              backup_management_type: {
                required: false,
                serialized_name: 'backupManagementType',
                type: {
                  name: 'Enum',
                  module: 'BackupManagementType'
                }
              },
              workload_type: {
                required: false,
                serialized_name: 'workloadType',
                type: {
                  name: 'Enum',
                  module: 'DataSourceType'
                }
              },
              source_resource_id: {
                required: false,
                serialized_name: 'sourceResourceId',
                type: {
                  name: 'String'
                }
              },
              policy_id: {
                required: false,
                serialized_name: 'policyId',
                type: {
                  name: 'String'
                }
              },
              last_recovery_point: {
                required: false,
                serialized_name: 'lastRecoveryPoint',
                type: {
                  name: 'DateTime'
                }
              },
              protectedItemType: {
                required: true,
                serialized_name: 'protectedItemType',
                type: {
                  name: 'String'
                }
              },
              friendly_name: {
                required: false,
                serialized_name: 'friendlyName',
                type: {
                  name: 'String'
                }
              },
              virtual_machine_id: {
                required: false,
                serialized_name: 'virtualMachineId',
                type: {
                  name: 'String'
                }
              },
              protection_status: {
                required: false,
                serialized_name: 'protectionStatus',
                type: {
                  name: 'String'
                }
              },
              protection_state: {
                required: false,
                serialized_name: 'protectionState',
                type: {
                  name: 'Enum',
                  module: 'ProtectionState'
                }
              },
              last_backup_status: {
                required: false,
                serialized_name: 'lastBackupStatus',
                type: {
                  name: 'String'
                }
              },
              last_backup_time: {
                required: false,
                serialized_name: 'lastBackupTime',
                type: {
                  name: 'DateTime'
                }
              },
              extended_info: {
                required: false,
                serialized_name: 'extendedInfo',
                type: {
                  name: 'Composite',
                  class_name: 'AzureIaaSVMProtectedItemExtendedInfo'
                }
              }
            }
          }
        }
      end
    end
  end
end
