# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::IotHub
  module Models
    #
    # The properties of the provisioned event hub used by the Iot Hub.
    #
    class EventHubProperties

      include MsRestAzure

      # @return [Integer] The retention time in days. Range of values [For F1:
      # 1-1, S1: 1-7, S2: 1-7, S3: 1-7].
      attr_accessor :retention_time_in_days

      # @return [Integer] The partition count. Range of values [For F1: 2-2,
      # S1: 2-128, S2: 2-128, S3: 2-128].
      attr_accessor :partition_count

      # @return [Array<String>] The partition ids.
      attr_accessor :partition_ids

      # @return [String] The eventhub path.
      attr_accessor :path

      # @return [String] The endpoint.
      attr_accessor :endpoint

      # @return [Array<SharedAccessAuthorizationRule>] The internal
      # authorization rules.
      attr_accessor :internal_authorization_policies

      # @return [Array<SharedAccessAuthorizationRule>] The authorization rules.
      attr_accessor :authorization_policies


      #
      # Mapper for EventHubProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'EventHubProperties',
          type: {
            name: 'Composite',
            class_name: 'EventHubProperties',
            model_properties: {
              retention_time_in_days: {
                required: false,
                serialized_name: 'retentionTimeInDays',
                type: {
                  name: 'Number'
                }
              },
              partition_count: {
                required: false,
                serialized_name: 'partitionCount',
                type: {
                  name: 'Number'
                }
              },
              partition_ids: {
                required: false,
                serialized_name: 'partitionIds',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              path: {
                required: false,
                serialized_name: 'path',
                type: {
                  name: 'String'
                }
              },
              endpoint: {
                required: false,
                serialized_name: 'endpoint',
                type: {
                  name: 'String'
                }
              },
              internal_authorization_policies: {
                required: false,
                serialized_name: 'internalAuthorizationPolicies',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'SharedAccessAuthorizationRuleElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SharedAccessAuthorizationRule'
                      }
                  }
                }
              },
              authorization_policies: {
                required: false,
                serialized_name: 'authorizationPolicies',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'SharedAccessAuthorizationRuleElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SharedAccessAuthorizationRule'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
