/* -*-objc-*-
 *
 * Grr - Guenther's RSS Reader
 * Copyright (C) 2004-2006 Guenther Noack
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation;
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import "FeedList.h"
#import <AppKit/AppKit.h>

#import "FetchingProgressManager.h"
#import "ErrorLogController.h"

@interface MainController : NSObject
{
  id articleView;
  id mainTable;
  
  FetchingProgressManager* fetchingProgressManager;
  ErrorLogController* errorLogController;
}

-init;

- (id) articleView;

- (void) refreshMainTable;

- (void) goThereButton: (id)sender;
- (void) reloadButton: (id)sender;

- (void) fetchingProgressManager: (FetchingProgressManager*) aFPM;
- (FetchingProgressManager*) fetchingProgressManager;

- (void) errorLogController: (ErrorLogController*) aELC;
- (ErrorLogController*) errorLogController;

@end

MainController* getMainController();

