/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: stream.c,v 1.7 2000/08/13 10:40:32 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com>
 * Copyright (C) 1999 by Andrew Tridgell <tridge@linuxcare.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "sysheaders.h"

#ifdef HAVE_SYS_SENDFILE_H
#include <sys/sendfile.h>
#endif

#include "rproxy.h"
#include "util.h"
#include "header.h"
#include "trace.h"

#define USE_LINUX_SENDFILE 1

#define BUF_SIZE	8192

static ssize_t
read_write(FILE * f_in, FILE * f_out, FILE * f_copy, size_t size)
{
    char            buf[BUF_SIZE];
    ssize_t         total = 0;

    assert(f_in);
    assert(f_out);
    assert(size > 0);

    /* TODO: Allow short reads here: we'd rather get a bit of data and shoot
       it off to the client straightaway than wait until we get exactly 8kb.
       I think that's the right thing.  This probably means bypassing stdio.

       It's not terribly important, though. */

    while (size) {
	ssize_t         rc;
	ssize_t         n;
        size_t         read_size;
        
        read_size = sizeof buf;
        if (size < read_size)
            read_size = size;
            
        n = fread(buf, 1, read_size, f_in);

	if (n <= 0)
	    return total;
	if ((rc = fwrite(buf, 1, n, f_out)) < 0)
	    return rc;
	if (f_copy) {
	    if ((rc = fwrite(buf, 1, n, f_copy)) < 0)
		return rc;
	}
	total += n;
	size -= n;
    }
    return total;
}

/* Stream data from f_in to f_out, also sending a copy to f_copy if not NULL.

   TODO: Perhaps use sendfile here instead?  */
size_t
stream_body(FILE * f_in, FILE * f_out, FILE * f_copy, int content_length)
{
    ssize_t         n = 0;

    assert(f_in);
    assert(f_out);

    if (content_length != -1) {
	trace(LOGAREA_STREAM, "start known length %d bytes", content_length);
	n = read_write(f_in, f_out, f_copy, content_length);
    } else {
	int             s;

	trace(LOGAREA_STREAM, "start indefinite length");
	while ((s = read_write(f_in, f_out, f_copy, BUF_SIZE)) > 0) {
	    n += s;
	    trace(LOGAREA_STREAM, "transferred %d bytes", s);
	}
    }

    fflush(f_out);
    if (f_copy)
	fflush(f_copy);

    trace(LOGAREA_STREAM, "finished, %d bytes", n);
    return n;
}
