/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: request.c,v 1.4 2000/08/13 10:40:32 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "sysheaders.h"

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "rproxy.h"

void
rp_request_free(request_t *req)
{
    if (req->f_upstream)
	fclose(req->f_upstream);

    free(req->headers);
}


void
rp_req_set_client_addr(request_t *req, struct sockaddr *client_addr)
{
    if (client_addr) {
        struct sockaddr_in const *sain = (struct sockaddr_in const *) client_addr;
        void const *op_addr = &sain->sin_addr;

        assert(client_addr->sa_family == AF_INET); /* or INET6? */
        inet_ntop(client_addr->sa_family, op_addr,
                  req->client_addr_str, sizeof req->client_addr_str);
    
        req->client_port = ntohs(sain->sin_port);
    } else {
        /* may be called with NULL if e.g. the connection is a local pipe. */
        strcpy(req->client_addr_str,"127.0.0.1");
        req->client_port = 0;
    }
}



void
rp_req_find_local_addr(int fd, request_t *req)
{
    struct sockaddr_in sain;
    size_t len = sizeof sain;
    
    /* If we're coming from inetd (for example) then we might not know
     * our own address.  Therefore check it here to make sure. */
    
    if (!getpeername(fd, &sain, &len)  &&  sain.sin_family == AF_INET) {
        req->local_port = ntohs(sain.sin_port);
    } else {
        req->local_port = 0;
    }
}


void
rp_req_set_status(request_t *req, int status)
{
    req->status = status;
    /* TODO: Free status message? */
    req->status_msg = NULL;
}
