/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: daemon.c,v 1.7 2000/08/25 04:38:32 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

                              /*
		               | ``I'll have to ride like a flippin DEMON!!!''
		               | -- http://members.tripod.com/fredgassit/
                              */

#include "config.h"

#include "sysheaders.h"
#include <syslog.h>
#include <string.h>
#include <signal.h>

#include "trace.h"
#include "daemon.h"

#define WAIT_FOR_GDB

static void
rp_violent_death(int UNUSED(sig))
{
    int secs = 10 * 60;
    
    sleep(secs);                 /* you should ptrace me now */

    abort();
}


/* Hook all the signals that could kill us; try to emit a trace message
 * before we go. */
void
rp_hook_death(void)
{
    struct sigaction act;

    hs_bzero(&act, sizeof act);

    act.sa_handler = rp_violent_death;
    act.sa_flags = SA_ONESHOT;
    
    sigaction(SIGINT,  &act, NULL);
    sigaction(SIGABRT, &act, NULL);
    sigaction(SIGSEGV, &act, NULL);
    sigaction(SIGBUS, &act, NULL);
    sigaction(SIGFPE, &act, NULL);
}


static void
_rp_be_childish(void)
{
    switch (fork()) {
    case -1:
        rp_log(LOGAREA_PROCESS, LOG_ERR, "can't fork: %s", strerror(errno));
        exit(1);

    case 0:
        return;

    default:
        /* parent just goes away and we keep running in the child */
        exit(0);
    }
}



/*
 * Close standard file descriptors when becoming a daemon.  This saves
 * FDs and is considered good practice.
 */
static void
_rp_daemon_close_fds(void)
{
    /* We don't do this yet. */
}


/*
 * This is a little bit of Unix magic to become a well-behaved daemon.
 * See Stevens or the comp.unix.programmer FAQ for more explanation.
 *
 * This is not called if we're coming from inetd.  
 */
void
rp_become_daemon(void)
{
    /* Ignore SIGHUP for the moment. */
    signal(SIGHUP,  SIG_IGN);

    /* fork so that the parent can exit, this returns control to the command
     * line or shell invoking your program.  This step is required so that
     * the new process is guaranteed not to be a process group leader. */
    _rp_be_childish();

    /* setsid to become a process group and session group
     * leader. Since a controlling terminal is associated with a
     * session, and this new session has not yet acquired a
     * controlling terminal our process now has no controlling
     * terminal, which is a Good Thing for daemons. */
    setsid();

    /* fork again so the parent, (the session group leader), can exit. This 
     * means that we, as a non-session group leader, can never regain a
     * controlling terminal. */
    _rp_be_childish();

    /* XXX: Where will chroot fit in? */
    
    /* chdir / to ensure that our process doesn't keep any directory in use.
     * Failure to do this could make it so that an administrator couldn't
     * unmount a filesystem, because it was our current directory.
     *
     * Equivalently, we could change to any directory containing files
     * important to the daemon's operation.  Would the cache be better? */
    if (chdir("/") == -1) {
        rp_log(LOGAREA_PROCESS, LOG_ERR,
                     "can't chdir to /: %s", strerror(errno));
        exit(0);
    } 

    trace(LOGAREA_PROCESS, "forked daemon parent process %d", getpid());

    /* TODO: umask() is recommended ? but it doesn't matter a lot to
     * rproxy at the moment. */

    _rp_daemon_close_fds();
}

