/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: d-headerrpt.c,v 1.1 2000/08/14 02:24:29 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "config.h"
#include "sysheaders.h"

#include <stdio.h>

#include "error.h"
#include "util.h"
#include "header.h"

/*
 * usage: d-headerrpt headername value1 value2 value3
 *
 * Write out first all the separate headers; then the combined value.
 */

int main(int argc, char **argv)
{
    char const *h_name = argv[1];
    int i;
    header_set_t *set;

    set = header_set_new();
    
    for (i = 2; i < argc; i++) {
        header_add(set, h_name, argv[i]);
    }

    header_send(set, stdout);

    puts(header_content_all(set, h_name));

    return 0;
}
