#include "allegro.h"
#include "spaceobj.h"
#include "trigtable.h"
#include "hull_weapon.h"
#include "hull_weapon_s_l.h"

SL_WHull::SL_WHull():
HullWeapon( 0, 1, 3 ),
r1( 0 ),
r2( 3 ){}

void SL_WHull::Draw( BITMAP * who, int x, int y ) {

	int col1 = makecol( 255, 0, 0 );
	int col2 = makecol( 255, 250, 250 );

	if ( r1 > r2 ) {
		circlefill( who, x, y, r1, col1 );
		circlefill( who, x, y, r2, col2 );
	}
	else {
		circlefill( who, x, y, r2, col2 );
		circlefill( who, x, y, r1, col1 );
	}
	r2++;
	r1++;
	if ( r2 > 5 )
		r2 = 1;
	if ( r1 > 5 )
		r1 = 1;
}


bool SL_WHull::Collide( int mx, int my, SpaceObject * check ) {
	if ( check->HitMe( mx, my ) )
		return true;
	#define LARGE 5

	for ( int sang = 0; sang < 360; sang += 45 ) {

		int ax = (int)(mx + tcos[sang]*LARGE );
		int ay = (int)(my + tsine[sang]*LARGE );
		if ( check->HitMe( ax, ay ) )
			return true;

	}

	return false;

}
