/***************************************************************************
 *            field.h
 *
 *  Fri Aug 25 14:59:55 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _FIELD_H
#define _FIELD_H

/** @file field.h
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner, Jay MacDonald
	@author Copyright 1999  Sam Phillips, Keith Wesolowski. 
*/

/** \brief Structure to store each field's information in memory */
typedef struct 
{
	gint16 sheet_column; /**< which sheet column it goes in */
	QlFieldType type; /**< type of field 1: alpha 2: numeric 3: date 4: time */
	/** values from 0 to n 
	
	\bug used for QlDateFormat and QlCurrFormat
	*/
	gint16 formatting;
	gint16 decimal_places;
	gint16 justification; /**< Uses GTK-JUSTIFY_LEFT, RIGHT, CENTER */
	gint16 unused1, unused2;
	gint16 width;  /**< display width in characters */
	gchar * name;
} QlFieldInfo;

/* for Column Menu */
void column_add (GtkAction * w, gpointer data);
void column_edit (GtkAction * w, gpointer data);
void column_delete (GtkAction * w, gpointer data);
void column_left (GtkAction * w, gpointer data);
void column_right (GtkAction * w, gpointer data);
void new_file (GtkAction * w, gpointer data);

gint16 go_edit_column ();

#endif /* _FIELD_H */
