/***************************************************************************
 *            dim_list_menu.c
 *
 *  Fri Aug 25 14:48:06 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file dim_list_menu.c
	@brief Functions to dim out the various list mode menus 
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner
*/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "config.h"
#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <gtkextra/gtksheet.h>
#include "types.h"
#include "dim_list_menu.h"
#include "menus.h"
#include "main.h"
#include "filein.h"
#include "dialog_initial.h"

static void
dim_list_empty_menu (QlContext * qlc)
{
	menus_set_sensitive (qlc, "/menubar/FileMenu/SaveAs", FALSE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Close", FALSE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Export", FALSE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Print", FALSE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Preview", FALSE);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Selectall", FALSE);
/*	menus_set_sensitive (qlc, "/menubar/SortMenu/SortAdd", FALSE);*/
/*	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterShow", FALSE);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterAdd", FALSE);*/
/*	menus_set_sensitive (qlc, "/menubar/ReportMenu/ReportAdd", FALSE);*/
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnAdd", FALSE);
/*	menus_set_sensitive (qlc, "/menubar/ToolsMenu/ToolsFind", FALSE);
	menus_set_sensitive (qlc, "/menubar/ToolsMenu/ToolsMatch", FALSE);*/
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Print", FALSE);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Preview", FALSE);
}

void
dim_list_tab_open_menu (QlContext * qlc)
{
	menus_set_sensitive (qlc, "/menubar/FileMenu/SaveAs", TRUE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Close", TRUE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Export", TRUE);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Selectall", TRUE);
/*	menus_set_sensitive (qlc, "/menubar/SortMenu/SortAdd", TRUE);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterShow", TRUE);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterAdd", TRUE);
	menus_set_sensitive (qlc, "/menubar/ReportMenu/ReportAdd", TRUE);*/
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnAdd", TRUE);
/*	menus_set_sensitive (qlc, "/menubar/ToolsMenu/ToolsFind", TRUE);
	menus_set_sensitive (qlc, "/menubar/ToolsMenu/ToolsMatch", TRUE);*/
}

void
dim_all_menus (QlContext * qlc)
{
	QlDisplayMode mode;
	QlTabData * tab;
	GtkWidget *menuitem, * recentmenu;
	GtkRecentFilter * filter;

	tab = NULL;
	g_return_if_fail (qlc);
	tab = ql_get_tabdata (qlc);
	if (tab == NULL)
		mode = DISPLAY_EMPTY;
	else
		mode = tab->view->display_mode;
	switch (mode)
	{
		case DISPLAY_LIST :
		{
			dim_list_file_menu (qlc);
			dim_list_edit_menu (qlc);
			dim_list_sort_menu (qlc);
			dim_list_filter_menu (qlc);
			dim_list_report_menu (qlc);
			dim_list_column_menu (qlc);
			dim_list_tab_open_menu (qlc);
			break;
		}
		case DISPLAY_REPORT :
		case DISPLAY_EDIT : /* don't do if print on screen */
		{
			dim_report_file_menu (qlc);
			dim_report_column_menu (qlc);
			dim_report_totals_menu (qlc);
			dim_list_tab_open_menu (qlc);
			break;
		}
		case DISPLAY_EMPTY :
		{
			dim_list_file_menu (qlc);
			dim_list_edit_menu (qlc);
			dim_list_sort_menu (qlc);
			dim_list_filter_menu (qlc);
			dim_list_report_menu (qlc);
			dim_list_column_menu (qlc);
			dim_list_empty_menu (qlc);
			break;
		}
		case DISPLAY_PRINT : 
		{
			dim_list_tab_open_menu (qlc);
			break;
		}
	}
	menuitem = gtk_ui_manager_get_widget (qlc->menu_manager, 
			"/menubar/FileMenu/RecentMenu");
	/** \bug can't get the recent filter to work reliably. */
	recentmenu = gtk_recent_chooser_menu_new_for_manager (qlc->recent_manager);
/*	recentmenu = gtk_recent_chooser_menu_new ();
*/	filter = gtk_recent_filter_new ();
/*	gtk_recent_filter_add_group (filter, PACKAGE);
	gtk_recent_filter_set_name (filter, _("QuickList files *.qlf"));
	gtk_recent_filter_add_pattern (filter, "file: *.qlf");
//	gtk_recent_filter_add_mime_type (filter, "application/x-quicklist");
//	gtk_recent_chooser_set_sort_type (GTK_RECENT_CHOOSER (recentmenu), GTK_RECENT_SORT_MRU);
	gtk_recent_chooser_set_show_not_found (GTK_RECENT_CHOOSER(recentmenu), TRUE);
	gtk_recent_chooser_set_local_only (GTK_RECENT_CHOOSER(recentmenu), TRUE);
	gtk_recent_chooser_set_filter (GTK_RECENT_CHOOSER(recentmenu), filter);
*/	if (menuitem)
	{
		gtk_menu_item_set_submenu (GTK_MENU_ITEM(menuitem), recentmenu);
		g_signal_connect (GTK_OBJECT(recentmenu), "item-activated",
			G_CALLBACK(open_recent), qlc);
	}
	else
		g_message ("failed to initialise recent files submenu.");
}

void
dim_list_file_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean new = TRUE;
	gboolean open = TRUE;
	gboolean import = TRUE;
	gboolean changed = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab)
		changed = tab->file->changed;
	menus_set_sensitive (qlc, "/menubar/FileMenu/Newlist", new);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Open", open);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Save", changed);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Import", import);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Newlist", new);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Open", open);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Save", changed);
}

void
dim_list_edit_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean cut = FALSE;
	gboolean clear = FALSE;
	gboolean copy = FALSE;
	gboolean ditto = FALSE;
	gboolean paste = FALSE;
	gboolean fill = FALSE;
	gboolean insert = FALSE;
	QlSelectMode sel_type = 0;

	tab = ql_get_tabdata (qlc);
	if (tab)
		sel_type = tab->view->sel_type;
	if (sel_type)
	{
		clear = copy = cut = paste = TRUE;
		if (tab->view->sel_range.rowi != tab->view->sel_range.row0)
			fill = TRUE;
		if (tab->view->sel_type == SELECT_ENTRY)
			ditto = TRUE;
		if (tab->view->sel_type != SELECT_COLUMN)
			insert = TRUE;
	}
	menus_set_sensitive (qlc, "/menubar/EditMenu/Cut", cut);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Copy", copy);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Copydown", ditto);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Clear", clear);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Filldown", fill);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Insertrows", insert);
	menus_set_sensitive (qlc, "/menubar/EditMenu/Paste", 
		paste_is_ok (tab));

	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Cut", cut);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Copy", copy);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Clear", clear);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Paste", 
		paste_is_ok (tab));
}	/* End of list_dim_edit */

void
dim_list_sort_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean add = FALSE;
	gboolean column = FALSE;
	gboolean apply = FALSE;
	gboolean edit = FALSE;
	gboolean delete = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab)
	{
		if (tab->view->sel_type == SELECT_COLUMN || 
				tab->view->sel_type == SELECT_ENTRY)
			column = TRUE;
	
		if (tab->file->sort_ct)
			apply = edit = delete = TRUE;
	
		if (tab->file->sort_ct < MAX_SORTS)
			add = TRUE;
	
		/* ie, need two real rows plus last row */
		if (tab->file->last_row <= 1)
			apply = column = FALSE;
	}

/*	menus_set_sensitive (qlc, "/menubar/SortMenu/SortAdd", add);
	menus_set_sensitive (qlc, "/menubar/SortMenu/SortApply", apply);
	menus_set_sensitive (qlc, "/menubar/SortMenu/SortEdit", edit);
	menus_set_sensitive (qlc, "/menubar/SortMenu/SortDelete", delete);*/
	menus_set_sensitive (qlc, "/menubar/SortMenu/SortColumn", column);
}	/* end of dim_list_sort_menu */

void
dim_list_filter_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean show = FALSE;
	gboolean apply = FALSE;
	gboolean edit = FALSE;
	gboolean delete = FALSE;
//	gboolean add = FALSE;

	tab = ql_get_tabdata (qlc);
	show = TRUE;

	if (tab)
	{
		if (tab->file->filter_ct)
			apply = edit = delete = TRUE;
	}
/*
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterShow", show);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterApply", apply);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterEdit", edit);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterDelete", delete);
	menus_set_sensitive (qlc, "/menubar/FilterMenu/FilterAdd", add);*/
}	/* end of dim_list_filter_menu */

void
dim_list_report_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean mselect = FALSE;
//	gboolean add = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab)
	{
		if (tab->file->report_ct > 0)
		{
			mselect = TRUE;
		}
	}
	menus_set_sensitive (qlc, "/menubar/FileMenu/Print", TRUE);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Preview", TRUE);
	menus_set_sensitive (qlc, "/menubar/ReportMenu/ReportSelect", mselect);
/*	menus_set_sensitive (qlc, "/menubar/ReportMenu/ReportAdd", add);*/
}	/* end of dim_list_report_menu */

void
dim_list_column_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean add = FALSE;
	gboolean edit = FALSE;
	gboolean delete = FALSE;
	gboolean right = FALSE;
	gboolean left = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab)
	{
		if (tab->view->sel_range.col0 == tab->view->sel_range.coli)
		{
			if (tab->file->last_field < MAX_FIELDS - 1)
				add = TRUE;
			if (tab->view->sel_type == SELECT_COLUMN)
			{
				edit = TRUE;
				if (tab->file->last_field)
				{					/* ie two or more fields */
					delete = TRUE;
					if (tab->view->sel_range.coli < tab->file->last_field)
						right = TRUE;
					if (tab->view->sel_range.col0)
						left = TRUE;
				}
			}
		}
	}
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnAdd", add);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnEdit", edit);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnDelete", delete);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnLeft", left);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnRight", right);
}	/* end of dim_list_column_menu */

void
dim_report_file_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean new = FALSE;
	gboolean open = FALSE;
	gboolean import = FALSE;

	tab = ql_get_tabdata (qlc);

	menus_set_sensitive (qlc, "/menubar/FileMenu/Newlist", new);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Open", open);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Save", 
		tab->file->changed);
	menus_set_sensitive (qlc, "/menubar/FileMenu/Import", import);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Newlist", new);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Open", open);
	menus_set_sensitive (qlc, "/MainMenuBar/ToolItems/Save", 
		tab->file->changed);
}

void
dim_report_column_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean rep_add = FALSE;
	gboolean rep_delete = FALSE;
	gboolean rep_right = FALSE;
	gboolean rep_left = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab->file->report_ptr->last_column < MAX_FIELDS - 1)
		rep_add = TRUE;

	if (tab->view->report_sel_col >= 0)
		if (tab->file->report_ptr->last_column)
		{
			/* ie two or more columns */
			rep_delete = TRUE;
			if (tab->view->report_sel_col < tab->file->report_ptr->last_column)
				rep_right = TRUE;
			if (tab->view->report_sel_col)
				rep_left = TRUE;
		}
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnAdd", rep_add);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnDelete", rep_delete);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnRight", rep_right);
	menus_set_sensitive (qlc, "/menubar/ColumnMenu/ColumnLeft", rep_left);
}	/* end of dim_report_column_menu */

void
dim_report_totals_menu (QlContext * qlc)
{
	QlTabData * tab;
	gboolean group = FALSE;
	gboolean total = FALSE;

	tab = ql_get_tabdata (qlc);
	if (tab->view->report_sel_col >= 0)
	{
		QlFieldInfo * field;
		group = TRUE;
		field = ql_get_fieldinfo (tab, tab->view->report_sel_field);
		if (field->type == 2)
			total = TRUE;
	}
/*
	menus_set_sensitive (qlc, "/menubar/TotalsMenu/TotalsGroup", group);
	menus_set_sensitive (qlc, "/menubar/TotalsMenu/TotalsTotals", total);*/
}	/* end of dim_report_totals_menu */

gboolean
paste_is_ok (QlTabData * tab)
{
	QlSelectMode sel_type = SELECT_NONE;
	if (!tab)
		return FALSE;
	if (tab)
		sel_type = tab->view->sel_type;
/*	if (!tab->view->sel_type || !cb_sel_type)
		return FALSE;*/
	switch (sel_type)
	{
	case SELECT_ROW:
		if (tab->view->sel_type == SELECT_COLUMN)
			return FALSE;

	case SELECT_COLUMN:
		if (tab->view->sel_type != SELECT_COLUMN)
			return FALSE;

	case SELECT_BLOCK:
		if (tab->view->sel_type != SELECT_BLOCK && 
				tab->view->sel_type != SELECT_ENTRY)
			return FALSE;

	case SELECT_ENTRY:
		if (tab->view->sel_type != SELECT_ENTRY)
			return FALSE;
	
	default :
		return TRUE;
	}
}	/* end of paste_is_ok */
