/* file io for QuickList */

/*  Quicklist
 *  www.quicklist.org for more information.
 *
 *  Copyright (C) 1999 Robert Lissner
 *                     Jay MacDonald
 *                     Sam Phillips
 *                     Keith Wesolowski
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "includes.h"
#include "globals.h"

#define TO_FILE    1
#define TO_PRINTER 2

typedef struct  
{
  gint      output_dev;
  GtkWidget *win;
  GtkWidget *printer;
  GtkWidget *file;
  GtkWidget *file_name;
  GtkWidget *browse;
  GtkWidget *print_command;

/*
  GtkWidget *start_page;
  GtkWidget *end_page; 
*/

  GtkWidget *file_sel;
} print_dlg_ctx;

/* Globals suck ... but I'm too lazy to fix the offending code */
extern GtkText *text_box;

void file_print_change_output (GtkWidget*, gpointer);
void file_print_select_dlg (GtkWidget*, gpointer);
void file_print_select (GtkWidget*, gpointer);
void file_print_select_close (GtkWidget*,gpointer);
void file_print_close (GtkWidget*,gpointer);
void file_print (GtkWidget*,gpointer);

void 
file_print_dlg (GtkObject *obj, gpointer *data)
{
  GtkWidget *win,
            *table, 
            *ok_button,
            *cancel_button,
            *print_to_label,
            *vbox,
            *select_printer,
            *select_file,
            *print_command_label,
            *print_command_text,
            *file_name_label,
            *file_name_text,
            *browse_button;
/*
            *start_page_label,
            *start_page_text,
            *end_page_label,
            *end_page_text;
*/
  GSList *output_select;
  print_dlg_ctx *ctx;

  win = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW(win), _("Print"));
  gtk_window_set_policy (GTK_WINDOW(win), 0, 0, 1);

  table = gtk_table_new (5, 3, FALSE);
  gtk_container_border_width (GTK_CONTAINER(table), 10);
  gtk_table_set_row_spacings (GTK_TABLE(table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(table), 5);
  gtk_container_add (GTK_CONTAINER(GTK_DIALOG(win)->vbox), table);

  ok_button = gtk_button_new_with_label (_("OK"));
  gtk_container_add (GTK_CONTAINER(GTK_DIALOG(win)->action_area), ok_button);
  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_container_add (GTK_CONTAINER(GTK_DIALOG(win)->action_area), 
                     cancel_button);

  print_to_label = gtk_label_new (_("Print Command:"));
  gtk_table_attach_defaults (GTK_TABLE(table), print_to_label, 0, 1, 0, 1); 

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(table), vbox, 1, 2, 0, 1);

  select_printer = gtk_radio_button_new_with_label (NULL, _("Printer"));
  output_select = gtk_radio_button_group (GTK_RADIO_BUTTON(select_printer));
  select_file = gtk_radio_button_new_with_label (output_select, _("File"));
  gtk_container_add (GTK_CONTAINER(vbox), select_printer);
  gtk_container_add (GTK_CONTAINER(vbox), select_file);

  print_command_label = gtk_label_new (_("Print Command:"));
  print_command_text = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY(print_command_text), PRINT_COMMAND);
  gtk_table_attach_defaults (GTK_TABLE(table), print_command_label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE(table), print_command_text, 1, 3, 1, 2);

  file_name_label = gtk_label_new (_("File Name:"));
  file_name_text = gtk_entry_new ();
  gtk_widget_set_sensitive (file_name_text, FALSE);
  browse_button = gtk_button_new_with_label (_("Browse"));
  gtk_widget_set_sensitive (browse_button, FALSE);
  gtk_table_attach_defaults (GTK_TABLE(table), file_name_label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE(table), file_name_text, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE(table), browse_button, 2, 3, 2, 3);

/*
  start_page_label = gtk_label_new (_("Start Page:"));
  start_page_text = gtk_entry_new ();
  end_page_label = gtk_label_new (_("End Page:"));
  end_page_text = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE(table), start_page_label, 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE(table), start_page_text, 1, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE(table), end_page_label, 0, 1, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE(table), end_page_text, 1, 2, 4, 5);
*/

  ctx = (print_dlg_ctx*) g_malloc (sizeof(print_dlg_ctx));
  ctx->output_dev = TO_PRINTER;
  ctx->win = win;
  ctx->printer = select_printer;
  ctx->file = select_file;
  ctx->file_name = file_name_text;
  ctx->browse = browse_button;
  ctx->print_command = print_command_text; 

/*
  ctx->start_page = start_page_text;
  ctx->end_page = end_page_text;  
*/

  /* set up the radio buttons */
  gtk_signal_connect (GTK_OBJECT (select_file), "clicked",
                      GTK_SIGNAL_FUNC (file_print_change_output), ctx);
  gtk_signal_connect (GTK_OBJECT (select_printer), "clicked",
                      GTK_SIGNAL_FUNC (file_print_change_output), ctx);

  /* callback to select a file to print to */
  gtk_signal_connect (GTK_OBJECT (browse_button), "clicked",
                      GTK_SIGNAL_FUNC (file_print_select_dlg), ctx);

  /* callbacks for ok and cancel buttons */
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (file_print), ctx);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (file_print_close), ctx);  

  gtk_window_set_transient_for (GTK_WINDOW (win), 
                                GTK_WINDOW (front->report_win));
/*
  gtk_widget_show (end_page_text);
  gtk_widget_show (end_page_label);
  gtk_widget_show (start_page_text);
  gtk_widget_show (start_page_label);
*/

  gtk_widget_show (browse_button);
  gtk_widget_show (file_name_text);
  gtk_widget_show (file_name_label);
  gtk_widget_show (print_command_text);
  gtk_widget_show (print_command_label);
  gtk_widget_show (select_file);
  gtk_widget_show (select_printer);
  gtk_widget_show (vbox);
  gtk_widget_show (print_to_label);
  gtk_widget_show (ok_button);
  gtk_widget_show (cancel_button);
  gtk_widget_show (table);
  gtk_widget_show (win);
}

void
file_print_change_output (GtkWidget *w, gpointer data)
{
  print_dlg_ctx *ctx;

  g_return_if_fail (w != NULL);
  g_return_if_fail (GTK_IS_RADIO_BUTTON(w));

  ctx = (print_dlg_ctx*) data;

  if (w == ctx->file) 
  {
    gtk_widget_set_sensitive (ctx->file_name, TRUE);
    gtk_widget_set_sensitive (ctx->browse, TRUE);
    gtk_widget_set_sensitive (ctx->print_command, FALSE);
    ctx->output_dev = TO_FILE;
  } else {
    gtk_widget_set_sensitive (ctx->file_name, FALSE);
    gtk_widget_set_sensitive (ctx->browse, FALSE);
    gtk_widget_set_sensitive (ctx->print_command, TRUE);
    ctx->output_dev = TO_PRINTER;
  }
}

void
file_print_select_dlg (GtkWidget *w, gpointer data)
{
  GtkWidget *file_sel;
  print_dlg_ctx *ctx;

  ctx = (print_dlg_ctx*) data;

  file_sel = gtk_file_selection_new (_("Print to File"));
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (file_sel));

  ctx->file_sel = file_sel;

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_sel)->ok_button),
                      "clicked", GTK_SIGNAL_FUNC (file_print_select), data);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_sel)->cancel_button),
                      "clicked", GTK_SIGNAL_FUNC (file_print_select_close), 
                      data);

  gtk_widget_show (file_sel);
}

void
file_print_select (GtkWidget *w, gpointer data)
{
  print_dlg_ctx *ctx;

  ctx = (print_dlg_ctx*) data;
  gtk_entry_set_text (GTK_ENTRY (ctx->file_name),
                      gtk_file_selection_get_filename
                          (GTK_FILE_SELECTION (ctx->file_sel)));
  file_print_select_close (w, data);
}

void 
file_print_select_close (GtkWidget *w, gpointer data)
{
  print_dlg_ctx *ctx = (print_dlg_ctx*)data;

  /* just in case something funky happens */
  g_return_if_fail (GTK_IS_FILE_SELECTION (ctx->file_sel));

  gtk_widget_destroy (ctx->file_sel);
}

void
file_print_close (GtkWidget *w, gpointer data)
{
  print_dlg_ctx *ctx = (print_dlg_ctx*)data;
  gtk_widget_destroy (ctx->win);
  g_free (ctx);
}

void 
file_print (GtkWidget *w, gpointer data)
{
  gchar *print_data;
  print_dlg_ctx *ctx;
  FILE *out_dev = NULL;
  gchar* out_name = NULL;

  ctx = (print_dlg_ctx*)data;

  /* this definately needs more error checking */

  switch (ctx->output_dev)
  {
    case TO_PRINTER:
      out_name = gtk_entry_get_text (GTK_ENTRY (ctx->print_command));
      out_dev = popen (out_name,"w");
      break;
    case TO_FILE:
      out_dev = fopen (gtk_entry_get_text (GTK_ENTRY (ctx->file_name)), "w");
      break;
    default:
      g_warning ("Printing difficulties");
      /* bad juju has happend somewhere */
      /* do something to reflect catastrophe */
  } 
  
  if (out_dev == NULL) 
  {
    level1_error (_("There was an error printing the file"), _("Go back"));
    return;
  }

  print_data = 
    (gchar*) gtk_editable_get_chars (GTK_EDITABLE (text_box), 0, -1);
  fprintf (out_dev, print_data);

  /* hmmm need to check if just plain close will work here */
  switch (ctx->output_dev)
  {
    case TO_PRINTER:
      pclose (out_dev);
      break;
    case TO_FILE:
      fclose (out_dev);
      break;
  }

  file_print_close (w, data);
}

void file_page_setup (GtkWidget *w, gpointer *data){;}

