

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Indexes.i,v 1.6 2002/01/16 14:51:30 nando Exp $

#ifndef quantlib_indexes_i
#define quantlib_indexes_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Types.i
%include TermStructures.i
%include String.i


// base index class

%{
using QuantLib::Handle;
using QuantLib::Index;
typedef Handle<Index> IndexHandle;
%}

// export Handle<Index>
%name(Index) class IndexHandle {
  private:
    // abstract class - no constructor exported
    IndexHandle();
  public:
    ~IndexHandle();
};

// replicate the Index interface
%addmethods IndexHandle {
    void crash() {}
    Rate fixing(Date fixingDate) {
        return (*self)->fixing(fixingDate);
    }
    String name() {
        return (*self)->name();
    }
    String __str__() {
        if (!self->isNull())
            return (*self)->name()+" index";
        else
            return "Null index";
    }
}


// Xibor indexes
%{
using QuantLib::Indexes::Xibor;
using QuantLib::Indexes::Euribor;
using QuantLib::Indexes::GBPLibor;
using QuantLib::Indexes::USDLibor;
typedef Handle<Xibor> XiborHandle;
typedef Handle<Euribor> EuriborHandle;
typedef Handle<GBPLibor> GBPLiborHandle;
typedef Handle<USDLibor> USDLiborHandle;
%}

// fake inheritance between handles
%name(Xibor) class XiborHandle : public IndexHandle {
  public:
    // constructor defined below as string-based factory
    ~XiborHandle();
};

// replicate the Xibor interface
%addmethods XiborHandle {
    void crash() {}
    XiborHandle(String name, int n, TimeUnit units,
                TermStructureRelinkableHandle h) {
        String s = StringFormatter::toLowercase(name);
        if (s == "euribor")
            return new XiborHandle(new Euribor(n,units,h));
        else if (s == "gbplibor")
            return new XiborHandle(new GBPLibor(n,units,h));
        else if (s == "usdlibor")
            return new XiborHandle(new USDLibor(n,units,h));
        else
            throw Error("unknown index: " + name);
        QL_DUMMY_RETURN(new XiborHandle);
    }
    Period tenor() {
        return (*self)->tenor();
    }
    Currency currency() {
        return (*self)->currency();
    }
    Calendar calendar() {
        return (*self)->calendar();
    }
    bool isAdjusted() {
        return (*self)->isAdjusted();
    }
    RollingConvention rollingConvention() {
        return (*self)->rollingConvention();
    }
    DayCounter dayCounter() {
        return (*self)->dayCounter();
    }
}


%name(Euribor) class EuriborHandle : public XiborHandle {
  public:
    // constructor redefined below
    ~EuriborHandle();
};

%addmethods EuriborHandle {
    void crash() {}
    EuriborHandle(int n, TimeUnit units,
        TermStructureRelinkableHandle h) {
            return new EuriborHandle(new Euribor(n,units,h));
    }
}

%name(GBPLibor) class GBPLiborHandle : public XiborHandle {
  public:
    // constructor redefined below
    ~GBPLiborHandle();
};

%addmethods GBPLiborHandle {
    void crash() {}
    GBPLiborHandle(int n, TimeUnit units,
        TermStructureRelinkableHandle h) {
            return new GBPLiborHandle(new GBPLibor(n,units,h));
    }
}

%name(USDLibor) class USDLiborHandle : public XiborHandle {
  public:
    // constructor redefined below
    ~USDLiborHandle();
};

%addmethods USDLiborHandle {
    void crash() {}
    USDLiborHandle(int n, TimeUnit units,
        TermStructureRelinkableHandle h) {
            return new USDLiborHandle(new USDLibor(n,units,h));
    }
}


#endif
