#include <boost/python/detail/wrap_python.hpp>

#include "num_util.h"

#include <cassert>

/* num_util.h and num_util.cpp were obtained from: 
 * http://www.eos.ubc.ca/research/clouds/num_util.html on 2003-12-17 under the 
 * terms and conditions of the Boost license version 1.0.  num_util was written 
 * by Rhys Goldstein, Chris Seymour and Phil Austin.  

 * Questions or comments about num_util should be directed to Phil Austin at 
 * paustin@eos.ubs.ca.
 */
 
/*
Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/


namespace { 
	const char* rcsid = "$Id: num_util.cpp,v 1.1 2004/12/22 16:25:49 jbrandmeyer Exp $";
}

// Moved into the visual namespace to prevent clashes with other projects using
// num_util --Jonathan Brandmeyer
namespace visual {

// Keep syncronized with num_util_impl.hpp
array (*makeNum_impl)(std::vector<int>, array_types) = 0;
array_types (*type_impl)(array) = 0;
std::vector<int> (*shape_impl)(array) = 0;
bool (*iscontiguous_impl)(array) = 0;
char* (*data_impl)(const array&) = 0;
array (*astype_impl)(array, array_types) = 0;
  
//Create a Numeric array with dimensions dimens and Numeric type t
array 
makeNum(std::vector<int> dimens, array_types t)
{
	assert( makeNum_impl != 0);
	return makeNum_impl( dimens, t);
}

array_types
type(array arr)
{
	assert( type_impl != 0);
	return type_impl( arr);
}

std::vector<int> 
shape(const array& arr) 
{
	assert( shape_impl != 0);
	return shape_impl( arr);
}

bool 
iscontiguous(array arr)
{
	assert( iscontiguous_impl != 0);
	return iscontiguous_impl( arr);
}

char* 
data(const array& arr)
{
	assert( data_impl != 0);
	return data_impl( arr);
}
  
// Return a clone of this array with a new type
array 
astype(array arr, array_types t)
{
	assert( astype_impl != 0);
	return astype_impl( arr, t);
}

} // !namespace visual
